/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.List;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;
import org.rhq.enterprise.server.resource.disambiguation.ResourceResolution;

public class DisambiguationPolicy
extends ArrayList<Level> {
    private static final long serialVersionUID = 1L;
    private DisambiguationUpdateStrategy parentsUpdateStrategy;
    private List<String> ambiguousTypeNames;

    public DisambiguationPolicy(DisambiguationUpdateStrategy parentsDisambiguationStrategy, List<String> ambiguousTypeNames) {
        this.parentsUpdateStrategy = parentsDisambiguationStrategy;
        this.ambiguousTypeNames = ambiguousTypeNames;
    }

    public DisambiguationPolicy(DisambiguationPolicy other) {
        for (Level level : other) {
            this.add(new Level(level.resourceResolution, level.deciding));
        }
        this.parentsUpdateStrategy = other.parentsUpdateStrategy;
        this.ambiguousTypeNames = other.ambiguousTypeNames;
    }

    public static DisambiguationPolicy getUniqueNamePolicy(DisambiguationUpdateStrategy parentsDisambiguationStrategy, List<String> ambiguousTypeNames) {
        DisambiguationPolicy ret = new DisambiguationPolicy(parentsDisambiguationStrategy, ambiguousTypeNames);
        ret.add(new Level(ResourceResolution.NAME));
        return ret;
    }

    public DisambiguationUpdateStrategy getParentsUpdateStrategy() {
        return this.parentsUpdateStrategy;
    }

    public void setParentsUpdateStrategy(DisambiguationUpdateStrategy parentsUpdateStrategy) {
        this.parentsUpdateStrategy = parentsUpdateStrategy;
    }

    public List<String> getAmbiguousTypeNames() {
        return this.ambiguousTypeNames;
    }

    public void setAmbiguousTypeNames(List<String> ambiguousTypeNames) {
        this.ambiguousTypeNames = ambiguousTypeNames;
    }

    public <T> boolean areAmbiguous(MutableDisambiguationReport<T> a, MutableDisambiguationReport<T> b) {
        MutableDisambiguationReport.Resource ra = this.getComparingResource(a);
        MutableDisambiguationReport.Resource rb = this.getComparingResource(b);
        if (ra == null || rb == null) {
            return false;
        }
        Level level = this.getCurrentLevel();
        if (level != null) {
            return level.getResourceResolution().areAmbiguous(ra, rb);
        }
        return false;
    }

    public Level getCurrentLevel() {
        return this.size() > 0 ? (Level)this.get(this.size() - 1) : null;
    }

    public DisambiguationPolicy getNext() {
        int lastIdx = this.size() - 1;
        ResourceResolution lastResolution = ((Level)this.get(lastIdx)).getResourceResolution();
        DisambiguationPolicy ret = new DisambiguationPolicy(this);
        switch (lastResolution) {
            case NAME: {
                ((Level)ret.get(lastIdx)).resourceResolution = ResourceResolution.TYPE;
                break;
            }
            case TYPE: {
                ((Level)ret.get(lastIdx)).resourceResolution = ResourceResolution.PLUGIN;
                break;
            }
            case PLUGIN: {
                ret.add(new Level(ResourceResolution.NAME));
            }
        }
        return ret;
    }

    public DisambiguationPolicy getNextRepartitioningPolicy() {
        ResourceResolution currentResolution = this.getCurrentLevel().getResourceResolution();
        if (this.parentsUpdateStrategy.alwaysRepartitionableResolutions().contains((Object)currentResolution) || this.size() == 1 && this.parentsUpdateStrategy.resourceLevelRepartitionableResolutions().contains((Object)currentResolution)) {
            DisambiguationPolicy newPolicy = this.getNext();
            if (currentResolution == ResourceResolution.TYPE) {
                newPolicy = newPolicy.getNext();
                ((Level)newPolicy.get(newPolicy.size() - 2)).resourceResolution = ResourceResolution.TYPE;
            }
            return newPolicy;
        }
        return null;
    }

    private <T> MutableDisambiguationReport.Resource getComparingResource(MutableDisambiguationReport<T> report) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return report.resource;
        }
        int parentIdx = size - 2;
        if (report.parents.size() > parentIdx) {
            return report.parents.get(parentIdx);
        }
        return null;
    }

    public static class Level {
        private ResourceResolution resourceResolution;
        private boolean deciding;

        public Level(ResourceResolution resourceResolution) {
            this(resourceResolution, false);
        }

        public Level(ResourceResolution resourceResolution, boolean deciding) {
            this.resourceResolution = resourceResolution;
            this.deciding = deciding;
        }

        public boolean isDeciding() {
            return this.deciding;
        }

        public void setDeciding(boolean deciding) {
            this.deciding = deciding;
        }

        public ResourceResolution getResourceResolution() {
            return this.resourceResolution;
        }

        public String toString() {
            return "Level[" + (Object)((Object)this.resourceResolution) + (this.deciding ? ", deciding]" : ", not deciding]");
        }
    }
}

