/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.domain;

import com.wordnik.swagger.annotations.ApiClass;
import com.wordnik.swagger.annotations.ApiProperty;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.core.domain.measurement.AvailabilityType;

@ApiClass(value="Represents the availability of a resource")
@XmlRootElement(name="availability")
public class AvailabilityRest {
    long since;
    String type;
    Long until;
    int resourceId;

    public AvailabilityRest() {
    }

    public AvailabilityRest(AvailabilityType type, long since, int resourceId) {
        this.since = since;
        this.type = type.toString();
        this.resourceId = resourceId;
    }

    public AvailabilityRest(long since, int resourceId) {
        this.since = since;
        this.type = "- unknown -";
        this.resourceId = resourceId;
    }

    @ApiProperty(value="Time since the type is valid")
    @XmlElement
    public long getSince() {
        return this.since;
    }

    @ApiProperty(value="Type of availability", allowableValues="UP, DOWN, DISABLED, UNKNOWN")
    @XmlElement
    public String getType() {
        return this.type;
    }

    @ApiProperty(value="Id of the resource that reports the availability")
    @XmlElement
    public int getResourceId() {
        return this.resourceId;
    }

    public void setSince(long since) {
        this.since = since;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    @ApiProperty(value="Time until the type is valid. May be null if type is ongoing")
    public Long getUntil() {
        return this.until;
    }

    public void setUntil(Long until) {
        this.until = until;
    }
}

