/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentProviderSyncJob
implements StatefulJob {
    private static final String DATAMAP_CONTENT_SOURCE_NAME = "contentSourceName";
    private static final String DATAMAP_CONTENT_SOURCE_TYPE_NAME = "contentSourceTypeName";
    public static final String DATAMAP_SYNC_IMPORTED_REPOS = "syncImportedRepos";
    private static final Log log = LogFactory.getLog(ContentProviderSyncJob.class);
    private static final String SEPARATOR = "--";

    public int getPercentComplete() {
        int retval = (int)(Math.random() * 100.0);
        return retval;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobDetail jobDetail = context.getJobDetail();
            if (jobDetail == null) {
                throw new IllegalStateException("The job does not have any details");
            }
            JobDataMap dataMap = jobDetail.getJobDataMap();
            if (dataMap == null) {
                throw new IllegalStateException("The job does not have any data in its details");
            }
            String name = dataMap.getString(DATAMAP_CONTENT_SOURCE_NAME);
            String typeName = dataMap.getString(DATAMAP_CONTENT_SOURCE_TYPE_NAME);
            boolean syncImportedRepos = dataMap.getBoolean(DATAMAP_SYNC_IMPORTED_REPOS);
            if (name == null) {
                throw new IllegalStateException("Missing the content source name in details data");
            }
            if (typeName == null) {
                throw new IllegalStateException("Missing the content source type name in details data");
            }
            ContentSource contentSource = this.synchronizeAndLoad(name, typeName);
            if (syncImportedRepos) {
                this.syncImportedRepos(contentSource);
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to sync content source in job [" + context.getJobDetail() + "]";
            log.error((Object)errorMsg, (Throwable)e);
            JobExecutionException jobExecutionException = new JobExecutionException(errorMsg, (Throwable)e, false);
            if (!(e instanceof IllegalStateException)) {
                jobExecutionException.setUnscheduleAllTriggers(false);
            }
            throw jobExecutionException;
        }
    }

    private void syncImportedRepos(ContentSource contentSource) throws InterruptedException {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        final Subject overlord = subjectManager.getOverlord();
        final RepoCriteria repoCriteria = new RepoCriteria();
        repoCriteria.addFilterContentSourceIds(new Integer[]{contentSource.getId()});
        repoCriteria.addFilterCandidate(Boolean.valueOf(false));
        final RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        CriteriaQueryExecutor<Repo, RepoCriteria> queryExecutor = new CriteriaQueryExecutor<Repo, RepoCriteria>(){

            @Override
            public PageList<Repo> execute(RepoCriteria criteria) {
                return repoManager.findReposByCriteria(overlord, repoCriteria);
            }
        };
        CriteriaQuery<Repo, RepoCriteria> repos = new CriteriaQuery<Repo, RepoCriteria>(repoCriteria, queryExecutor);
        ArrayList<Integer> repoIdList = new ArrayList<Integer>();
        for (Repo repo : repos) {
            repoIdList.add(repo.getId());
        }
        Integer[] repoIds = new Integer[repoIdList.size()];
        repoIds = repoIdList.toArray(repoIds);
        repoManager.internalSynchronizeRepos(overlord, repoIds);
    }

    private ContentSource synchronizeAndLoad(String contentSourceName, String contentSourceTypeName) throws Exception {
        Subject overlord;
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ContentSourceManagerLocal contentManager = LookupUtil.getContentSourceManager();
        ContentSource contentSource = contentManager.getContentSourceByNameAndType(overlord = subjectManager.getOverlord(), contentSourceName, contentSourceTypeName);
        if (contentSource == null) {
            throw new Exception("Sync job was asked to sync an unknown content source: " + contentSourceName + "|" + contentSourceTypeName);
        }
        int contentSourceId = contentSource.getId();
        boolean completed = contentManager.internalSynchronizeContentSource(contentSourceId);
        if (!completed) {
            log.info((Object)("Content source [" + contentSourceName + "] is currently being synchronized already. " + "Please wait for the current sync job to finish."));
        }
        return contentSource;
    }

    public static JobDataMap createJobDataMap(ContentSource contentSource, JobDetail details) {
        JobDataMap dataMap = details != null ? details.getJobDataMap() : new JobDataMap();
        dataMap.put(DATAMAP_CONTENT_SOURCE_NAME, contentSource.getName());
        dataMap.put(DATAMAP_CONTENT_SOURCE_TYPE_NAME, contentSource.getContentSourceType().getName());
        return dataMap;
    }

    public static String createJobName(ContentSource cs) {
        String nameEncoded = Integer.toHexString(cs.getName().hashCode());
        String typeNameEncoded = Integer.toHexString(cs.getContentSourceType().getName().hashCode());
        String jobName = nameEncoded + SEPARATOR + typeNameEncoded;
        if (jobName.length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }

    public static String createUniqueJobName(ContentSource cs) {
        String nameEncoded = Integer.toHexString(cs.getName().hashCode());
        String typeNameEncoded = Integer.toHexString(cs.getContentSourceType().getName().hashCode());
        String appendStr = Long.toHexString(System.currentTimeMillis());
        String jobName = nameEncoded + SEPARATOR + typeNameEncoded + SEPARATOR + appendStr;
        if (jobName.length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }
}

