/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class StorageNodeMaintenanceJob
extends AbstractStatefulJob {
    private final Log log = LogFactory.getLog(StorageNodeMaintenanceJob.class);
    private static final int MAX_ITERATIONS = 5;
    private static final int TIMEOUT = 10000;
    private static final String STORAGE_SERVICE = "Storage Service";
    private static final String LOAD_MAP_PROPERTY = "LoadMap";
    private static final String ENDPOINT_PROPERTY = "endpoint";
    private static final String MAINTENANCE_OPERATION = "addNodeMaintenance";
    private static final String MAINTENANCE_OPERATION_NOTE = "Topology change maintenance.";
    private static final String RUN_REPAIR_PROPERTY = "runRepair";
    private static final String UPDATE_SEEDS_LIST = "updateSeedsList";
    private static final String SEEDS_LIST = "seedsList";
    private static final String SUCCEED_PROPERTY = "succeed";
    private static final String USERNAME_PROP = "rhq.cassandra.username";
    private static final String PASSWORD_PROP = "rhq.cassandra.password";

    @Override
    public void executeJobCode(JobExecutionContext arg0) throws JobExecutionException {
        this.waitForResouceLinks();
        List<StorageNode> storageNodes = this.getOnlyResourceLinkedStorageNodes();
        storageNodes = this.waitForClustering(storageNodes);
        boolean topologyUpdated = this.updateTopology(storageNodes);
        if (topologyUpdated) {
            ArrayList<String> seedList = new ArrayList<String>();
            for (StorageNode storageNode : storageNodes) {
                seedList.add(storageNode.getAddress());
            }
            for (StorageNode storageNode : storageNodes) {
                Resource resource = storageNode.getResource();
                this.runNodeMaintenance(resource, seedList);
            }
        }
    }

    private boolean updateTopology(List<StorageNode> storageNodes) throws JobExecutionException {
        String username = this.getRequiredStorageProperty(USERNAME_PROP);
        String password = this.getRequiredStorageProperty(PASSWORD_PROP);
        SchemaManager schemaManager = new SchemaManager(username, password, storageNodes);
        try {
            return schemaManager.updateTopology();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    private List<StorageNode> waitForClustering(List<StorageNode> storageNodes) {
        ArrayList<String> existingEndpoints = new ArrayList<String>();
        for (StorageNode storageNode : storageNodes) {
            existingEndpoints.add(storageNode.getAddress());
        }
        Collections.sort(existingEndpoints);
        boolean allStorageNodesPartOfCluster = false;
        for (int iteration = 0; iteration < 5; ++iteration) {
            for (StorageNode storageNode : storageNodes) {
                Resource resource = storageNode.getResource();
                ArrayList<String> endpoints = new ArrayList<String>();
                try {
                    ResourceCriteria c = new ResourceCriteria();
                    c.addFilterParentResourceId(Integer.valueOf(resource.getId()));
                    PageList<Resource> childResources = LookupUtil.getResourceManager().findResourcesByCriteria(LookupUtil.getSubjectManager().getOverlord(), c);
                    for (Resource childResource : childResources) {
                        if (!STORAGE_SERVICE.equals(childResource.getName())) continue;
                        try {
                            PropertyList propertyList = LookupUtil.getConfigurationManager().getLiveResourceConfiguration(LookupUtil.getSubjectManager().getOverlord(), childResource.getId(), true).getList(LOAD_MAP_PROPERTY);
                            List actualList = propertyList.getList();
                            for (Property property : actualList) {
                                PropertyMap map = (PropertyMap)property;
                                endpoints.add(map.get(ENDPOINT_PROPERTY).toString());
                            }
                            break;
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error fetching live configuration for resource " + resource.getId()));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
                Collections.sort(endpoints);
                if (!existingEndpoints.equals(endpoints)) continue;
                allStorageNodesPartOfCluster = true;
                break;
            }
            if (allStorageNodesPartOfCluster) break;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)e);
            }
        }
        return storageNodes;
    }

    private void runNodeMaintenance(Resource resource, List<String> seedList) {
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        try {
            ResourceOperationSchedule newSchedule = new ResourceOperationSchedule();
            newSchedule.setJobTrigger(JobTrigger.createNowTrigger());
            newSchedule.setResource(resource);
            newSchedule.setOperationName(MAINTENANCE_OPERATION);
            newSchedule.setDescription(MAINTENANCE_OPERATION_NOTE);
            ArrayList<Object> properties = new ArrayList<Object>();
            properties.add(new PropertySimple(RUN_REPAIR_PROPERTY, (Object)Boolean.TRUE));
            properties.add(new PropertySimple(UPDATE_SEEDS_LIST, (Object)Boolean.TRUE));
            PropertyList seedListProperty = new PropertyList(SEEDS_LIST);
            for (String seed : seedList) {
                seedListProperty.add((Property)new PropertySimple("seed", (Object)seed));
            }
            properties.add(seedListProperty);
            Configuration config = new Configuration();
            config.setProperties(properties);
            newSchedule.setParameters(config);
            long operationStartTime = System.currentTimeMillis();
            operationManager.scheduleResourceOperation(LookupUtil.getSubjectManager().getOverlord(), newSchedule);
            boolean resultFound = false;
            for (int iteration = 0; iteration < 5 && !resultFound; ++iteration) {
                PageList<ResourceOperationHistory> results = operationManager.findCompletedResourceOperationHistories(LookupUtil.getSubjectManager().getOverlord(), resource.getId(), operationStartTime, null, PageControl.getUnlimitedInstance());
                for (ResourceOperationHistory operationHistory : results) {
                    Configuration operationResults;
                    if (!MAINTENANCE_OPERATION.equals(operationHistory.getOperationDefinition().getName()) || !OperationRequestStatus.SUCCESS.equals((Object)operationHistory.getStatus()) || !"true".equals((operationResults = operationHistory.getResults()).getSimpleValue(SUCCEED_PROPERTY))) continue;
                    resultFound = true;
                }
                if (!resultFound) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    private List<StorageNode> getOnlyResourceLinkedStorageNodes() {
        StorageNodeManagerLocal storageNodeManager = LookupUtil.getStorageNodeManager();
        ArrayList<StorageNode> resourceLinkedstorageNodes = new ArrayList<StorageNode>();
        for (StorageNode storageNode : storageNodeManager.getStorageNodes()) {
            if (storageNode.getResource() == null) continue;
            resourceLinkedstorageNodes.add(storageNode);
        }
        return resourceLinkedstorageNodes;
    }

    private void waitForResouceLinks() {
        StorageNodeManagerLocal storageNodeManager = LookupUtil.getStorageNodeManager();
        boolean allResourcesLinked = true;
        for (int iteration = 0; iteration < 5; ++iteration) {
            allResourcesLinked = true;
            List<StorageNode> t = storageNodeManager.getStorageNodes();
            for (StorageNode storageNode : t) {
                if (storageNode.getResource() != null) continue;
                allResourcesLinked = false;
            }
            if (allResourcesLinked) break;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)e);
            }
        }
    }

    private String getRequiredStorageProperty(String property) throws JobExecutionException {
        String value = System.getProperty(property);
        if (StringUtil.isEmpty((String)property)) {
            throw new JobExecutionException("The system property [" + property + "] is not set. The RHQ " + "server will not be able connect to the RHQ storage node(s). This property should be defined " + "in rhq-server.properties.");
        }
        return value;
    }
}

