/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.validators;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.sync.ValidationException;
import org.rhq.enterprise.server.sync.validators.EntityValidator;

public class UniquenessValidator<T>
implements EntityValidator<T> {
    private Set<T> alreadyCheckedEntities;

    @Override
    public void initialize(Subject subject, EntityManager entityManager) {
        this.alreadyCheckedEntities = new HashSet<T>();
    }

    @Override
    public void validateExportedEntity(T entity) throws ValidationException {
        if (!this.alreadyCheckedEntities.add(entity)) {
            throw new ValidationException("Was the export file manually updated? The entity " + entity + " has been seen multiple times.");
        }
    }
}

