/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InventoryReportSerializer {
    private final Log log = LogFactory.getLog(InventoryReportSerializer.class);
    private static Map<String, ReentrantReadWriteLock> locks = new HashMap<String, ReentrantReadWriteLock>();
    private static Map<String, Long> lockTimes = Collections.synchronizedMap(new HashMap());
    private static InventoryReportSerializer singleton = new InventoryReportSerializer();

    public static InventoryReportSerializer getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String agentName) {
        String msg = "tid=" + Thread.currentThread().getId() + "; agent=" + agentName;
        boolean debug = this.log.isDebugEnabled();
        ReentrantReadWriteLock lock = null;
        this.logDebug(debug, msg, ": about to synchronize");
        InventoryReportSerializer inventoryReportSerializer = this;
        synchronized (inventoryReportSerializer) {
            this.logDebug(debug, msg, ": synchronized");
            lock = locks.get(agentName);
            if (lock == null) {
                this.logDebug(debug, msg, ": creating new lock");
                lock = new ReentrantReadWriteLock();
                locks.put(agentName, lock);
            }
        }
        this.logDebug(debug, msg, ": acquiring write lock");
        long start = System.currentTimeMillis();
        lock.writeLock().lock();
        long end = System.currentTimeMillis();
        long duration = end - start;
        lockTimes.put(agentName, end);
        if (duration < 5000L) {
            this.logDebug(debug, msg, ": acquired write lock in millis=" + duration);
        } else {
            this.log.info((Object)(msg + ": acquired write lock in millis=" + duration));
        }
    }

    public void unlock(String agentName) {
        String msg = "tid=" + Thread.currentThread().getId() + "; agent=" + agentName;
        boolean debug = this.log.isDebugEnabled();
        ReentrantReadWriteLock lock = locks.get(agentName);
        if (lock != null) {
            Long lockedTime = lockTimes.get(agentName);
            long duration = System.currentTimeMillis() - (lockedTime != null ? lockedTime : Long.MAX_VALUE);
            if (duration < 5000L) {
                this.logDebug(debug, msg, ": releasing write lock after being locked for millis=" + duration);
            } else {
                this.log.info((Object)(msg + ": releasing write lock after being locked for millis=" + duration));
            }
            lock.writeLock().unlock();
            this.logDebug(debug, msg, ": released write lock");
        } else {
            this.log.warn((Object)(msg + ": cannot release write lock"));
        }
    }

    private void logDebug(boolean enabled, String arg1, String arg2) {
        if (enabled) {
            this.log.debug((Object)(arg1 + arg2));
        }
    }
}

