/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.ConcurrencyManager;
import org.rhq.enterprise.communications.util.NotPermittedException;

public class GlobalConcurrencyLimitCommandListener
implements CommandListener {
    public static final String CONCURRENCY_LIMIT_NAME = "rhq.communications.global-concurrency-limit-semaphore";
    private static final Logger LOG = CommI18NFactory.getLogger(GlobalConcurrencyLimitCommandListener.class);
    private final ServiceContainer serviceContainer;
    private final ConcurrentLinkedQueue<ConcurrencyManager.Permit> permitsObtained;
    private final Semaphore droppedCommands;

    public GlobalConcurrencyLimitCommandListener(ServiceContainer serviceContainer) {
        this.serviceContainer = serviceContainer;
        this.permitsObtained = new ConcurrentLinkedQueue();
        this.droppedCommands = new Semaphore(0);
    }

    @Override
    public void receivedCommand(Command command) {
        try {
            ConcurrencyManager.Permit permit = this.serviceContainer.getConcurrencyManager().getPermit(CONCURRENCY_LIMIT_NAME);
            this.permitsObtained.add(permit);
        }
        catch (NotPermittedException npe) {
            LOG.debug("CommandService.remote-pojo-execute-not-permitted", new Object[]{command, npe.getSleepBeforeRetry()});
            this.droppedCommands.release();
            throw npe;
        }
    }

    @Override
    public void processedCommand(Command command, CommandResponse response) {
        if (!this.droppedCommands.tryAcquire()) {
            this.serviceContainer.getConcurrencyManager().releasePermit(this.permitsObtained.poll());
        }
    }
}

