/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import mazz.i18n.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkNotification;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryListener;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

class ServiceContainerNetworkNotificationListener
implements NotificationListener {
    private static final Logger LOG = CommI18NFactory.getLogger(ServiceContainerNetworkNotificationListener.class);
    private List<AutoDiscoveryListener> m_discoveryListeners = new ArrayList<AutoDiscoveryListener>();
    private Map<Identity, List<InvokerLocator>> m_discoveredServers = new HashMap<Identity, List<InvokerLocator>>();
    private Object m_lock = new Object();

    ServiceContainerNetworkNotificationListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AutoDiscoveryListener listener) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_discoveryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AutoDiscoveryListener listener) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_discoveryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_discoveryListeners.clear();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof NetworkNotification) {
            LOG.debug("ServiceContainerNetworkNotificationListener.got-notif", new Object[]{notification.getType()});
            NetworkNotification networkNotification = (NetworkNotification)notification;
            if ("jboss.network.server.added".equals(networkNotification.getType())) {
                this.serverAddedNotification(networkNotification);
            } else if ("jboss.network.server.removed".equals(networkNotification.getType())) {
                this.serverRemovedNotification(networkNotification);
            } else if ("jboss.network.server.updated".equals(networkNotification.getType())) {
                this.serverUpdatedNotification(networkNotification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAddedNotification(NetworkNotification networkNotification) {
        ArrayList<AutoDiscoveryListener> listeners_copy;
        InvokerLocator[] notif_locators = networkNotification.getLocator();
        Object object = this.m_lock;
        synchronized (object) {
            List<InvokerLocator> server_invokers = this.m_discoveredServers.get(networkNotification.getIdentity());
            if (server_invokers == null) {
                server_invokers = new ArrayList<InvokerLocator>(networkNotification.getLocator().length);
                this.m_discoveredServers.put(networkNotification.getIdentity(), server_invokers);
            }
            for (int x = 0; x < notif_locators.length; ++x) {
                server_invokers.add(notif_locators[x]);
            }
            listeners_copy = new ArrayList<AutoDiscoveryListener>(this.m_discoveryListeners);
        }
        for (int x = 0; x < notif_locators.length; ++x) {
            this.notifyListenersOnline(listeners_copy, notif_locators[x]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverRemovedNotification(NetworkNotification networkNotification) {
        ArrayList<AutoDiscoveryListener> listeners_copy;
        InvokerLocator[] notif_locators = networkNotification.getLocator();
        Object object = this.m_lock;
        synchronized (object) {
            this.m_discoveredServers.remove(networkNotification.getIdentity());
            listeners_copy = new ArrayList<AutoDiscoveryListener>(this.m_discoveryListeners);
        }
        for (int x = 0; x < notif_locators.length; ++x) {
            this.notifyListenersOffline(listeners_copy, notif_locators[x]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverUpdatedNotification(NetworkNotification networkNotification) {
        ArrayList<AutoDiscoveryListener> listeners_copy;
        ArrayList<InvokerLocator> new_invokers = new ArrayList<InvokerLocator>();
        ArrayList<InvokerLocator> dead_invokers = new ArrayList<InvokerLocator>();
        InvokerLocator[] notif_locators = networkNotification.getLocator();
        Object object = this.m_lock;
        synchronized (object) {
            List<InvokerLocator> server_invokers = this.m_discoveredServers.get(networkNotification.getIdentity());
            for (int i = 0; i < notif_locators.length; ++i) {
                InvokerLocator cur_notif_locator = notif_locators[i];
                if (server_invokers.contains(cur_notif_locator)) continue;
                new_invokers.add(cur_notif_locator);
                server_invokers.add(cur_notif_locator);
            }
            List<InvokerLocator> notif_locators_list = Arrays.asList(notif_locators);
            for (InvokerLocator cur_server_invoker : server_invokers) {
                if (notif_locators_list.contains(cur_server_invoker)) continue;
                dead_invokers.add(cur_server_invoker);
            }
            for (InvokerLocator dead_invoker : dead_invokers) {
                server_invokers.remove(dead_invoker);
            }
            listeners_copy = new ArrayList<AutoDiscoveryListener>(this.m_discoveryListeners);
        }
        for (InvokerLocator new_invoker : new_invokers) {
            this.notifyListenersOnline(listeners_copy, new_invoker);
        }
        for (InvokerLocator dead_invoker : dead_invokers) {
            this.notifyListenersOffline(listeners_copy, dead_invoker);
        }
    }

    private void notifyListenersOnline(List listeners_copy, InvokerLocator new_server_invoker_locator) {
        LOG.debug("ServiceContainerNetworkNotificationListener.server-online", new Object[]{new_server_invoker_locator});
        for (AutoDiscoveryListener listener : listeners_copy) {
            try {
                listener.serverOnline(new_server_invoker_locator);
            }
            catch (Throwable t) {
                LOG.error(t, "ServiceContainerNetworkNotificationListener.online-processing-failure", new Object[]{new_server_invoker_locator});
            }
        }
    }

    private void notifyListenersOffline(List listeners_copy, InvokerLocator dead_server_invoker_locator) {
        LOG.debug("ServiceContainerNetworkNotificationListener.server-offline", new Object[]{dead_server_invoker_locator});
        for (AutoDiscoveryListener listener : listeners_copy) {
            try {
                listener.serverOffline(dead_server_invoker_locator);
            }
            catch (Throwable t) {
                LOG.error(t, "ServiceContainerNetworkNotificationListener.offline-processing-failure", new Object[]{dead_server_invoker_locator});
            }
        }
    }
}

