/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mazz.i18n.Logger;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderMetrics;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderStateListener;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderTask;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;
import org.rhq.enterprise.communications.command.client.CommandAndCallback;
import org.rhq.enterprise.communications.command.client.CommandPreprocessor;
import org.rhq.enterprise.communications.command.client.CommandQueue;
import org.rhq.enterprise.communications.command.client.CommandResponseCallback;
import org.rhq.enterprise.communications.command.client.PersistentFifo;
import org.rhq.enterprise.communications.command.client.PollingListener;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.client.SendCallback;
import org.rhq.enterprise.communications.command.client.SendThrottle;
import org.rhq.enterprise.communications.command.client.ServerPollingThread;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandClient;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ClientCommandSender {
    public static final String CMDCONFIG_PROP_TIMEOUT = "rhq.timeout";
    public static final String CMDCONFIG_PROP_GUARANTEED_DELIVERY = "rhq.guaranteed-delivery";
    public static final String CMDCONFIG_PROP_SEND_THROTTLE = "rhq.send-throttle";
    private static final Logger LOG = CommI18NFactory.getLogger(ClientCommandSender.class);
    private RemoteCommunicator m_remoteCommunicator;
    private final CommandQueue m_queue;
    private final SendThrottle m_sendThrottle;
    private ThreadPoolExecutor m_executor;
    private long m_executorIndex = 0L;
    private ThreadPoolExecutor m_timerThreadPool;
    private long m_timerThreadIndex = 0L;
    private boolean m_isSending;
    private final Object m_changingModeLock = new Object();
    private final ReentrantReadWriteLock m_shuttingDownTasksLock = new ReentrantReadWriteLock();
    private boolean m_shuttingDownTasks;
    private ServerPollingThread m_serverPollingThread;
    private PersistentFifo m_commandStore;
    private ClientCommandSenderConfiguration m_configuration;
    private CommandPreprocessor[] m_preprocessors;
    private SendCallback[] m_sendCallbacks;
    private final List<ClientCommandSenderStateListener> m_stateListeners = new ArrayList<ClientCommandSenderStateListener>();
    private ClientCommandSenderMetrics m_metrics;

    public ClientCommandSender(RemoteCommunicator remote_communicator, ClientCommandSenderConfiguration config) throws IllegalArgumentException {
        String[] preprocs;
        if (remote_communicator == null) {
            throw new IllegalArgumentException(LOG.getMsgString("ClientCommandSender.null-remote-comm", new Object[0]));
        }
        if (config == null) {
            throw new IllegalArgumentException(LOG.getMsgString("ClientCommandSender.null-config", new Object[0]));
        }
        this.m_configuration = config.copy();
        this.m_isSending = false;
        this.m_shuttingDownTasks = false;
        this.m_remoteCommunicator = remote_communicator;
        this.m_executor = null;
        this.m_timerThreadPool = null;
        this.m_queue = new CommandQueue(config);
        this.m_sendThrottle = new SendThrottle(config);
        this.m_preprocessors = null;
        this.m_sendCallbacks = null;
        if (config.commandSpoolFileName != null) {
            File cmd_spool_file = new File(config.dataDirectory, config.commandSpoolFileName);
            try {
                this.m_commandStore = new PersistentFifo(cmd_spool_file, config.commandSpoolFileMaxSize, config.commandSpoolFilePurgePercentage, config.commandSpoolFileCompressData);
            }
            catch (Exception e) {
                this.m_commandStore = null;
                LOG.warn("ClientCommandSender.command-spool-access-error", new Object[]{cmd_spool_file, remote_communicator, e});
            }
        } else {
            this.m_commandStore = null;
            LOG.debug("ClientCommandSender.no-spool-file-defined", new Object[]{remote_communicator});
        }
        if (config.commandPreprocessors != null && config.commandPreprocessors.trim().length() > 0 && (preprocs = config.commandPreprocessors.split("\\s*:\\s*")) != null && preprocs.length > 0) {
            ArrayList<CommandPreprocessor> list = new ArrayList<CommandPreprocessor>();
            for (int i = 0; i < preprocs.length; ++i) {
                try {
                    Class<?> clazz = Class.forName(preprocs[i]);
                    list.add((CommandPreprocessor)clazz.newInstance());
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "ClientCommandSender.invalid-preprocessor", new Object[]{preprocs[i], remote_communicator});
                }
            }
            this.setCommandPreprocessors(list.toArray(new CommandPreprocessor[list.size()]));
        }
        this.m_metrics = new ClientCommandSenderMetrics(this.m_queue, this.m_commandStore, this.m_executor);
        if (config.enableSendThrottling) {
            this.m_metrics.sendThrottleMaxCommands.set(config.sendThrottleMaxCommands);
            this.m_metrics.sendThrottleQuietPeriodDurationMillis.set(config.sendThrottleQuietPeriodDurationMillis);
        }
        if (config.enableQueueThrottling) {
            this.m_metrics.queueThrottleMaxCommands.set(config.queueThrottleMaxCommands);
            this.m_metrics.queueThrottleBurstPeriodMillis.set(config.queueThrottleBurstPeriodMillis);
        }
    }

    public ClientCommandSender(RemoteCommunicator remote_communicator, ClientCommandSenderConfiguration config, LinkedList<Runnable> previously_queued_tasks) throws IllegalArgumentException {
        this(remote_communicator, config);
        if (previously_queued_tasks != null && previously_queued_tasks.size() > 0) {
            long requeued = 0L;
            while (previously_queued_tasks.size() > 0) {
                try {
                    ClientCommandSenderTask task = this.getTaskFromRunnable(previously_queued_tasks.removeFirst());
                    task.setClientCommandSender(this);
                    this.m_queue.put(task);
                    ++requeued;
                }
                catch (InterruptedException e) {
                    LOG.warn("ClientCommandSender.requeue-failed", new Object[]{remote_communicator});
                }
            }
            LOG.debug("ClientCommandSender.requeue", new Object[]{requeued, remote_communicator});
        }
    }

    public ClientCommandSenderConfiguration getConfiguration() {
        return this.m_configuration.copy();
    }

    public RemoteCommunicator getRemoteCommunicator() {
        return this.m_remoteCommunicator;
    }

    public ClientCommandSenderMetrics getMetrics() {
        return this.m_metrics;
    }

    public void setRemoteCommunicator(RemoteCommunicator remote_communicator) throws IllegalArgumentException {
        if (remote_communicator == null) {
            throw new IllegalArgumentException(LOG.getMsgString("ClientCommandSender.null-remote-comm", new Object[0]));
        }
        this.m_remoteCommunicator = remote_communicator;
    }

    public CommandPreprocessor[] getCommandPreprocessors() {
        return this.m_preprocessors != null ? this.m_preprocessors : new CommandPreprocessor[]{};
    }

    public void setCommandPreprocessors(CommandPreprocessor[] preprocs) {
        this.m_preprocessors = preprocs != null && preprocs.length > 0 ? preprocs : null;
    }

    public SendCallback[] getSendCallbacks() {
        return null != this.m_sendCallbacks ? this.m_sendCallbacks : new SendCallback[]{};
    }

    public void setSendCallbacks(SendCallback[] sendCallbacks) {
        this.m_sendCallbacks = null != sendCallbacks && sendCallbacks.length > 0 ? sendCallbacks : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(ClientCommandSenderStateListener listener, boolean immediately_notify) {
        boolean is_sending;
        List<ClientCommandSenderStateListener> list = this.m_stateListeners;
        synchronized (list) {
            is_sending = this.isSending();
            if (!this.m_stateListeners.contains(listener)) {
                this.m_stateListeners.add(listener);
                LOG.debug("ClientCommandSender.added-state-listener", new Object[]{listener, is_sending, immediately_notify});
            }
        }
        if (immediately_notify) {
            this.notifyStateListener(is_sending, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ClientCommandSenderStateListener listener) {
        List<ClientCommandSenderStateListener> list = this.m_stateListeners;
        synchronized (list) {
            if (this.m_stateListeners.remove(listener)) {
                LOG.debug("ClientCommandSender.removed-state-listener", new Object[]{listener});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStateListeners(boolean started_sending) {
        ArrayList<ClientCommandSenderStateListener> listeners_copy;
        LOG.debug("ClientCommandSender.notifying-state-listeners", new Object[]{started_sending});
        List<ClientCommandSenderStateListener> list = this.m_stateListeners;
        synchronized (list) {
            listeners_copy = new ArrayList<ClientCommandSenderStateListener>(this.m_stateListeners);
        }
        for (ClientCommandSenderStateListener listener : listeners_copy) {
            this.notifyStateListener(started_sending, listener);
        }
    }

    private void notifyStateListener(boolean started_sending, ClientCommandSenderStateListener listener) {
        boolean keep_listening;
        try {
            keep_listening = started_sending ? listener.startedSending(this) : listener.stoppedSending(this);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "ClientCommandSender.state-listener-exception", new Object[]{listener, e});
            keep_listening = false;
        }
        if (!keep_listening) {
            this.removeStateListener(listener);
        }
    }

    public void sendAsynchGuaranteed(Command command, CommandResponseCallback callback) throws Exception {
        command.getConfiguration().setProperty(CMDCONFIG_PROP_GUARANTEED_DELIVERY, "true");
        this.sendAsynch(command, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynch(Command command, CommandResponseCallback callback) throws Exception {
        try {
            this.preprocessCommand(command);
            CommandAndCallback cnc = new CommandAndCallback(command, callback);
            long timeout = this.getCommandTimeout(command);
            ClientCommandSenderTask task = new ClientCommandSenderTask(this, cnc, timeout, true, null);
            Object object = this.m_changingModeLock;
            synchronized (object) {
                if (this.isSending()) {
                    this.m_executor.submit(task);
                } else if (this.isDeliveryGuaranteed(command)) {
                    this.spoolCommandAndCallback(cnc);
                } else {
                    boolean is_queued = this.m_queue.offer(task, 1000L, TimeUnit.MILLISECONDS);
                    if (!is_queued) {
                        throw new Exception(LOG.getMsgString("ClientCommandSender.full-queue", new Object[]{command}));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception(LOG.getMsgString("ClientCommandSender.queue-failed", new Object[]{command}), e);
        }
    }

    public CommandResponse sendSynch(Command command) throws Exception {
        if (!this.isSending()) {
            throw new IllegalStateException(LOG.getMsgString("ClientCommandSender.cannot-send-not-sending", new Object[]{command}));
        }
        this.preprocessCommand(command);
        CommandAndCallback cnc = new CommandAndCallback(command, null);
        long timeout = this.getCommandTimeout(command);
        CommandResponse[] response = new CommandResponse[1];
        ClientCommandSenderTask task = new ClientCommandSenderTask(this, cnc, timeout, false, response);
        task.run();
        return response[0];
    }

    public ClientRemotePojoFactory getClientRemotePojoFactory() {
        ClientRemotePojoFactory factory = new ClientRemotePojoFactory(this);
        return factory;
    }

    public void enableQueueThrottling(long max_commands, long period_millis) {
        ClientCommandSenderConfiguration config = new ClientCommandSenderConfiguration();
        config.queueThrottleMaxCommands = max_commands;
        config.queueThrottleBurstPeriodMillis = period_millis;
        this.m_queue.setQueueThrottleParameters(config);
        this.m_queue.enableQueueThrottling();
        this.m_metrics.queueThrottleMaxCommands.set(max_commands);
        this.m_metrics.queueThrottleBurstPeriodMillis.set(period_millis);
    }

    public void disableQueueThrottling() {
        this.m_queue.disableQueueThrottling();
        this.m_metrics.queueThrottleMaxCommands.set(0L);
        this.m_metrics.queueThrottleBurstPeriodMillis.set(0L);
    }

    public void enableSendThrottling(long max_commands, long quiet_period_duration) {
        ClientCommandSenderConfiguration config = new ClientCommandSenderConfiguration();
        config.sendThrottleMaxCommands = max_commands;
        config.sendThrottleQuietPeriodDurationMillis = quiet_period_duration;
        this.m_sendThrottle.setSendThrottleParameters(config);
        this.m_sendThrottle.enableSendThrottling();
        this.m_metrics.sendThrottleMaxCommands.set(max_commands);
        this.m_metrics.sendThrottleQuietPeriodDurationMillis.set(quiet_period_duration);
    }

    public void disableSendThrottling() {
        this.m_sendThrottle.disableSendThrottling();
        this.m_metrics.sendThrottleMaxCommands.set(0L);
        this.m_metrics.sendThrottleQuietPeriodDurationMillis.set(0L);
    }

    public void startServerPolling() {
        if (this.m_configuration.serverPollingIntervalMillis <= 0L) {
            return;
        }
        this.m_serverPollingThread = new ServerPollingThread(this, this.m_configuration.serverPollingIntervalMillis);
        this.m_serverPollingThread.start();
    }

    public void stopServerPolling() {
        if (this.m_serverPollingThread != null) {
            this.m_serverPollingThread.stopPolling();
            this.m_serverPollingThread = null;
        }
    }

    public boolean isServerPolling() {
        return null != this.m_serverPollingThread;
    }

    public void addPollingListener(PollingListener listener) {
        ServerPollingThread thread = this.m_serverPollingThread;
        if (thread != null) {
            thread.addPollingListener(listener);
        }
    }

    public void removePollingListener(PollingListener listener) {
        ServerPollingThread thread = this.m_serverPollingThread;
        if (thread != null) {
            thread.removePollingListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSending() {
        boolean changed_mode = false;
        Object object = this.m_changingModeLock;
        synchronized (object) {
            if (!this.m_isSending) {
                LinkedList queued_commands;
                try {
                    queued_commands = new LinkedList();
                    this.m_queue.drainTo(queued_commands);
                }
                catch (Exception e) {
                    queued_commands = new LinkedList();
                    LOG.warn("ClientCommandSender.drain-interrupted", new Object[]{this.m_remoteCommunicator});
                }
                this.m_executor = new ThreadPoolExecutor(this.m_configuration.maxConcurrent, this.m_configuration.maxConcurrent, 60000L, TimeUnit.MILLISECONDS, this.m_queue);
                this.m_executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                this.m_executor.setThreadFactory(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "ClientCommandSenderTask Thread #" + ClientCommandSender.this.m_executorIndex++);
                    }
                });
                this.m_metrics.setThreadPool(this.m_executor);
                this.m_timerThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
                this.m_timerThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                this.m_timerThreadPool.setThreadFactory(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "ClientCommandSenderTask Timer Thread #" + ClientCommandSender.this.m_timerThreadIndex++);
                    }
                });
                this.queueAllPersistedCommands();
                try {
                    int num_commands_to_queue = queued_commands.size();
                    for (int i = 0; i < num_commands_to_queue; ++i) {
                        Runnable task = (Runnable)queued_commands.removeFirst();
                        this.m_executor.execute(task);
                    }
                }
                catch (Exception e) {
                    LOG.warn("ClientCommandSender.requeue-interrupted", new Object[]{this.m_remoteCommunicator});
                }
                this.m_isSending = true;
                changed_mode = true;
                LOG.debug("ClientCommandSender.sending", new Object[0]);
            }
            this.m_metrics.sendingMode.set(true);
        }
        if (changed_mode) {
            this.notifyStateListeners(true);
        }
        return changed_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopSending(boolean process_currently_queued_commands) {
        boolean changed_mode = false;
        this.m_shuttingDownTasksLock.writeLock().lock();
        try {
            if (this.m_shuttingDownTasks) {
                boolean bl = false;
                return bl;
            }
            this.m_shuttingDownTasks = true;
        }
        finally {
            this.m_shuttingDownTasksLock.writeLock().unlock();
        }
        Object object = this.m_changingModeLock;
        synchronized (object) {
            try {
                if (this.m_isSending) {
                    this.m_isSending = false;
                    try {
                        this.m_executor.setKeepAliveTime(0L, TimeUnit.MILLISECONDS);
                        this.m_timerThreadPool.setKeepAliveTime(0L, TimeUnit.MILLISECONDS);
                        if (process_currently_queued_commands) {
                            this.m_executor.shutdown();
                            this.m_timerThreadPool.shutdown();
                        } else {
                            this.m_executor.shutdownNow();
                            this.m_timerThreadPool.shutdownNow();
                        }
                        this.m_executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
                        this.m_timerThreadPool.awaitTermination(60000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.m_executor = null;
                    this.m_timerThreadPool = null;
                    this.m_remoteCommunicator.disconnect();
                    this.persistAllQueuedCommands();
                    changed_mode = true;
                    LOG.debug("ClientCommandSender.no-longer-sending", new Object[]{this.m_remoteCommunicator});
                }
                this.m_metrics.sendingMode.set(false);
                this.m_metrics.setThreadPool(null);
            }
            finally {
                this.m_shuttingDownTasksLock.writeLock().lock();
                try {
                    this.m_shuttingDownTasks = false;
                }
                finally {
                    this.m_shuttingDownTasksLock.writeLock().unlock();
                }
            }
        }
        if (changed_mode) {
            this.notifyStateListeners(false);
        }
        return changed_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSending() {
        Object object = this.m_changingModeLock;
        synchronized (object) {
            return this.m_isSending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Runnable> drainQueuedCommands() {
        LinkedList<Runnable> list = null;
        Object object = this.m_changingModeLock;
        synchronized (object) {
            try {
                list = new LinkedList<Runnable>();
                this.m_queue.drainTo((Collection<? super Runnable>)list);
            }
            catch (Exception e) {
                LOG.warn("ClientCommandSender.drain-method-interrupted", new Object[0]);
            }
        }
        return list;
    }

    public void preprocessCommand(Command command) {
        if (this.m_preprocessors != null) {
            for (int i = 0; i < this.m_preprocessors.length; ++i) {
                this.m_preprocessors[i].preprocess(command, this);
            }
        }
    }

    public void executePreSendCallbacks(Command command) {
        if (null != this.m_sendCallbacks) {
            for (int i = 0; i < this.m_sendCallbacks.length; ++i) {
                this.m_sendCallbacks[i].sending(command);
            }
        }
    }

    public CommandResponse executePostSendCallbacks(Command command, CommandResponse response) {
        if (null != this.m_sendCallbacks) {
            for (int i = 0; i < this.m_sendCallbacks.length; ++i) {
                response = this.m_sendCallbacks[i].sent(command, response);
            }
        }
        return response;
    }

    CommandResponse send(Command command) throws Throwable {
        CommandResponse response;
        try {
            GenericCommandClient client = new GenericCommandClient(this.m_remoteCommunicator);
            this.executePreSendCallbacks(command);
            long start = System.currentTimeMillis();
            response = client.invoke(command);
            long elapsed = System.currentTimeMillis() - start;
            response = this.executePostSendCallbacks(command, response);
            if (response != null && response.isSuccessful()) {
                long num = this.m_metrics.successfulCommands.incrementAndGet();
                long currentAvg = this.m_metrics.averageExecutionTime.get();
                currentAvg = ((num - 1L) * currentAvg + elapsed) / num;
                this.m_metrics.averageExecutionTime.set(currentAvg);
            } else {
                this.m_metrics.failedCommands.incrementAndGet();
            }
        }
        catch (Throwable t) {
            this.m_metrics.failedCommands.incrementAndGet();
            throw t;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retryGuaranteedTask(CommandAndCallback cnc) {
        block12: {
            try {
                this.m_shuttingDownTasksLock.readLock().lock();
            }
            catch (Exception ie1) {
                try {
                    this.m_shuttingDownTasksLock.readLock().lock();
                }
                catch (Exception ie2) {
                    LOG.error("ClientCommandSender.retry-read-lock-acquire-failure", new Object[]{cnc.getCommand()});
                    return;
                }
            }
            try {
                if (this.m_shuttingDownTasks) {
                    this.spoolCommandAndCallback(cnc);
                    break block12;
                }
                try {
                    Thread.sleep(this.m_configuration.retryInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.sendAsynch(cnc.getCommand(), cnc.getCallback());
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "ClientCommandSender.retry-failure", new Object[]{this.m_remoteCommunicator, cnc.getCommand()});
            }
            finally {
                this.m_shuttingDownTasksLock.readLock().unlock();
            }
        }
    }

    void waitForSendThrottle(Command command) {
        if (this.isSendThrottled(command)) {
            this.m_sendThrottle.waitUntilOkToSend();
        }
    }

    boolean isDeliveryGuaranteed(Command command) {
        boolean guaranteed = false;
        if (command.getConfiguration() != null) {
            String property = command.getConfiguration().getProperty(CMDCONFIG_PROP_GUARANTEED_DELIVERY);
            guaranteed = Boolean.valueOf(property);
        }
        return guaranteed;
    }

    ThreadPoolExecutor getTimerThreadPool() {
        return this.m_timerThreadPool;
    }

    private boolean isSendThrottled(Command command) {
        boolean value = false;
        if (command.getConfiguration() != null) {
            String property = command.getConfiguration().getProperty(CMDCONFIG_PROP_SEND_THROTTLE);
            value = Boolean.valueOf(property);
        }
        return value;
    }

    private long getCommandTimeout(Command command) {
        String timeoutStr;
        long timeout = this.m_configuration.defaultTimeoutMillis;
        if (command.getConfiguration() != null && (timeoutStr = command.getConfiguration().getProperty(CMDCONFIG_PROP_TIMEOUT)) != null) {
            try {
                timeout = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("ClientCommandSender.invalid-timeout", new Object[]{timeoutStr, timeout, command});
            }
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueAllPersistedCommands() {
        Object object = this.m_changingModeLock;
        synchronized (object) {
            if (this.m_commandStore != null) {
                try {
                    long num_commands_persisted;
                    long total_store_size = num_commands_persisted = this.m_commandStore.count();
                    LOG.debug("ClientCommandSender.loading-command-spool", new Object[]{total_store_size, this.m_remoteCommunicator});
                    while (num_commands_persisted > 0L) {
                        CommandAndCallback cnc = this.unspoolCommandAndCallback();
                        if (cnc != null) {
                            long timeout = this.getCommandTimeout(cnc.getCommand());
                            ClientCommandSenderTask task = new ClientCommandSenderTask(this, cnc, timeout, true, null);
                            this.m_executor.execute(task);
                            --num_commands_persisted;
                            continue;
                        }
                        LOG.warn("ClientCommandSender.unspool-failure", new Object[]{total_store_size - num_commands_persisted, num_commands_persisted, this.m_remoteCommunicator});
                        num_commands_persisted = 0L;
                    }
                    LOG.debug("ClientCommandSender.unspooled", new Object[]{total_store_size, this.m_remoteCommunicator});
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e, "ClientCommandSender.unspool-and-queue-failure", new Object[]{this.m_remoteCommunicator});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistAllQueuedCommands() {
        Object object = this.m_changingModeLock;
        synchronized (object) {
            if (this.m_commandStore != null) {
                LOG.debug("ClientCommandSender.spooling", new Object[0]);
                long commands_persisted = 0L;
                long volatile_commands = 0L;
                try {
                    LinkedList remaining_tasks = new LinkedList();
                    this.m_queue.drainTo(remaining_tasks);
                    while (remaining_tasks.size() > 0) {
                        ClientCommandSenderTask next_task = this.getTaskFromRunnable((Runnable)remaining_tasks.removeFirst());
                        Command task_command = next_task.getCommandAndCallback().getCommand();
                        if (this.isDeliveryGuaranteed(task_command)) {
                            this.spoolCommandAndCallback(next_task.getCommandAndCallback());
                            ++commands_persisted;
                            continue;
                        }
                        this.m_queue.put(next_task);
                        ++volatile_commands;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e, "ClientCommandSender.spool-failure", new Object[]{this.m_remoteCommunicator});
                }
                LOG.debug("ClientCommandSender.spool-done", new Object[]{commands_persisted, volatile_commands, this.m_remoteCommunicator});
            }
        }
    }

    private void spoolCommandAndCallback(CommandAndCallback cnc) {
        if (this.m_commandStore != null) {
            byte[] serialized_bytes;
            try {
                serialized_bytes = StreamUtil.serialize((Serializable)cnc);
            }
            catch (RuntimeException e) {
                LOG.warn("ClientCommandSender.callback-not-serializable", new Object[]{e});
                serialized_bytes = StreamUtil.serialize((Serializable)new CommandAndCallback(cnc.getCommand(), null));
            }
            try {
                this.m_commandStore.put(serialized_bytes);
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "ClientCommandSender.persist-failure", new Object[]{cnc.getCommand()});
            }
        }
    }

    private CommandAndCallback unspoolCommandAndCallback() {
        CommandAndCallback next = null;
        if (this.m_commandStore != null) {
            try {
                next = (CommandAndCallback)this.m_commandStore.takeObject();
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "ClientCommandSender.command-store-take-failure", new Object[]{this.m_remoteCommunicator});
            }
        }
        return next;
    }

    private ClientCommandSenderTask getTaskFromRunnable(Runnable r) {
        return (ClientCommandSenderTask)r;
    }
}

