/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import mazz.i18n.Logger;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.core.communications.command.annotation.Asynchronous;
import org.rhq.core.communications.command.annotation.DisableSendThrottling;
import org.rhq.core.communications.command.annotation.Timeout;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.command.AbstractCommandResponse;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.CommandResponseCallback;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.communications.command.client.RemoteOutputStream;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommandResponse;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ClientRemotePojoFactory {
    private static final Logger LOG = CommI18NFactory.getLogger(ClientRemotePojoFactory.class);
    private final ClientCommandSender m_clientCommandSender;
    private boolean m_ignoreAnnotations;
    private boolean m_asyncModeEnabled;
    private CommandResponseCallback m_asyncCallback;
    private Long m_timeoutMillis;
    private GuaranteedDelivery m_deliveryGuaranteed;
    private boolean m_sendThrottled;

    public ClientRemotePojoFactory(ClientCommandSender ccs) {
        this.m_clientCommandSender = ccs;
        this.m_ignoreAnnotations = false;
        this.m_asyncModeEnabled = false;
        this.m_asyncCallback = null;
        this.m_timeoutMillis = null;
        this.m_deliveryGuaranteed = GuaranteedDelivery.NO;
        this.m_sendThrottled = true;
    }

    public <T> T getRemotePojo(Class<T> targetInterface) {
        return this.getRemotePojo(targetInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getRemotePojo(Class<T> targetInterface, Long timeoutOverride) {
        boolean send_throttled;
        GuaranteedDelivery guaranteed_delivery;
        Long timeout_millis;
        CommandResponseCallback async_callback;
        boolean async_mode;
        boolean ignore_annotations;
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            ignore_annotations = this.m_ignoreAnnotations;
            async_mode = this.m_asyncModeEnabled;
            async_callback = this.m_asyncCallback;
            timeout_millis = timeoutOverride != null ? timeoutOverride : this.m_timeoutMillis;
            guaranteed_delivery = this.m_deliveryGuaranteed;
            send_throttled = this.m_sendThrottled;
        }
        Class[] interfaces = new Class[]{targetInterface};
        ClassLoader class_loader = targetInterface.getClassLoader();
        RemotePojoProxyHandler proxy_handler = new RemotePojoProxyHandler(targetInterface.getName(), ignore_annotations, async_mode, async_callback, timeout_millis, guaranteed_delivery, send_throttled);
        Object proxy = Proxy.newProxyInstance(class_loader, interfaces, (InvocationHandler)proxy_handler);
        return (T)proxy;
    }

    public boolean isIgnoreAnnotations() {
        return this.m_ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignore) {
        this.m_ignoreAnnotations = ignore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsynch() {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            return this.m_asyncModeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsynch(boolean is_async, CommandResponseCallback callback) {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            this.m_asyncModeEnabled = is_async;
            this.m_asyncCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTimeout() {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            return this.m_timeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(Long timeoutMillis) {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            this.m_timeoutMillis = timeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeliveryGuaranteed() {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            return GuaranteedDelivery.YES == this.m_deliveryGuaranteed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryGuaranteed(GuaranteedDelivery guaranteed) {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            this.m_deliveryGuaranteed = guaranteed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendThrottled() {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            return this.m_sendThrottled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendThrottled(boolean throttled) {
        ClientRemotePojoFactory clientRemotePojoFactory = this;
        synchronized (clientRemotePojoFactory) {
            this.m_sendThrottled = throttled;
        }
    }

    private class RemotePojoProxyHandler
    implements InvocationHandler {
        private String m_targetInterfaceName;
        private boolean m_proxyHandlerIgnoreAnnotations;
        private boolean m_proxyHandlerAsyncModeEnabled;
        private CommandResponseCallback m_proxyHandlerAsyncCallback;
        private Long m_proxyHandlerTimeout;
        private GuaranteedDelivery m_proxyHandlerDeliveryGuaranteed;
        private boolean m_proxyHandlerSendThrottled;

        public RemotePojoProxyHandler(String target_interface_name, boolean ignore_annotations, boolean async_mode_enabled, CommandResponseCallback async_callback, Long timeout_millis, GuaranteedDelivery delivery_guaranteed, boolean send_throttled) {
            this.m_targetInterfaceName = target_interface_name;
            this.m_proxyHandlerIgnoreAnnotations = ignore_annotations;
            this.m_proxyHandlerAsyncModeEnabled = async_mode_enabled;
            this.m_proxyHandlerAsyncCallback = async_callback;
            this.m_proxyHandlerTimeout = timeout_millis;
            this.m_proxyHandlerDeliveryGuaranteed = delivery_guaranteed;
            this.m_proxyHandlerSendThrottled = send_throttled;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            String[] paramSig = this.createParamSignature(method.getParameterTypes());
            NameBasedInvocation invocation = new NameBasedInvocation(methodName, args, paramSig);
            AbstractCommandResponse response = null;
            Throwable throwable = null;
            RemotePojoInvocationCommand cmd = new RemotePojoInvocationCommand();
            cmd.setNameBasedInvocation(invocation);
            cmd.setTargetInterfaceName(this.m_targetInterfaceName);
            boolean async_mode_enabled = this.determineAsynchronous(method);
            Long timeout = this.determineTimeout(method);
            boolean guaranteed_delivery = this.determineGuaranteedDelivery(method);
            boolean send_throttle_enabled = this.determineSendThrottling(method);
            if (send_throttle_enabled) {
                cmd.getConfiguration().setProperty("rhq.send-throttle", Boolean.toString(true));
            }
            if (timeout != null) {
                cmd.getConfiguration().setProperty("rhq.timeout", timeout.toString());
            }
            try {
                if (async_mode_enabled) {
                    if (guaranteed_delivery) {
                        ClientRemotePojoFactory.this.m_clientCommandSender.sendAsynchGuaranteed(cmd, this.m_proxyHandlerAsyncCallback);
                    } else {
                        ClientRemotePojoFactory.this.m_clientCommandSender.sendAsynch(cmd, this.m_proxyHandlerAsyncCallback);
                    }
                } else {
                    CommandResponse sendsync_response = ClientRemotePojoFactory.this.m_clientCommandSender.sendSynch(cmd);
                    response = new RemotePojoInvocationCommandResponse(sendsync_response);
                    if (response.getException() != null) {
                        throw response.getException();
                    }
                }
            }
            catch (CannotConnectException cce) {
                throwable = cce;
            }
            catch (InvocationTargetException ite) {
                Throwable root = ite.getCause();
                throwable = root == null ? ite : root;
            }
            catch (Throwable e) {
                throwable = e;
            }
            if (throwable != null) {
                LOG.debug("ClientRemotePojoFactory.execution-failure", new Object[]{methodName, ThrowableUtil.getAllMessages((Throwable)throwable, (boolean)true)});
                if (async_mode_enabled) {
                    response = new RemotePojoInvocationCommandResponse((Command)cmd, throwable);
                    if (this.m_proxyHandlerAsyncCallback != null) {
                        this.m_proxyHandlerAsyncCallback.commandSent(response);
                    }
                } else {
                    throw throwable;
                }
            }
            Object invoke_return = null;
            if (response != null) {
                invoke_return = response.getResults();
                if (invoke_return instanceof RemoteInputStream) {
                    ((RemoteInputStream)invoke_return).setClientCommandSender(ClientRemotePojoFactory.this.m_clientCommandSender);
                } else if (invoke_return instanceof RemoteOutputStream) {
                    ((RemoteOutputStream)invoke_return).setClientCommandSender(ClientRemotePojoFactory.this.m_clientCommandSender);
                }
            }
            return invoke_return;
        }

        private String[] createParamSignature(Class<?>[] args) {
            if (args == null || args.length == 0) {
                return new String[0];
            }
            String[] paramSig = new String[args.length];
            for (int x = 0; x < args.length; ++x) {
                paramSig[x] = args[x].getName();
            }
            return paramSig;
        }

        private boolean determineAsynchronous(Method method) {
            boolean ret_async_mode_enabled = this.m_proxyHandlerAsyncModeEnabled;
            if (!this.m_proxyHandlerIgnoreAnnotations) {
                Asynchronous annotation = method.getAnnotation(Asynchronous.class);
                if (annotation == null) {
                    annotation = method.getDeclaringClass().getAnnotation(Asynchronous.class);
                }
                if (annotation != null) {
                    ret_async_mode_enabled = annotation.value();
                }
            }
            return ret_async_mode_enabled;
        }

        private Long determineTimeout(Method method) {
            Long ret_timeout = this.m_proxyHandlerTimeout;
            if (!this.m_proxyHandlerIgnoreAnnotations) {
                Timeout annotation = method.getAnnotation(Timeout.class);
                if (annotation == null) {
                    annotation = method.getDeclaringClass().getAnnotation(Timeout.class);
                }
                if (annotation != null) {
                    ret_timeout = annotation.value();
                }
            }
            return ret_timeout;
        }

        private boolean determineGuaranteedDelivery(Method method) {
            boolean ret_delivery_guaranteed;
            boolean bl = ret_delivery_guaranteed = GuaranteedDelivery.YES == this.m_proxyHandlerDeliveryGuaranteed;
            if (!this.m_proxyHandlerIgnoreAnnotations) {
                Asynchronous annotation = method.getAnnotation(Asynchronous.class);
                if (annotation == null) {
                    annotation = method.getDeclaringClass().getAnnotation(Asynchronous.class);
                }
                if (annotation != null && (ret_delivery_guaranteed = annotation.guaranteedDelivery()) && GuaranteedDelivery.DISABLED == this.m_proxyHandlerDeliveryGuaranteed) {
                    ret_delivery_guaranteed = false;
                    LogFactory.getLog(ClientRemotePojoFactory.class).error((Object)("Illegal use of Guaranteed Delivery, Remove 'guaranteedDelivery=true' from method: " + method.getName()));
                }
            }
            return ret_delivery_guaranteed;
        }

        private boolean determineSendThrottling(Method method) {
            boolean ret_send_throttled = this.m_proxyHandlerSendThrottled;
            if (!this.m_proxyHandlerIgnoreAnnotations) {
                DisableSendThrottling annotation = method.getAnnotation(DisableSendThrottling.class);
                if (annotation == null) {
                    annotation = method.getDeclaringClass().getAnnotation(DisableSendThrottling.class);
                }
                if (annotation != null) {
                    ret_send_throttled = !annotation.value();
                }
            }
            return ret_send_throttled;
        }
    }

    public static enum GuaranteedDelivery {
        YES,
        NO,
        DISABLED;

    }
}

