/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.impl.stream.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import mazz.i18n.Logger;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.CommandType;
import org.rhq.enterprise.communications.command.impl.stream.RemoteOutputStreamCommand;
import org.rhq.enterprise.communications.command.impl.stream.RemoteOutputStreamCommandResponse;
import org.rhq.enterprise.communications.command.server.CommandService;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.ClassUtil;

public class RemoteOutputStreamCommandService
extends CommandService {
    private static final Logger LOG = CommI18NFactory.getLogger(RemoteOutputStreamCommandService.class);
    private final Object m_lock = new Object();
    private long m_index = 0L;
    private final Map<Long, OutputStream> m_remotedOutputStreams = new HashMap<Long, OutputStream>();
    private final Map<Long, AtomicLong> m_lastAccessTimes = new HashMap<Long, AtomicLong>();
    private long m_maxIdleTime = 30000L;
    private Timer m_idleTimer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addOutputStream(OutputStream stream) {
        Long stream_id;
        AtomicLong lat = new AtomicLong(System.currentTimeMillis());
        Object object = this.m_lock;
        synchronized (object) {
            stream_id = ++this.m_index;
            this.m_remotedOutputStreams.put(stream_id, stream);
            this.m_lastAccessTimes.put(stream_id, lat);
            if (this.m_idleTimer == null) {
                this.m_idleTimer = new Timer("RHQ Idle Output Stream Timer Thread", true);
            }
            this.createIdleTimerTask(stream_id, lat);
        }
        LOG.debug("RemoteOutputStreamCommandService.added-stream", new Object[]{stream_id});
        return stream_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutputStream(Long stream_id) {
        AtomicLong doomed_lat;
        OutputStream doomed_stream;
        Object object = this.m_lock;
        synchronized (object) {
            doomed_stream = this.m_remotedOutputStreams.remove(stream_id);
            doomed_lat = this.m_lastAccessTimes.remove(stream_id);
            if (this.m_remotedOutputStreams.size() == 0 && this.m_idleTimer != null) {
                this.m_idleTimer.cancel();
                this.m_idleTimer = null;
            }
        }
        if (doomed_stream != null) {
            try {
                doomed_stream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            LOG.debug("RemoteOutputStreamCommandService.removed-stream", new Object[]{stream_id});
        }
        if (doomed_lat != null) {
            doomed_lat.set(0L);
        }
        return doomed_stream != null;
    }

    @Override
    public void startService() {
        super.startService();
        this.m_maxIdleTime = this.getServiceContainer().getConfiguration().getRemoteStreamMaxIdleTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() {
        super.stopService();
        Object object = this.m_lock;
        synchronized (object) {
            Long[] doomed_ids = this.m_remotedOutputStreams.keySet().toArray(new Long[0]);
            for (int i = 0; i < doomed_ids.length; ++i) {
                this.removeOutputStream(doomed_ids[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResponse execute(Command command, InputStream in, OutputStream out) {
        RemoteOutputStreamCommandResponse response;
        RemoteOutputStreamCommand remote_command = new RemoteOutputStreamCommand(command);
        NameBasedInvocation invocation = remote_command.getNameBasedInvocation();
        String method_name = invocation.getMethodName();
        Object[] params = invocation.getParameters();
        String[] signature = invocation.getSignature();
        Class[] class_signature = new Class[signature.length];
        try {
            OutputStream the_stream;
            Long stream_id = remote_command.getStreamId();
            Object object = this.m_lock;
            synchronized (object) {
                the_stream = this.m_remotedOutputStreams.get(stream_id);
                if (the_stream == null) {
                    throw new IllegalArgumentException(LOG.getMsgString("RemoteOutputStreamCommandService.invalid-stream-id", new Object[]{stream_id, remote_command}));
                }
                this.setLastAccess(stream_id, System.currentTimeMillis());
            }
            LOG.debug("RemoteOutputStreamCommandService.invoking-stream-from-remote-client", new Object[]{stream_id, method_name});
            for (int x = 0; x < signature.length; ++x) {
                class_signature[x] = ClassUtil.getClassFromTypeName(signature[x]);
            }
            Method method = OutputStream.class.getMethod(method_name, class_signature);
            Object results = method.invoke((Object)the_stream, params);
            response = new RemoteOutputStreamCommandResponse((Command)remote_command, results);
            if ("close".equals(method_name)) {
                this.setLastAccess(stream_id, 0L);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "RemoteOutputStreamCommandService.invoke-stream-failure", new Object[]{method_name, remote_command});
            response = new RemoteOutputStreamCommandResponse((Command)remote_command, e);
        }
        return response;
    }

    @Override
    public CommandType[] getSupportedCommandTypes() {
        return new CommandType[]{RemoteOutputStreamCommand.COMMAND_TYPE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastAccess(Long stream_id, long timestamp) {
        AtomicLong lat;
        Object object = this.m_lock;
        synchronized (object) {
            lat = this.m_lastAccessTimes.get(stream_id);
        }
        if (lat != null && lat.get() > 0L) {
            lat.set(timestamp);
        }
    }

    private void createIdleTimerTask(final Long stream_id, final AtomicLong lat) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - lat.get() > RemoteOutputStreamCommandService.this.m_maxIdleTime) {
                    try {
                        if (RemoteOutputStreamCommandService.this.removeOutputStream(stream_id)) {
                            LOG.debug("RemoteOutputStreamCommandService.removed-idle-stream", new Object[]{stream_id, RemoteOutputStreamCommandService.this.m_maxIdleTime});
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("RemoteOutputStreamCommandService.timer-task-cannot-remove-stream", new Object[]{stream_id, e});
                    }
                    this.cancel();
                    return;
                }
            }
        };
        this.m_idleTimer.schedule(task, 5000L, 5000L);
    }
}

