/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;

public abstract class AbstractParameterDefinitionIterator
implements Iterator {
    private List<ParameterDefinition> m_parameterDefinitions = new ArrayList<ParameterDefinition>();
    private Iterator m_internalIterator;

    public AbstractParameterDefinitionIterator(Collection<ParameterDefinition> parameterDefinitions, boolean required) {
        if (parameterDefinitions != null) {
            for (ParameterDefinition paramDef : parameterDefinitions) {
                if ((!required || !paramDef.isRequired()) && (required || paramDef.isRequired())) continue;
                this.m_parameterDefinitions.add(paramDef);
            }
        }
        this.m_internalIterator = this.m_parameterDefinitions.iterator();
    }

    public AbstractParameterDefinitionIterator(ParameterDefinition[] parameterDefinitions, boolean required) {
        this(AbstractParameterDefinitionIterator.buildCollection(parameterDefinitions), required);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.m_internalIterator.hasNext();
    }

    public Object next() {
        return this.m_internalIterator.next();
    }

    private static Collection<ParameterDefinition> buildCollection(ParameterDefinition[] parameterDefinitions) {
        ArrayList<ParameterDefinition> collection = new ArrayList<ParameterDefinition>();
        if (parameterDefinitions != null) {
            for (int i = 0; i < parameterDefinitions.length; ++i) {
                collection.add(parameterDefinitions[i]);
            }
        }
        return collection;
    }
}

