/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.io.Serializable;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ParameterDefinition m_definition;
    private Object m_value;
    private boolean m_dirty;

    public Parameter(Parameter original) {
        this(original.getDefinition(), original.getValue(), original.isDirty());
    }

    protected Parameter(ParameterDefinition definition, Object value, boolean isDirty) {
        this.m_definition = definition;
        this.m_value = value;
        this.m_dirty = isDirty;
    }

    public Parameter(ParameterDefinition definition, Object value) {
        this(definition, value, false);
    }

    public String getName() {
        return this.getDefinition().getName();
    }

    public ParameterDefinition getDefinition() {
        return this.m_definition;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        this.m_value = value;
        this.m_dirty = true;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showValue) {
        StringBuffer str = new StringBuffer("Parameter: ");
        str.append("def=[" + this.m_definition + "]");
        str.append("; value's class=[" + (this.m_value == null ? "null" : this.m_value.getClass().toString()) + "]");
        str.append("; dirty=[" + this.m_dirty + "]");
        if (showValue) {
            str.append("; value=[" + (this.m_value == null ? "null" : this.m_value.toString()) + "]");
        }
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value)) {
            return false;
        }
        return !(this.m_definition == null ? other.m_definition != null : !this.m_definition.equals(other.m_definition));
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (this.m_definition == null ? 0 : this.m_definition.hashCode());
        hash = hash * 31 + (this.m_value == null ? 0 : this.m_value.hashCode());
        return hash;
    }
}

