/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.param.InvalidParameterValueException;
import org.rhq.enterprise.communications.command.param.ParameterRenderingInformation;
import org.rhq.enterprise.communications.command.param.TextFieldRenderingInformation;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ParameterDefinition
implements Serializable {
    private static final Logger LOG = CommI18NFactory.getLogger(ParameterDefinition.class);
    public static final boolean REQUIRED = true;
    public static final boolean OPTIONAL = false;
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    public static final boolean HIDDEN = true;
    public static final boolean NOT_HIDDEN = false;
    private final String m_name;
    private final String m_type;
    private final boolean m_required;
    private final boolean m_nullable;
    private final boolean m_hidden;
    private final String m_description;
    private ParameterRenderingInformation m_renderingInfo;
    private static final long serialVersionUID = 1L;

    public ParameterDefinition(String name, String type, ParameterRenderingInformation renderingInfo) throws IllegalArgumentException {
        this(name, type, false, null, renderingInfo);
    }

    public ParameterDefinition(String name, String type, boolean hidden, String description) throws IllegalArgumentException {
        this(name, type, hidden, description, null);
    }

    public ParameterDefinition(String name, String type, boolean hidden, String description, ParameterRenderingInformation renderingInfo) throws IllegalArgumentException {
        this(name, type, false, true, hidden, description, renderingInfo);
    }

    public ParameterDefinition(String name, String type, boolean required, boolean nullable, boolean hidden, String description) throws IllegalArgumentException {
        this(name, type, required, nullable, hidden, description, null);
    }

    public ParameterDefinition(String name, String type, boolean required, boolean nullable, boolean hidden, String description, ParameterRenderingInformation renderingInfo) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name=null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type=null");
        }
        this.m_name = name;
        this.m_type = type;
        this.m_required = required;
        this.m_nullable = nullable;
        this.m_hidden = hidden;
        this.m_description = description;
        if (renderingInfo == null) {
            renderingInfo = this.getDefaultRenderingInfo();
        }
        this.m_renderingInfo = renderingInfo;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public boolean isNullable() {
        return this.m_nullable;
    }

    public boolean isHidden() {
        boolean flag = this.m_hidden;
        if (this.getRenderingInfo() != null) {
            flag = this.getRenderingInfo().isHidden();
        }
        return flag;
    }

    public String getDescription() {
        String desc = this.m_description;
        if (this.getRenderingInfo() != null) {
            desc = this.getRenderingInfo().getDescription();
        }
        return desc;
    }

    public ParameterRenderingInformation getRenderingInfo() {
        return this.m_renderingInfo;
    }

    public void setRenderingInfo(ParameterRenderingInformation renderingInfo) {
        this.m_renderingInfo = renderingInfo;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("ParamDef: ");
        strbuf.append("name=[");
        strbuf.append(this.m_name);
        strbuf.append("]; type=[");
        strbuf.append(this.m_type);
        strbuf.append("]; required=[");
        strbuf.append(this.m_required);
        strbuf.append("]; nullable=[");
        strbuf.append(this.m_nullable);
        strbuf.append("]; hidden=[");
        strbuf.append(this.m_hidden);
        strbuf.append("]; description=[");
        strbuf.append(this.m_description);
        strbuf.append("]");
        return strbuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParameterDefinition)) {
            return false;
        }
        return this.m_name.equals(((ParameterDefinition)obj).m_name);
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean isValidValue(Object valueToCheck) {
        boolean valid;
        if (valueToCheck == null) {
            valid = this.isNullable();
        } else {
            try {
                Class<?> parameterTypeClass = Class.forName(this.getType());
                valid = parameterTypeClass.isInstance(valueToCheck);
            }
            catch (ClassNotFoundException e) {
                valid = false;
            }
        }
        return valid;
    }

    public Object convertObject(Object objectToConvert) throws InvalidParameterValueException {
        Object convertedObject;
        Class<?> conversionClass;
        if (objectToConvert == null) {
            if (!this.isNullable()) {
                throw new InvalidParameterValueException(LOG.getMsgString("ParameterDefinition.not-nullable", new Object[]{this.m_name}));
            }
            return objectToConvert;
        }
        String conversionClassString = this.getType();
        try {
            conversionClass = Class.forName(conversionClassString);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InvalidParameterValueException(cnfe);
        }
        if (!conversionClass.isInstance(objectToConvert)) {
            convertedObject = this.convertObject(objectToConvert, conversionClass);
            if (!this.isValidValue(convertedObject)) {
                throw new InvalidParameterValueException(LOG.getMsgString("ParameterDefinition.still-not-valid", new Object[]{convertedObject.getClass()}));
            }
        } else {
            convertedObject = objectToConvert;
        }
        return convertedObject;
    }

    protected ParameterRenderingInformation getDefaultRenderingInfo() {
        Class valueClass = ParameterDefinition.getClassFromTypeName(this.m_type);
        ParameterRenderingInformation renderingInfo = Map.class.isAssignableFrom(valueClass) ? new TextFieldRenderingInformation(50, 5) : (Collection.class.isAssignableFrom(valueClass) || valueClass.isArray() ? new TextFieldRenderingInformation(50, 1) : new ParameterRenderingInformation());
        this.setDefaultRenderingAttributes(renderingInfo);
        return renderingInfo;
    }

    protected void setDefaultRenderingAttributes(ParameterRenderingInformation renderingInfo) {
        renderingInfo.setLabel(this.m_name);
        renderingInfo.setDescription(this.m_description);
        renderingInfo.setHidden(this.m_hidden);
    }

    private static Class getClassFromTypeName(String className) throws IllegalArgumentException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("className=null");
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(LOG.getMsgString("ParameterDefinition.class-not-found", new Object[]{className}));
        }
    }

    private Object convertObject(Object objectToConvert, Class conversionClass) throws InvalidParameterValueException {
        if (conversionClass.isPrimitive()) {
            throw new InvalidParameterValueException(LOG.getMsgString("ParameterDefinition.cannot-convert-primitive", new Object[]{conversionClass}));
        }
        if (conversionClass.isArray()) {
            return this.convertArrayObject(objectToConvert, conversionClass);
        }
        Object convertedObject = null;
        if (!conversionClass.isInstance(objectToConvert)) {
            Exception constructorInvocationException = null;
            Constructor<?>[] constructors = conversionClass.getConstructors();
            for (int i = 0; i < constructors.length && convertedObject == null; ++i) {
                Class<?>[] params = constructors[i].getParameterTypes();
                if (params.length != 1 || !params[0].isInstance(objectToConvert)) continue;
                try {
                    convertedObject = constructors[i].newInstance(objectToConvert);
                    continue;
                }
                catch (Exception e) {
                    constructorInvocationException = e;
                }
            }
            if (convertedObject == null) {
                if (constructorInvocationException != null) {
                    throw new InvalidParameterValueException(LOG.getMsgString("ParameterDefinition.cannot-convert", new Object[]{conversionClass}), constructorInvocationException);
                }
                throw new InvalidParameterValueException(LOG.getMsgString("ParameterDefinition.cannot-convert-no-constructor", new Object[]{conversionClass, objectToConvert.getClass()}));
            }
        } else {
            convertedObject = objectToConvert;
        }
        return convertedObject;
    }

    private Object[] convertArrayObject(Object objectToConvert, Class conversionClass) throws InvalidParameterValueException {
        Object[] objectArrayToConvert;
        if (!objectToConvert.getClass().isArray()) {
            ArrayList<String> stringArray = new ArrayList<String>();
            String objectToString = objectToConvert.toString();
            if (objectToString == null) {
                objectToString = "";
            }
            if (objectToString.length() > 0) {
                String delimiters = ",.;:|/!#$%^&*-_+= \t\n\r";
                char firstChar = objectToString.charAt(0);
                char theDelimiter = delimiters.indexOf(firstChar) != -1 ? firstChar : (char)',';
                StringTokenizer strtok = new StringTokenizer(objectToString, Character.toString(theDelimiter));
                while (strtok.hasMoreTokens()) {
                    stringArray.add((String)strtok.nextElement());
                }
            }
            objectArrayToConvert = stringArray.toArray(new String[stringArray.size()]);
        } else {
            objectArrayToConvert = (Object[])objectToConvert;
        }
        Class<?> arrayElementType = conversionClass.getComponentType();
        Object[] retConvertedArray = (Object[])Array.newInstance(arrayElementType, objectArrayToConvert.length);
        for (int i = 0; i < objectArrayToConvert.length; ++i) {
            retConvertedArray[i] = this.convertObject(objectArrayToConvert[i], arrayElementType);
        }
        return retConvertedArray;
    }
}

