/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.command.impl.stream.RemoteInputStreamCommand;
import org.rhq.enterprise.communications.command.impl.stream.RemoteOutputStreamCommand;

public class CommandTraceUtil {
    private static final String SYSPROP_TRACE_COMMAND_CONFIG = "rhq.trace-command-config";
    private static final String SYSPROP_TRACE_COMMAND_RESPONSE_RESULTS = "rhq.trace-command-response-results";
    private static final String SYSPROP_TRACE_COMMAND_SIZE_THRESHOLD = "rhq.trace-command-size-threshold";
    private static final String SYSPROP_TRACE_COMMAND_RESPONSE_SIZE_THRESHOLD = "rhq.trace-command-response-size-threshold";
    private static Map<String, String> interfaceSimpleNames = null;

    public static Boolean getSettingTraceCommandConfig() {
        if (System.getProperty(SYSPROP_TRACE_COMMAND_CONFIG) != null) {
            return Boolean.getBoolean(SYSPROP_TRACE_COMMAND_CONFIG);
        }
        return null;
    }

    public static void setSettingTraceCommandConfig(Boolean val) {
        System.setProperty(SYSPROP_TRACE_COMMAND_CONFIG, val != null ? Boolean.toString(val) : "false");
    }

    public static Integer getSettingTraceCommandResponseResults() {
        int val = CommandTraceUtil.getPropertyInt(SYSPROP_TRACE_COMMAND_RESPONSE_RESULTS);
        return val != -1 ? Integer.valueOf(val) : null;
    }

    public static void setSettingTraceCommandResponseResults(Integer val) {
        System.setProperty(SYSPROP_TRACE_COMMAND_RESPONSE_RESULTS, val != null ? Integer.toString(val) : "-1");
    }

    public static Integer getSettingTraceCommandSizeThreshold() {
        int val = CommandTraceUtil.getPropertyInt(SYSPROP_TRACE_COMMAND_SIZE_THRESHOLD);
        return val != -1 ? Integer.valueOf(val) : null;
    }

    public static void setSettingTraceCommandSizeThreshold(Integer val) {
        System.setProperty(SYSPROP_TRACE_COMMAND_SIZE_THRESHOLD, val != null ? Integer.toString(val) : "-1");
    }

    public static Integer getSettingTraceCommandResponseSizeThreshold() {
        int val = CommandTraceUtil.getPropertyInt(SYSPROP_TRACE_COMMAND_RESPONSE_SIZE_THRESHOLD);
        return val != -1 ? Integer.valueOf(val) : null;
    }

    public static void setSettingTraceCommandResponseSizeThreshold(Integer val) {
        System.setProperty(SYSPROP_TRACE_COMMAND_RESPONSE_SIZE_THRESHOLD, val != null ? Integer.toString(val) : "-1");
    }

    public static String getConfigString(Command command) {
        Properties config = null;
        if (command != null && Boolean.getBoolean(SYSPROP_TRACE_COMMAND_CONFIG)) {
            config = command.getConfiguration();
        }
        return config != null ? config.toString() : "?";
    }

    public static String getCommandString(Command command) {
        String commandString;
        if (command == null) {
            commandString = "null command";
        } else if (command.getCommandType().equals(RemotePojoInvocationCommand.COMMAND_TYPE)) {
            RemotePojoInvocationCommand remoteCmd = (RemotePojoInvocationCommand)command;
            StringBuilder fullMethod = new StringBuilder(CommandTraceUtil.getInterfaceSimpleName(remoteCmd.getTargetInterfaceName()));
            fullMethod.append('.');
            fullMethod.append(remoteCmd.getNameBasedInvocation().getMethodName());
            commandString = fullMethod.toString();
        } else if (command.getCommandType().equals(RemoteOutputStreamCommand.COMMAND_TYPE)) {
            RemoteOutputStreamCommand streamCmd = (RemoteOutputStreamCommand)command;
            StringBuilder fullMethod = new StringBuilder("OutputStream.");
            fullMethod.append(streamCmd.getNameBasedInvocation().getMethodName());
            fullMethod.append('.');
            fullMethod.append(streamCmd.getStreamId());
            commandString = fullMethod.toString();
        } else if (command.getCommandType().equals(RemoteInputStreamCommand.COMMAND_TYPE)) {
            RemoteInputStreamCommand streamCmd = (RemoteInputStreamCommand)command;
            StringBuilder fullMethod = new StringBuilder("InputStream.");
            fullMethod.append(streamCmd.getNameBasedInvocation().getMethodName());
            fullMethod.append('.');
            fullMethod.append(streamCmd.getStreamId());
            commandString = fullMethod.toString();
        } else {
            commandString = command.getCommandType().getName();
        }
        return commandString;
    }

    public static String getCommandResponseString(Object response) {
        CommandResponse cmdResponse;
        String responseString = response instanceof CommandResponse ? ((cmdResponse = (CommandResponse)response).isSuccessful() ? (System.getProperty(SYSPROP_TRACE_COMMAND_RESPONSE_RESULTS) != null ? "success:" + CommandTraceUtil.getCommandResponseResultsString(cmdResponse.getResults()) : "success") : "failed:" + ThrowableUtil.getAllMessages((Throwable)cmdResponse.getException())) : (response instanceof Throwable ? ThrowableUtil.getAllMessages((Throwable)((Throwable)response)) : (response instanceof String ? "STRING:" + response.toString() : (response == null ? "NULL" : "UNEXPECTED:" + response.getClass().getName())));
        return responseString;
    }

    public static int getCommandSize(Command command) throws NotSerializableException {
        int threshold = CommandTraceUtil.getPropertyInt(SYSPROP_TRACE_COMMAND_SIZE_THRESHOLD);
        if (threshold > -1) {
            try {
                int size = StreamUtil.serialize((Serializable)command).length;
                if (size > threshold) {
                    return size;
                }
            }
            catch (Exception e) {
                throw new NotSerializableException(ThrowableUtil.getAllMessages((Throwable)e));
            }
        }
        return -1;
    }

    public static int getCommandResponseSize(Object response) throws NotSerializableException {
        int threshold = CommandTraceUtil.getPropertyInt(SYSPROP_TRACE_COMMAND_RESPONSE_SIZE_THRESHOLD);
        if (threshold > -1) {
            try {
                int size = StreamUtil.serialize((Serializable)((Serializable)response)).length;
                if (size > threshold) {
                    return size;
                }
            }
            catch (Exception e) {
                throw new NotSerializableException(ThrowableUtil.getAllMessages((Throwable)e));
            }
        }
        return -1;
    }

    private static String getCommandResponseResultsString(Object results) {
        int maxLength;
        if (results == null) {
            return "null";
        }
        StringBuilder resultsString = new StringBuilder();
        try {
            resultsString.append(results.toString());
        }
        catch (Throwable t) {
            return "toString failed: [" + t + "]";
        }
        try {
            maxLength = Integer.parseInt(System.getProperty(SYSPROP_TRACE_COMMAND_RESPONSE_RESULTS));
        }
        catch (NumberFormatException e) {
            maxLength = 256;
        }
        if (resultsString.length() > maxLength) {
            resultsString.setLength(maxLength);
            resultsString.append("...");
        }
        return resultsString.toString().replaceAll("[\r\n]", ".");
    }

    private static String getInterfaceSimpleName(String interfaceName) {
        String simpleName;
        if (interfaceName == null) {
            return "unknown";
        }
        if (interfaceSimpleNames == null) {
            interfaceSimpleNames = new Hashtable<String, String>();
        }
        if ((simpleName = interfaceSimpleNames.get(interfaceName)) == null) {
            int period = interfaceName.lastIndexOf(46);
            simpleName = period == -1 || period == interfaceName.length() - 1 ? interfaceName : interfaceName.substring(period + 1);
            interfaceSimpleNames.put(interfaceName, simpleName);
        }
        return simpleName;
    }

    private static int getPropertyInt(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                return Integer.parseInt(propertyValue, 10);
            }
            catch (Exception e) {
                System.setProperty(propertyName, "-1");
            }
        }
        return -1;
    }
}

