/*
 * RHQ Management Platform
 * Copyright (C) 2005-2011 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.rhq.core.domain.sync;

import java.io.InputStream;
import java.util.Map;

/**
 * This is a class used to report both the export file itself and the notification or error messages
 * coming from the individual subsystem exporters while creating that file.
 * <p>
 * Note that the map of the messages is filled in lazily while the stream is being read and the list
 * of messages is not complete until you read the whole stream of the export file.
 *
 * @author Lukas Krejci
 */
public class ExportWrapper {

    private Map<String, ExporterMessages> messagesPerExporter;
    
    private InputStream exportFile;

    /**
     * @param messagesPerExporter
     * @param exportFile
     */
    public ExportWrapper(Map<String, ExporterMessages> messagesPerExporter, InputStream exportFile) {
        super();
        this.messagesPerExporter = messagesPerExporter;
        this.exportFile = exportFile;
    }

    /**
     * The list of messages generated by the exporters while creating the export file.
     * Note that this map is being written to while the {@link #getExportFile() export file} stream
     * is being read and therefore is not complete until the end of that stream is reached.
     * 
     * @return the messagesPerExporter
     */
    public Map<String, ExporterMessages> getMessagesPerExporter() {
        return messagesPerExporter;
    }

    /**
     * @return the exportFile
     */
    public InputStream getExportFile() {
        return exportFile;
    }
}
