/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.net.URL;
import org.rhq.core.clientapi.server.plugin.content.ContentSourcePackageDetails;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;

public class FullRemotePackageInfo
extends RemotePackageInfo {
    private final ContentSourcePackageDetails details;

    public FullRemotePackageInfo(URL url, ContentSourcePackageDetails details) {
        super(details.getLocation(), url, details.getMD5());
        this.details = details;
        RemotePackageInfo.SupportedPackageType type = new RemotePackageInfo.SupportedPackageType();
        type.packageTypeName = details.getPackageTypeName();
        type.architectureName = details.getArchitectureName();
        type.resourceTypeName = details.getContentSourcePackageDetailsKey().getResourceTypeName();
        type.resourceTypePluginName = details.getContentSourcePackageDetailsKey().getResourceTypePluginName();
        this.setSupportedPackageType(type);
    }

    public ContentSourcePackageDetails getContentSourcePackageDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("FullRemotePackageInfo: ");
        str.append("location=[").append(this.getLocation());
        str.append("], url=[").append(this.getUrl());
        str.append("], md5=[").append(this.getMD5());
        if (this.getSupportedPackageType() != null) {
            str.append("], supportedPackageType=[").append(this.getSupportedPackageType().packageTypeName);
            str.append(",").append(this.getSupportedPackageType().architectureName);
            str.append(",").append(this.getSupportedPackageType().resourceTypeName);
            str.append(",").append(this.getSupportedPackageType().resourceTypePluginName);
            str.append("], ");
        } else {
            str.append("], supportedPackageType=[unknown], ");
        }
        str.append("details=[" + this.details + "]");
        return str.toString();
    }
}

