/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import java.util.Date;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.GetableBasicResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementDataResource
extends GetableBasicResource {
    private String content;
    private List<MetricDisplaySummary> measurements;

    public MeasurementDataResource(Subject subject, Resource managedResource) {
        super(subject, managedResource);
    }

    public String getUniqueId() {
        return "metrics_" + this.getManagedResource().getId();
    }

    public String getName() {
        return "measurement_data.xml";
    }

    public Date getModifiedDate() {
        return new Date();
    }

    public Date getCreateDate() {
        return new Date(this.getManagedResource().getCtime());
    }

    protected String loadContent() {
        if (this.content == null) {
            StringBuilder str = new StringBuilder();
            str.append("<?xml version=\"1.0\"?>\n");
            str.append("<measurements>\n");
            for (MetricDisplaySummary meas : this.getMeasurements()) {
                str.append("   <measurement>\n");
                str.append("      <name>").append(meas.getLabel()).append("</name>\n");
                str.append("      <description>").append(meas.getDescription()).append("</description>\n");
                str.append("      <alert-count>").append(meas.getAlertCount()).append("</alert-count>\n");
                str.append("      <min-value>").append(meas.getMinMetric().getValue()).append("</min-value>\n");
                str.append("      <max-value>").append(meas.getMaxMetric().getValue()).append("</max-value>\n");
                str.append("      <avg-value>").append(meas.getAvgMetric().getValue()).append("</avg-value>\n");
                str.append("      <last-value>").append(meas.getLastMetric().getValue()).append("</last-value>\n");
                str.append("      <units>").append(meas.getUnits()).append("</units>\n");
                str.append("      <begin-time>").append(new Date(meas.getBeginTimeFrame())).append("</begin-time>\n");
                str.append("      <end-time>").append(new Date(meas.getEndTimeFrame())).append("</end-time>\n");
                str.append("      <schedule-id>").append(meas.getScheduleId()).append("</schedule-id>\n");
                str.append("   </measurement>\n");
            }
            str.append("</measurements>\n");
            this.content = str.toString();
        }
        return this.content;
    }

    private List<MetricDisplaySummary> getMeasurements() {
        if (this.measurements == null) {
            int resourceId = this.getManagedResource().getId();
            MeasurementPreferences measurementPrefs = new MeasurementPreferences(this.getSubject());
            MeasurementPreferences.MetricRangePreferences range = measurementPrefs.getMetricRangePreferences();
            MeasurementScheduleManagerLocal sm = LookupUtil.getMeasurementScheduleManager();
            List measurementSchedules = sm.findSchedulesForResourceAndType(this.getSubject(), resourceId, DataType.MEASUREMENT, null, true);
            int[] scheduleIds = new int[measurementSchedules.size()];
            int i = 0;
            for (MeasurementSchedule sched : measurementSchedules) {
                scheduleIds[i++] = sched.getId();
            }
            MeasurementChartsManagerLocal chartManager = LookupUtil.getMeasurementChartsManager();
            this.measurements = chartManager.getMetricDisplaySummariesForResource(this.getSubject(), resourceId, scheduleIds, range.begin.longValue(), range.end.longValue());
        }
        return this.measurements;
    }
}

