/*
 * Decompiled with CFR 0.152.
 */
package org.riodb.plugin;

import org.riodb.plugin.RioDBPluginException;

public class RioDBPluginStatus {
    private static final String[] statusMap = new String[]{"IDLE", "READY", "WARNING", "ERROR"};
    private static final String[] statusDesc = new String[]{"Plugin initialized, but not started.", "Plugin ready", "Plugin encountered a non-fatal error", "Plugin stopped due to fatal error"};
    private int statusCode;

    public RioDBPluginStatus(int statusCode) {
        this.statusCode = statusCode;
        if (this.statusCode < 0) {
            this.statusCode = 0;
        } else if (this.statusCode >= statusMap.length) {
            this.statusCode = statusMap.length - 1;
        }
    }

    public RioDBPluginStatus(String status) throws RioDBPluginException {
        if (status != null) {
            for (int i = 0; i < statusMap.length; ++i) {
                if (!statusMap[i].equals(status)) continue;
                this.statusCode = i;
                break;
            }
        }
        throw new RioDBPluginException("Attempted to set a plugin status to an invalid plugin status name: " + status);
    }

    public String getStatus() {
        return statusMap[this.statusCode];
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDesc() {
        return statusDesc[this.statusCode];
    }
}

