/*
 * Decompiled with CFR 0.152.
 */
package org.riodb.plugin;

import org.riodb.plugin.RioDBStreamMessageField;

public class RioDBStreamMessageDef {
    private RioDBStreamMessageField[] fields = new RioDBStreamMessageField[0];
    private int timestampNumericFieldId;

    public RioDBStreamMessageDef() {
        this.setTimestampNumericFieldId(-1);
    }

    public void addField(RioDBStreamMessageField newField) {
        RioDBStreamMessageField[] newFields = new RioDBStreamMessageField[this.fields.length + 1];
        for (int i = 0; i < this.fields.length; ++i) {
            newFields[i] = this.fields[i];
        }
        newFields[this.fields.length] = newField;
        this.fields = newFields;
    }

    public boolean containsField(String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            return false;
        }
        for (RioDBStreamMessageField f : this.fields) {
            if (!fieldName.equals(f.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean[] getAllNumericFlags() {
        boolean[] b = new boolean[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            b[i] = this.fields[i].isNumeric();
        }
        return b;
    }

    public int getFieldId(String fieldName) {
        int id = -1;
        if (fieldName == null || fieldName.length() == 0) {
            return id;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!fieldName.toLowerCase().equals(this.fields[i].getName().toLowerCase())) continue;
            return i;
        }
        return id;
    }

    public int getFieldIdCaseSensitive(String fieldName) {
        int id = -1;
        if (fieldName == null || fieldName.length() == 0) {
            return id;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!fieldName.equals(this.fields[i].getName())) continue;
            return i;
        }
        return id;
    }

    public String getFieldList() {
        String s = "";
        for (int i = 0; i < this.fields.length; ++i) {
            s = this.fields[i].isNumeric() ? s + "\n{\"order\":" + String.valueOf(i) + ",\"name\":\"" + this.fields[i].getName() + "\",\"type\":\"NUMBER\"}," : s + "\n{\"order\":" + String.valueOf(i) + ",\"name\":\"" + this.fields[i].getName() + "\",\"type\":\"STRING\"},";
        }
        if (s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getFieldName(int index) {
        return this.fields[index].getName();
    }

    public int getNumericFieldCount() {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].isNumeric()) continue;
            ++count;
        }
        return count;
    }

    public int getNumericFieldIndex(int fieldId) {
        int count = 0;
        for (int i = fieldId; i >= 0; --i) {
            if (!this.fields[i].isNumeric()) continue;
            ++count;
        }
        return count - 1;
    }

    public String getNumericFieldName(int numericFieldIndex) {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].isNumeric()) continue;
            if (count == numericFieldIndex) {
                return this.fields[i].getName();
            }
            ++count;
        }
        return null;
    }

    public RioDBStreamMessageField getStreamField(int index) {
        return this.fields[index];
    }

    public RioDBStreamMessageField[] getStreamFields() {
        return this.fields;
    }

    public int getStringFieldCount() {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].isNumeric()) continue;
            ++count;
        }
        return count;
    }

    public int getStringFieldIndex(int fieldId) {
        int count = 0;
        for (int i = fieldId; i >= 0; --i) {
            if (this.fields[i].isNumeric()) continue;
            ++count;
        }
        return count - 1;
    }

    public String getStringFieldName(int stringFieldIndex) {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].isNumeric()) continue;
            if (count == stringFieldIndex) {
                return this.fields[i].getName();
            }
            ++count;
        }
        return null;
    }

    public String getTimestampFieldName() {
        if (this.timestampNumericFieldId >= 0) {
            return this.getNumericFieldName(this.timestampNumericFieldId);
        }
        return null;
    }

    public int getTimestampNumericFieldId() {
        return this.timestampNumericFieldId;
    }

    public boolean isNumeric(int fieldId) {
        return this.fields[fieldId].isNumeric();
    }

    public void setTimestampNumericFieldId(int timestampNumericFieldId) {
        this.timestampNumericFieldId = timestampNumericFieldId;
    }

    public int size() {
        return this.fields.length;
    }
}

