/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.riversun.oauth2.google.OAuthBaseServlet;
import org.riversun.oauth2.google.OAuthHandler;

public abstract class OAuthCallbackServlet
extends OAuthBaseServlet {
    private static final Logger LOGGER = Logger.getLogger(OAuthCallbackServlet.class.getName());
    static final String DUMMY_REFRESH_TOKEN = "org.riversun.dummy_refresh_token";
    private final Map<String, String> mTempRefreshTokenMap = new ConcurrentHashMap<String, String>();

    protected abstract String getAuthRedirectUrl();

    protected void saveRefreshTokenFor(String userId, String refreshToken) {
        LOGGER.fine("userId=" + userId + " refreshToken=" + refreshToken);
        this.mTempRefreshTokenMap.put(userId, refreshToken);
    }

    protected String loadRefreshTokenFor(String userId) {
        String storedRefreshToken = this.mTempRefreshTokenMap.get(userId);
        String refreshToken = storedRefreshToken == null ? DUMMY_REFRESH_TOKEN : storedRefreshToken;
        LOGGER.fine("userId=" + userId + " refreshToken=" + refreshToken);
        return refreshToken;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.fine("");
        String code = this.asString(req, "code");
        String stateToken = this.asString(req, "state");
        if (code != null && stateToken != null) {
            LOGGER.fine("code=" + code);
            String storedStateToken = (String)this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_state_token");
            if (storedStateToken == null || !stateToken.equals(storedStateToken)) {
                LOGGER.warning("stateToken not matched!");
                resp.sendError(403, "OAuth2 state token is invalid. stateToken=" + stateToken + " storedStateToken=" + storedStateToken);
                return;
            }
        } else {
            LOGGER.warning("The parameter 'code' or 'state' not found!");
            resp.sendError(403, "Invalid parameters code=" + code + " state=" + stateToken);
            return;
        }
        LOGGER.fine("stateToken matched state=" + stateToken);
        this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_state_token", null);
        OAuthHandler oh = new OAuthHandler(this.getAuthRedirectUrl());
        GoogleTokenResponse tokenResponse = oh.getTokenResponseFromCode(code);
        LOGGER.fine("Received tokenResponse=" + tokenResponse);
        LOGGER.fine("Received refresh_token=" + tokenResponse.getRefreshToken());
        GoogleIdToken idToken = oh.getIdToken(tokenResponse);
        if (idToken == null) {
            throw new ServletException((Throwable)new Exception("IdToken verification error"));
        }
        GoogleIdToken.Payload payload = idToken.getPayload();
        String userId = payload.getSubject();
        this.sessionScope(req, "org.riversun.goauth.session_key_payload_sub", (Serializable)((Object)userId));
        LOGGER.fine("TOKEN_INFO subject(unique userId)=" + userId);
        String _refreshToken = tokenResponse.getRefreshToken();
        if (_refreshToken != null) {
            this.saveRefreshTokenFor(userId, _refreshToken);
        }
        String refreshToken = this.loadRefreshTokenFor(userId);
        LOGGER.fine("use refresh token refreshToken=" + _refreshToken);
        String accessToken = tokenResponse.getAccessToken();
        LOGGER.fine("Since it is necessary to create a new credential, delete the existing credential in the session");
        this.sessionScope(req, "org.riversun.goauth.session_key_credential", null);
        this.sessionScope(req, "org.riversun.goauth.session_key_access_token", (Serializable)((Object)accessToken));
        if (refreshToken == null || DUMMY_REFRESH_TOKEN.equals(refreshToken)) {
            this.sessionScope(req, "org.riversun.goauth.session_key_refresh_token", null);
        } else {
            this.sessionScope(req, "org.riversun.goauth.session_key_refresh_token", (Serializable)((Object)refreshToken));
        }
        this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_done", Boolean.TRUE);
        String redirectPath = (String)this.sessionScope(req, "org.riversun.goauth.session_key_redirect_url_after_oauth");
        this.sessionScope(req, "org.riversun.goauth.session_key_redirect_url_after_oauth", null);
        if (redirectPath == null || redirectPath.isEmpty()) {
            redirectPath = req.getContextPath() + "/";
        }
        LOGGER.fine("redirectPath=" + redirectPath);
        resp.sendRedirect(redirectPath);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    private final void sendNotSupportedError(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(403, "Not supported");
    }
}

