/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.enums;

public enum Register {
    ModelNumber(0, 2),
    FirmwareVersion(2, 1),
    Id(3, 1),
    BaudRate(4, 1),
    ReturnDelay(5, 1),
    CwAngleLimit(6, 2),
    CcwAngleLimit(8, 2),
    TemperatureLimit(11, 1),
    LowVoltageLimit(12, 1),
    HighVoltageLimit(13, 1),
    MaxTorque(14, 2),
    StatusReturnLevel(16, 1),
    AlarmLed(17, 1),
    AlarmShutdown(18, 1),
    DownCalibration(20, 2),
    UpCalibration(22, 2),
    TorqueEnable(24, 1),
    Led(25, 1),
    CwComplianceMargin(26, 1),
    CcwComplianceMargin(27, 1),
    CwComplianceSlope(28, 1),
    CcwComplianceSlope(29, 1),
    GoalPosition(30, 2, true, true),
    MovingSpeed(32, 2),
    TorqueLimit(34, 2),
    CurrentPosition(36, 2, false),
    CurrentSpeed(38, 2, false),
    CurrentLoad(40, 2, false),
    CurrentVoltage(42, 1, false),
    CurrentTemperature(43, 1, false),
    RegisteredInstruction(44, 1),
    Moving(46, 1, false),
    Lock(47, 1),
    Punch(48, 2);

    private byte myByte;
    private int myLength;
    private boolean myCachedFlag;
    private boolean mySynchronizedFlag;

    private Register(byte b, int l) {
        this(b, l, true, false);
    }

    private Register(byte b, int l, boolean cache) {
        this(b, l, cache, false);
    }

    private Register(byte b, int l, boolean cache, boolean sync) {
        this.myByte = b;
        this.myLength = l;
        this.myCachedFlag = cache;
        this.mySynchronizedFlag = sync;
    }

    public byte getByte() {
        return this.myByte;
    }

    public int getLength() {
        return this.myLength;
    }

    public boolean isCached() {
        return this.myCachedFlag;
    }

    public boolean isSynchronized() {
        return this.mySynchronizedFlag;
    }

    public static Register get(byte b) {
        for (Register es : Register.values()) {
            if (b != es.getByte()) continue;
            return es;
        }
        return null;
    }
}

