/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.feedback;

import org.robokind.impl.motion.dynamixel.DynamixelServo;
import org.robokind.impl.motion.dynamixel.feedback.FeedbackUpdateValues;
import org.robokind.impl.motion.dynamixel.feedback.GoalUpdateValues;
import org.robokind.impl.motion.dynamixel.feedback.MoveParams;

public class DynamixelServoCache
implements MoveParams {
    private DynamixelServo.Id myId;
    private FeedbackUpdateValues myFeedbackVals;
    private GoalUpdateValues myGoalValues;
    private GoalUpdateValues myPrevGoalValues;
    private long myCommandDelayMiiilsec;

    public DynamixelServoCache(DynamixelServo.Id id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.myId = id;
        this.myPrevGoalValues = new GoalUpdateValues(id, 0, 0L);
        this.myGoalValues = new GoalUpdateValues(id, 0, 0L);
        this.myFeedbackVals = new FeedbackUpdateValues(id, new int[5], 0L);
        this.myCommandDelayMiiilsec = 2L;
    }

    public void setFeedbackVals(FeedbackUpdateValues vals) {
        this.myFeedbackVals = vals;
    }

    public void setGoalVals(GoalUpdateValues vals) {
        this.myGoalValues = vals;
    }

    @Override
    public void goalsSent() {
        this.myPrevGoalValues = this.myGoalValues;
    }

    @Override
    public int getServoIdNumber() {
        return this.myId.getIntValue();
    }

    @Override
    public int getCurrentPosition() {
        return this.myFeedbackVals.getCurrentPosition();
    }

    @Override
    public int getCurrentSpeed() {
        return this.myFeedbackVals.getCurrentSpeed();
    }

    @Override
    public long getCommandDelayMillisec() {
        return this.myCommandDelayMiiilsec;
    }

    @Override
    public long getCurPosTimestampUTC() {
        return this.myFeedbackVals.getUpdateTimestamp();
    }

    @Override
    public long getPrevGoalTargetTimeUTC() {
        return this.myPrevGoalValues.getGoalTargetTimeUTC();
    }

    @Override
    public int getPrevGoalPosition() {
        return this.myPrevGoalValues.getGoalPosition();
    }

    @Override
    public long getGoalTargetTimeUTC() {
        return this.myGoalValues.getGoalTargetTimeUTC();
    }

    @Override
    public int getGoalPosition() {
        return this.myGoalValues.getGoalPosition();
    }

    public FeedbackUpdateValues getFeedback() {
        return this.myFeedbackVals;
    }

    public void setCommandDelayMillisec(long msec) {
        this.myCommandDelayMiiilsec = msec;
    }
}

