/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.dynamixel.feedback.utils;

import java.util.ArrayList;
import java.util.List;
import org.robokind.impl.motion.dynamixel.DynamixelServo;
import org.robokind.impl.motion.dynamixel.feedback.ConcurrentDynamixelCache;
import org.robokind.impl.motion.dynamixel.feedback.DynamixelServoCache;
import org.robokind.impl.motion.dynamixel.feedback.FeedbackUpdateValues;

public class FeedbackUtils {
    public static List<DynamixelServo.Id> getHotServos(ConcurrentDynamixelCache cache, int maxTemp) {
        ArrayList<DynamixelServo.Id> ids = null;
        for (DynamixelServoCache c : cache.getValueMap().values()) {
            int temp = c.getFeedback().getCurrentTemperature();
            c.getFeedback().getCurrentVoltage();
            if (temp < maxTemp) continue;
            if (ids == null) {
                ids = new ArrayList<DynamixelServo.Id>();
            }
            ids.add(new DynamixelServo.Id(c.getServoIdNumber()));
        }
        return ids;
    }

    public static List<DynamixelServo.Id> getOverLimit(ConcurrentDynamixelCache cache, int index, int valLimit, int dir) {
        ArrayList<DynamixelServo.Id> ids = null;
        for (DynamixelServoCache c : cache.getValueMap().values()) {
            if (!FeedbackUtils.checkValue(c.getFeedback(), index, valLimit, dir)) continue;
            if (ids == null) {
                ids = new ArrayList<DynamixelServo.Id>();
            }
            ids.add(new DynamixelServo.Id(c.getServoIdNumber()));
        }
        return ids;
    }

    public static boolean isOverLimit(ConcurrentDynamixelCache cache, int index, int valLimit, int dir) {
        for (DynamixelServoCache c : cache.getValueMap().values()) {
            if (!FeedbackUtils.checkValue(c.getFeedback(), index, valLimit, dir)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkValue(FeedbackUpdateValues feedback, int index, int valLimit, int dir) {
        if (feedback == null) {
            return false;
        }
        int[] vals = feedback.getValues();
        if (vals == null || vals.length <= index) {
            return false;
        }
        if (dir > 0) {
            return vals[index] >= valLimit;
        }
        if (dir == 0) {
            return vals[index] == valLimit;
        }
        return vals[index] <= valLimit;
    }
}

