/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import org.robolectric.annotation.Implements;

public class Helpers {
    public static TypePredicate isCastableTo(Supplier<Type> type) {
        return new CastableTo(type);
    }

    public static TypePredicate isCastableTo(String type) {
        return new CastableTo((Supplier<Type>)Suppliers.typeFromString((String)type));
    }

    public static boolean isInShadowClass(TreePath path, VisitorState state) {
        Tree leaf = path.getLeaf();
        JCTree.JCClassDecl classDecl = JCTree.JCClassDecl.class.isInstance(leaf) ? (JCTree.JCClassDecl)leaf : (JCTree.JCClassDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCClassDecl.class);
        return ASTHelpers.hasAnnotation((Tree)classDecl, Implements.class, (VisitorState)state);
    }

    public static class CastableTo
    implements TypePredicate {
        public final Supplier<Type> expected;

        public CastableTo(Supplier<Type> type) {
            this.expected = type;
        }

        public boolean apply(Type type, VisitorState state) {
            Type bound = (Type)this.expected.get(state);
            if (bound == null || type == null) {
                return false;
            }
            return ASTHelpers.isCastable((Type)type, (Type)bound, (VisitorState)state);
        }
    }
}

