/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@BugPattern(name="RobolectricShadow", summary="Robolectric @Implementation methods should be protected.", severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false, tags={"Refactoring"})
public final class RobolectricShadow
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> implementsClassMatcher = Matchers.hasAnnotation(Implements.class);
    private static final Matcher<MethodTree> implementationMethodMatcher = Matchers.hasAnnotation(Implementation.class);
    private boolean doScanJavadoc = false;

    public Description matchClass(ClassTree classTree, VisitorState state) {
        ArrayList<Optional<SuggestedFix>> fixes = new ArrayList<Optional<SuggestedFix>>();
        if (implementsClassMatcher.matches((Tree)classTree, state)) {
            boolean inSdk = true;
            JavacTrees trees = JavacTrees.instance(state.context);
            for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
                JCTree.JCIdent ident = (JCTree.JCIdent)annotationTree.getAnnotationType();
                String annotationClassName = ident.sym.getQualifiedName().toString();
                if (!"org.robolectric.annotation.Implements".equals(annotationClassName)) continue;
                for (ExpressionTree expressionTree : annotationTree.getArguments()) {
                    JCTree.JCAssign jcAnnotation = (JCTree.JCAssign)expressionTree;
                    if (!"isInAndroidSdk".equals(state.getSourceForNode((Tree)jcAnnotation.lhs)) || !"false".equals(state.getSourceForNode((Tree)jcAnnotation.rhs))) continue;
                    inSdk = false;
                }
            }
            if (inSdk) {
                new ImplementationMethodScanner(state, fixes, trees).scan(state.getPath(), null);
            }
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        for (Optional optional : fixes) {
            optional.ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0));
        }
        if (builder.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(classTree, (Fix)builder.build());
    }

    private class ImplementationMethodScanner
    extends TreePathScanner<Void, Void> {
        private final VisitorState state;
        private final List<Optional<SuggestedFix>> fixes;
        private final JavacTrees trees;

        ImplementationMethodScanner(VisitorState state, List<Optional<SuggestedFix>> fixes, JavacTrees trees) {
            this.state = state;
            this.fixes = fixes;
            this.trees = trees;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void aVoid) {
            if (implementationMethodMatcher.matches((Tree)methodTree, this.state)) {
                this.processImplementationMethod(methodTree);
            }
            return (Void)super.visitMethod(methodTree, aVoid);
        }

        private void processImplementationMethod(MethodTree methodTree) {
            String methodName = methodTree.getName().toString();
            if ("toString".equals(methodName) || "equals".equals(methodName) || "hashCode".equals(methodName)) {
                return;
            }
            ModifiersTree modifiersTree = methodTree.getModifiers();
            for (AnnotationTree annotationTree : modifiersTree.getAnnotations()) {
                JCTree.JCIdent ident = (JCTree.JCIdent)annotationTree.getAnnotationType();
                String annotationClassName = ident.sym.getQualifiedName().toString();
                if ("java.lang.Override".equals(annotationClassName)) {
                    return;
                }
                if (!"org.robolectric.annotation.HiddenApi".equals(annotationClassName)) continue;
                return;
            }
            Set<Modifier> modifiers = modifiersTree.getFlags();
            if (!modifiers.contains((Object)Modifier.PROTECTED)) {
                this.fixes.add(SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)this.state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.PRIVATE}));
                this.fixes.add(SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)this.state, (Modifier[])new Modifier[]{Modifier.PROTECTED}));
            }
            if (RobolectricShadow.this.doScanJavadoc) {
                this.scanJavadoc();
            }
        }

        private void scanJavadoc() {
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree != null) {
                DocTreePath docTrees = new DocTreePath(this.getCurrentPath(), commentTree);
                new DocTreeSymbolScanner(this.trees, this.fixes).scan(docTrees, null);
            }
        }
    }

    static final class DocTreeSymbolScanner
    extends DocTreePathScanner<Void, Void> {
        private final JavacTrees trees;
        private final List<Optional<SuggestedFix>> fixes;

        DocTreeSymbolScanner(JavacTrees trees, List<Optional<SuggestedFix>> fixes) {
            this.trees = trees;
            this.fixes = fixes;
        }

        @Override
        public Void visitStartElement(StartElementTree startElementTree, Void aVoid) {
            if (startElementTree.getName().toString().equalsIgnoreCase("p")) {
                DCTree.DCStartElement node = (DCTree.DCStartElement)startElementTree;
                DocTreePath path = this.getCurrentPath();
                int start = (int)node.getSourcePosition((DCTree.DCDocComment)path.getDocComment()) + node.pos;
                int end = node.getEndPos((DCTree.DCDocComment)this.getCurrentPath().getDocComment());
                this.fixes.add(Optional.of(SuggestedFix.replace((int)start, (int)end, (String)"")));
            }
            return (Void)super.visitStartElement(startElementTree, aVoid);
        }

        @Override
        public Void visitEndElement(EndElementTree endElementTree, Void aVoid) {
            return (Void)super.visitEndElement(endElementTree, aVoid);
        }

        @Override
        public Void visitText(TextTree textTree, Void aVoid) {
            String string = String.valueOf(textTree);
            System.out.println(new StringBuilder(11 + String.valueOf(string).length()).append("textTree = ").append(string).toString());
            return (Void)super.visitText(textTree, aVoid);
        }

        @Override
        public Void visitReference(ReferenceTree referenceTree, Void sink) {
            this.trees.getElement(this.getCurrentPath());
            TreeScanner<Void, Void> nonRecursiveScanner = new TreeScanner<Void, Void>(this){

                @Override
                public Void visitIdentifier(IdentifierTree tree, Void sink) {
                    Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                    if (sym != null) {
                        String string = String.valueOf(sym);
                        System.out.println(new StringBuilder(6 + String.valueOf(string).length()).append("sym = ").append(string).toString());
                    }
                    return null;
                }
            };
            DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
            nonRecursiveScanner.scan(reference.qualifierExpression, sink);
            nonRecursiveScanner.scan(reference.paramTypes, sink);
            return null;
        }
    }
}

