/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.annotation.Implements;
import org.robolectric.errorprone.bugpatterns.Helpers;

@BugPattern(name="DeprecatedMethods", summary="Prefer supported APIs.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false, tags={"Refactoring"}, link="http://robolectric.org/migrating/#deprecations", linkType=BugPattern.LinkType.CUSTOM)
@AutoService(value={BugChecker.class})
public class DeprecatedMethodsCheck
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private final List<MethodInvocationMatcher> matchers = Arrays.asList(new MethodInvocationMatcher(){

        @Override
        MethodMatchers.MethodNameMatcher matcher() {
            return Matchers.staticMethod().onClass(DeprecatedMethodsCheck.this.shadowName("org.robolectric.shadows.ShadowApplication")).named("getInstance");
        }

        @Override
        void replace(MethodInvocationTree tree, VisitorState state, SuggestedFix.Builder fixBuilder, HashMap<Tree, Runnable> possibleFixes) {
            MethodCall surroundingMethodCall = DeprecatedMethodsCheck.getSurroundingMethodCall(tree, state);
            if (surroundingMethodCall != null && surroundingMethodCall.getName().equals("getApplicationContext")) {
                fixBuilder.replace((Tree)surroundingMethodCall.node, "RuntimeEnvironment.application").addImport("org.robolectric.RuntimeEnvironment");
            } else {
                Tree parent = state.getPath().getParentPath().getLeaf();
                possibleFixes.put(parent, () -> fixBuilder.addImport("org.robolectric.RuntimeEnvironment").replace((Tree)tree, DeprecatedMethodsCheck.this.wrapInShadows(state, fixBuilder, "RuntimeEnvironment.application")));
            }
        }
    }, new AppGetLastMatcher("org.robolectric.shadows.ShadowAlertDialog", "ShadowAlertDialog", "getLatestAlertDialog"), new AppGetLastMatcher("org.robolectric.shadows.ShadowDialog", "ShadowDialog", "getLatestDialog"), new AppGetLastMatcher("org.robolectric.shadows.ShadowPopupMenu", "ShadowPopupMenu", "getLatestPopupMenu"));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (Helpers.isInShadowClass(state.getPath(), state)) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        final HashMap possibleFixes = new HashMap();
        new TreeScanner<Void, VisitorState>(){
            private boolean inShadowClass;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitClass(ClassTree classTree, VisitorState visitorState) {
                boolean priorInShadowClass = this.inShadowClass;
                this.inShadowClass = ASTHelpers.hasAnnotation((Tree)classTree, Implements.class, (VisitorState)visitorState);
                try {
                    Void void_ = (Void)super.visitClass(classTree, visitorState);
                    return void_;
                }
                finally {
                    this.inShadowClass = priorInShadowClass;
                }
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, VisitorState state) {
                VisitorState nowState = state.withPath(TreePath.getPath(state.getPath(), (Tree)tree));
                if (!this.inShadowClass) {
                    for (MethodInvocationMatcher matcher : DeprecatedMethodsCheck.this.matchers) {
                        if (!matcher.matcher().matches((Tree)tree, state)) continue;
                        matcher.replace(tree, nowState, fixBuilder, possibleFixes);
                        return null;
                    }
                }
                return (Void)super.visitMethodInvocation(tree, nowState);
            }
        }.scan(tree, state);
        for (Runnable runnable : possibleFixes.values()) {
            runnable.run();
        }
        SuggestedFix fix = fixBuilder.build();
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix);
    }

    private String wrapInShadows(VisitorState state, SuggestedFix.Builder fixBuilder, String content) {
        String shadowyContent;
        Set<String> imports = DeprecatedMethodsCheck.getImports(state);
        if (imports.contains(this.shadowName("org.robolectric.Shadows"))) {
            shadowyContent = this.shortShadowName("Shadows") + ".shadowOf(" + content + ")";
        } else {
            fixBuilder.addStaticImport(this.shadowName("org.robolectric.Shadows.shadowOf"));
            shadowyContent = "shadowOf(" + content + ")";
        }
        return shadowyContent;
    }

    private static Set<String> getImports(VisitorState state) {
        HashSet<String> imports = new HashSet<String>();
        for (ImportTree importTree : state.getPath().getCompilationUnit().getImports()) {
            imports.add(state.getSourceForNode(importTree.getQualifiedIdentifier()));
        }
        return imports;
    }

    private static MethodCall getSurroundingMethodCall(Tree node, VisitorState state) {
        Tree grandparentNode;
        TreePath nodePath = TreePath.getPath(state.getPath(), node);
        TreePath parentPath = nodePath.getParentPath();
        if (parentPath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && (grandparentNode = parentPath.getParentPath().getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION) {
            return new MethodCall((JCTree.JCMethodInvocation)grandparentNode);
        }
        return null;
    }

    String shadowName(String className) {
        return className;
    }

    String shortShadowName(String shadowClassName) {
        return shadowClassName;
    }

    private class AppGetLastMatcher
    extends MethodInvocationMatcher {
        private final String methodName;
        private final String shadowClassName;
        private final String shadowShortClassName;

        AppGetLastMatcher(String shadowClassName, String shadowShortClassName, String methodName) {
            this.methodName = methodName;
            this.shadowClassName = shadowClassName;
            this.shadowShortClassName = shadowShortClassName;
        }

        @Override
        MethodMatchers.MethodNameMatcher matcher() {
            return Matchers.instanceMethod().onClass(Helpers.isCastableTo(DeprecatedMethodsCheck.this.shadowName("org.robolectric.shadows.ShadowApplication"))).named(this.methodName);
        }

        @Override
        void replace(MethodInvocationTree tree, VisitorState state, SuggestedFix.Builder fixBuilder, HashMap<Tree, Runnable> possibleFixes) {
            possibleFixes.put(tree, () -> fixBuilder.addImport(DeprecatedMethodsCheck.this.shadowName(this.shadowClassName)).replace((Tree)tree, DeprecatedMethodsCheck.this.wrapInShadows(state, fixBuilder, DeprecatedMethodsCheck.this.shortShadowName(this.shadowShortClassName) + "." + this.methodName + "()")));
        }
    }

    static class MethodCall {
        private final JCTree.JCMethodInvocation node;

        public MethodCall(JCTree.JCMethodInvocation node) {
            this.node = node;
        }

        public String getName() {
            return ((JCTree.JCFieldAccess)this.node.getMethodSelect()).name.toString();
        }
    }

    static abstract class MethodInvocationMatcher {
        MethodInvocationMatcher() {
        }

        abstract MethodMatchers.MethodNameMatcher matcher();

        abstract void replace(MethodInvocationTree var1, VisitorState var2, SuggestedFix.Builder var3, HashMap<Tree, Runnable> var4);
    }
}

