/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.robotframework.mavenplugin.AbstractMojoWithLoadedClasspath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyMojo
extends AbstractMojoWithLoadedClasspath {
    private File testCasesDirectory;
    private File xunitFile;
    private File outputDirectory;
    private boolean isTestFailureIgnore;
    private boolean skipTests;
    private boolean skipATs;
    private boolean skipITs;
    private boolean skip;

    private boolean shouldSkipTests() {
        return this.skipTests || this.skipITs || this.skipATs || this.skip;
    }

    protected void subclassExecute() throws MojoExecutionException, MojoFailureException {
        int failures;
        int errors;
        if (this.shouldSkipTests()) {
            this.getLog().info((CharSequence)"RobotFramework tests are skipped.");
            return;
        }
        if (this.xunitFile == null) {
            String testCasesFolderName = this.testCasesDirectory.getName();
            this.xunitFile = new File("TEST-" + testCasesFolderName.replace(' ', '_') + ".xml");
        }
        this.getLog().debug((CharSequence)("Output directory is " + this.outputDirectory));
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xunitResult = documentBuilder.parse(this.makeAbsolute(this.outputDirectory, this.xunitFile));
            errors = this.readIntAttribute(xunitResult, "/testsuite/@errors");
            failures = this.readIntAttribute(xunitResult, "/testsuite/@failures");
            int tests = this.readIntAttribute(xunitResult, "/testsuite/@tests");
            System.out.println("\nTest Results :");
            if (failures > 0 || errors > 0) {
                System.out.println("\nFailing acceptance tests:\n");
                NodeList testCases = this.getFailuresAndErrors(xunitResult);
                for (int i = 0; i < testCases.getLength(); ++i) {
                    Node testCase = testCases.item(i);
                    NamedNodeMap attributes = testCase.getAttributes();
                    System.out.println("    " + attributes.getNamedItem("name").getNodeValue() + "(" + attributes.getNamedItem("classname").getNodeValue() + ")");
                }
            }
            System.out.println("\nTests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + "\n");
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to verify robotframework acceptance-test results", e);
        }
        if (errors > 0 || failures > 0) {
            String msg = "There are acceptance test failures.\n\nPlease refer to " + this.outputDirectory.getAbsolutePath() + " for the individual test results.";
            if (this.isTestFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    private NodeList getFailuresAndErrors(Document xunitResult) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String xPathExpression = "/testsuite/testcase[failure or error]";
        NodeList testCases = (NodeList)xPath.evaluate(xPathExpression, xunitResult, XPathConstants.NODESET);
        return testCases;
    }

    private int readIntAttribute(Document xunitResult, String xPathExpression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return ((Number)xPath.evaluate(xPathExpression, xunitResult, XPathConstants.NUMBER)).intValue();
    }
}

