/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.List;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.Argument;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Inttoptr;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.trampoline.Invokestatic;
import org.robovm.compiler.trampoline.LdcClass;
import soot.LongType;
import soot.SootMethod;
import soot.tagkit.AnnotationTag;

public class BridgeMethodCompiler
extends BroMethodCompiler {
    public BridgeMethodCompiler(Config config) {
        super(config);
    }

    private void validateBridgeMethod(SootMethod method) {
        if (!method.isNative()) {
            throw new IllegalArgumentException("@Bridge annotated method " + method + " must be native");
        }
        AnnotationTag bridgeAnnotation = Annotations.getAnnotation(method, "Lorg/robovm/rt/bro/annotation/Bridge;");
        if (!(!Annotations.readBooleanElem(bridgeAnnotation, "dynamic", false) || method.isStatic() && method.getParameterCount() != 0 && method.getParameterType(0) == LongType.v() && Annotations.hasParameterAnnotation(method, 0, "Lorg/robovm/rt/bro/annotation/Pointer;"))) {
            throw new IllegalArgumentException("Dynamic @Bridge annotated method " + method + " must be static and take a @Pointer long as first parameter");
        }
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        MarshalerLookup.MarshalerMethod marshalerMethod;
        this.validateBridgeMethod(method);
        AnnotationTag bridgeAnnotation = Annotations.getAnnotation(method, "Lorg/robovm/rt/bro/annotation/Bridge;");
        boolean dynamic = Annotations.readBooleanElem(bridgeAnnotation, "dynamic", false);
        boolean optional = Annotations.readBooleanElem(bridgeAnnotation, "optional", false);
        Function fn = FunctionBuilder.method(method);
        moduleBuilder.addFunction(fn);
        Type[] parameterTypes = fn.getType().getParameterTypes();
        String[] parameterNames = fn.getParameterNames();
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            args.add(new Argument(new VariableRef(parameterNames[i], parameterTypes[i]), new ParameterAttribute[0]));
        }
        SootMethod originalMethod = method;
        Value structObj = null;
        boolean passByValue = Bro.isPassByValue(originalMethod);
        DataLayout dataLayout = this.config.getDataLayout();
        if (passByValue) {
            int size;
            Arch arch = this.config.getArch();
            OS os = this.config.getOs();
            if (!os.isReturnedInRegisters(arch, size = dataLayout.getAllocSize(this.getStructType(originalMethod.getReturnType())))) {
                method = this.createFakeStructRetMethod(method);
                VariableRef env = fn.getParameterRef(0);
                LdcClass ldcClass = new LdcClass(Types.getInternalName(method.getDeclaringClass()), Types.getInternalName(originalMethod.getReturnType()));
                this.trampolines.add(ldcClass);
                Value cls = Functions.call(fn, (Value)ldcClass.getFunctionRef(), env);
                Invokestatic invokestatic = new Invokestatic(Types.getInternalName(method.getDeclaringClass()), "org/robovm/rt/bro/Struct", "allocate", "(Ljava/lang/Class;)Lorg/robovm/rt/bro/Struct;");
                this.trampolines.add(invokestatic);
                structObj = Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, cls);
                args.add(1, new Argument(structObj, new ParameterAttribute[0]));
            }
        }
        FunctionType targetFnType = this.getBridgeFunctionType(method, dynamic);
        if (method == originalMethod && passByValue) {
            int size = dataLayout.getAllocSize(targetFnType.getReturnType());
            IntegerType t = size <= 1 ? Type.I8 : (size <= 2 ? Type.I16 : (size <= 4 ? Type.I32 : Type.I64));
            targetFnType = new FunctionType((Type)t, targetFnType.isVarargs(), targetFnType.getParameterTypes());
        }
        VariableRef env = fn.getParameterRef(0);
        Variable targetFn = fn.newVariable(targetFnType);
        if (!dynamic) {
            Global targetFnPtr = new Global(Symbols.bridgePtrSymbol(originalMethod), Linkage._private, new NullConstant(Type.I8_PTR));
            moduleBuilder.addGlobal(targetFnPtr);
            fn.add(new Load(targetFn, new ConstantBitcast(targetFnPtr.ref(), new PointerType(targetFnType))));
            Label nullLabel = new Label();
            Label notNullLabel = new Label();
            Variable nullCheck = fn.newVariable(Type.I1);
            fn.add(new Icmp(nullCheck, Icmp.Condition.eq, targetFn.ref(), new NullConstant(targetFnType)));
            fn.add(new Br(nullCheck.ref(), fn.newBasicBlockRef(nullLabel), fn.newBasicBlockRef(notNullLabel)));
            fn.newBasicBlock(nullLabel);
            Functions.call(fn, (Value)Functions.BC_THROW_UNSATISIFED_LINK_ERROR, env, moduleBuilder.getString(String.format((optional ? "Optional " : "") + "@Bridge method %s.%s%s not bound", this.className, originalMethod.getName(), Types.getDescriptor(originalMethod))));
            fn.add(new Unreachable());
            fn.newBasicBlock(notNullLabel);
        } else {
            fn.add(new Inttoptr(targetFn, fn.getParameterRef(1), targetFn.getType()));
            args.remove(originalMethod == method ? 1 : 2);
        }
        args.remove(0);
        ArrayList<BroMethodCompiler.MarshaledArg> marshaledArgs = new ArrayList<BroMethodCompiler.MarshaledArg>();
        Type[] targetParameterTypes = targetFnType.getParameterTypes();
        int receiverIdx = -1;
        if (!method.isStatic()) {
            MarshalerLookup.MarshalerMethod marshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, -2));
            BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
            marshaledArg.paramIndex = -2;
            marshaledArgs.add(marshaledArg);
            receiverIdx = method == originalMethod ? 0 : 1;
            Type nativeType = targetParameterTypes[receiverIdx];
            Value nativeValue = this.marshalObjectToNative(fn, marshalerMethod2, marshaledArg, nativeType, env, ((Argument)args.get(receiverIdx)).getValue(), 0L);
            args.set(receiverIdx, new Argument(nativeValue, new ParameterAttribute[0]));
        }
        int argIdx = 0;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            soot.Type type;
            if (dynamic && (method == originalMethod && i == 0 || method != originalMethod && i == 1)) continue;
            if (argIdx == receiverIdx) {
                ++argIdx;
            }
            if (Bro.needsMarshaler(type = method.getParameterType(i))) {
                marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, i));
                Type nativeType = targetParameterTypes[argIdx];
                if (nativeType instanceof PrimitiveType) {
                    Value nativeValue = this.marshalValueObjectToNative(fn, marshalerMethod, nativeType, env, args.get(argIdx).getValue(), 0L);
                    args.set(argIdx, new Argument(nativeValue, new ParameterAttribute[0]));
                } else {
                    ParameterAttribute[] parameterAttributes = new ParameterAttribute[]{};
                    if (Bro.isPassByValue(method, i) || Bro.isStructRet(method, i)) {
                        Functions.call(fn, (Value)Functions.CHECK_NULL, env, args.get(argIdx).getValue());
                        parameterAttributes = new ParameterAttribute[]{Bro.isStructRet(method, i) ? ParameterAttribute.sret : ParameterAttribute.byval};
                    }
                    BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
                    marshaledArg.paramIndex = i;
                    marshaledArgs.add(marshaledArg);
                    Value nativeValue = this.marshalObjectToNative(fn, marshalerMethod, marshaledArg, nativeType, env, args.get(argIdx).getValue(), 0L);
                    args.set(argIdx, new Argument(nativeValue, parameterAttributes));
                }
            } else {
                args.set(argIdx, new Argument(this.marshalPrimitiveToNative(fn, method, i, ((Argument)args.get(argIdx)).getValue()), new ParameterAttribute[0]));
            }
            ++argIdx;
        }
        BasicBlockRef bbSuccess = fn.newBasicBlockRef(new Label("success"));
        BasicBlockRef bbFailure = fn.newBasicBlockRef(new Label("failure"));
        Functions.pushNativeFrame(fn);
        Functions.trycatchAllEnter(fn, env, bbSuccess, bbFailure);
        fn.newBasicBlock(bbSuccess.getLabel());
        Value result = Functions.callWithArguments(fn, (Value)targetFn.ref(), args);
        Functions.trycatchLeave(fn, env);
        Functions.popNativeFrame(fn);
        this.updateObject(method, fn, env, 0L, marshaledArgs);
        if (Bro.needsMarshaler(method.getReturnType())) {
            marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
            String targetClassName = Types.getInternalName(method.getReturnType());
            if (passByValue) {
                Value stackCopy = this.createStackCopy(fn, result);
                Variable src = fn.newVariable(Type.I8_PTR);
                fn.add(new Bitcast(src, stackCopy, Type.I8_PTR));
                Value heapCopy = Functions.call(fn, (Value)Functions.BC_COPY_STRUCT, env, src.ref(), new IntegerConstant(dataLayout.getAllocSize(result.getType())));
                result = this.marshalNativeToObject(fn, marshalerMethod, null, env, targetClassName, heapCopy, 0L);
            } else {
                result = targetFnType.getReturnType() instanceof PrimitiveType ? this.marshalNativeToValueObject(fn, marshalerMethod, env, targetClassName, result, 0L) : this.marshalNativeToObject(fn, marshalerMethod, null, env, targetClassName, result, 0L);
            }
        } else {
            result = this.marshalNativeToPrimitive(fn, method, result);
        }
        if (method != originalMethod) {
            fn.add(new Ret(structObj));
        } else {
            fn.add(new Ret(result));
        }
        fn.newBasicBlock(bbFailure.getLabel());
        Functions.trycatchLeave(fn, env);
        Functions.popNativeFrame(fn);
        Value ex = Functions.call(fn, (Value)Functions.BC_EXCEPTION_CLEAR, env);
        this.updateObject(method, fn, env, 0L, marshaledArgs);
        Functions.call(fn, (Value)Functions.BC_THROW, env, ex);
        fn.add(new Unreachable());
        return fn;
    }

    private void updateObject(SootMethod method, Function fn, Value env, long flags, List<BroMethodCompiler.MarshaledArg> marshaledArgs) {
        for (BroMethodCompiler.MarshaledArg value : marshaledArgs) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, value.paramIndex));
            SootMethod afterMethod = ((MarshalerLookup.PointerMarshalerMethod)marshalerMethod).getAfterBridgeCallMethod();
            if (afterMethod == null) continue;
            Invokestatic invokestatic = new Invokestatic(Types.getInternalName(method.getDeclaringClass()), Types.getInternalName(afterMethod.getDeclaringClass()), afterMethod.getName(), Types.getDescriptor(afterMethod));
            this.trampolines.add(invokestatic);
            Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, value.object, value.handle, new IntegerConstant(flags));
        }
    }
}

