/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.List;
import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.BooleanConstant;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.trampoline.Invokestatic;
import soot.SootMethod;

public class CallbackMethodCompiler
extends BroMethodCompiler {
    public CallbackMethodCompiler(Config config) {
        super(config);
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        return this.compileCallback(moduleBuilder, method);
    }

    private Function callback(SootMethod method) {
        return FunctionBuilder.callback(method, this.getCallbackFunctionType(method));
    }

    private Function callback(SootMethod method, Type returnType) {
        FunctionType ft = this.getCallbackFunctionType(method);
        return FunctionBuilder.callback(method, new FunctionType(returnType, ft.isVarargs(), ft.getParameterTypes()));
    }

    private Function compileCallback(ModuleBuilder moduleBuilder, SootMethod method) {
        Type nativeType;
        int start;
        DataLayout dataLayout = this.config.getDataLayout();
        SootMethod originalMethod = method;
        boolean passByValue = Bro.isPassByValue(originalMethod);
        if (passByValue) {
            int size;
            Arch arch = this.config.getArch();
            OS os = this.config.getOs();
            if (!os.isReturnedInRegisters(arch, size = dataLayout.getAllocSize(this.getStructType(originalMethod.getReturnType())))) {
                method = this.createFakeStructRetMethod(method);
            }
        }
        Function callbackFn = this.callback(method);
        if (originalMethod != method) {
            callbackFn.setParameterAttributes(0, ParameterAttribute.sret);
        } else if (passByValue) {
            int size = dataLayout.getAllocSize(callbackFn.getType().getReturnType());
            IntegerType t = size <= 1 ? Type.I8 : (size <= 2 ? Type.I16 : (size <= 4 ? Type.I32 : Type.I64));
            callbackFn = this.callback(method, t);
        }
        moduleBuilder.addFunction(callbackFn);
        moduleBuilder.addAlias(new Alias(Symbols.callbackPtrSymbol(originalMethod), Linkage._private, new ConstantBitcast(callbackFn.ref(), Type.I8_PTR_PTR)));
        String targetName = originalMethod.isSynchronized() ? Symbols.synchronizedWrapperSymbol(originalMethod) : Symbols.methodSymbol(originalMethod);
        FunctionRef targetFn = new FunctionRef(targetName, Types.getFunctionType(originalMethod));
        Value env = Functions.call(callbackFn, (Value)Functions.BC_ATTACH_THREAD_FROM_CALLBACK, new Value[0]);
        BasicBlockRef bbSuccess = callbackFn.newBasicBlockRef(new Label("success"));
        BasicBlockRef bbFailure = callbackFn.newBasicBlockRef(new Label("failure"));
        Functions.pushCallbackFrame(callbackFn, env);
        Functions.trycatchAllEnter(callbackFn, env, bbSuccess, bbFailure);
        callbackFn.newBasicBlock(bbSuccess.getLabel());
        ArrayList<BroMethodCompiler.MarshaledArg> marshaledArgs = new ArrayList<BroMethodCompiler.MarshaledArg>();
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(env);
        int receiverIdx = -1;
        if (!method.isStatic()) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, -2));
            BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
            marshaledArg.paramIndex = -2;
            marshaledArgs.add(marshaledArg);
            receiverIdx = method == originalMethod ? 0 : 1;
            Value arg = callbackFn.getParameterRef(receiverIdx);
            String targetClassName = Types.getInternalName(originalMethod.getDeclaringClass());
            arg = this.marshalNativeToObject(callbackFn, marshalerMethod, marshaledArg, env, targetClassName, arg, 0L);
            args.add(arg);
        }
        int i = start = originalMethod == method ? 0 : 1;
        int argIdx = start;
        while (i < method.getParameterCount()) {
            if (argIdx == receiverIdx) {
                ++argIdx;
            }
            if (Bro.isPassByValue(method, i)) {
                callbackFn.setParameterAttributes(argIdx, ParameterAttribute.byval);
            }
            Value arg = callbackFn.getParameterRef(argIdx);
            soot.Type type = method.getParameterType(i);
            if (Bro.needsMarshaler(type)) {
                MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, i));
                String targetClassName = Types.getInternalName(type);
                if (arg.getType() instanceof PrimitiveType) {
                    arg = this.marshalNativeToValueObject(callbackFn, marshalerMethod, env, targetClassName, arg, 1L);
                } else {
                    BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
                    marshaledArg.paramIndex = i;
                    marshaledArgs.add(marshaledArg);
                    arg = this.marshalNativeToObject(callbackFn, marshalerMethod, marshaledArg, env, targetClassName, arg, 1L);
                }
            } else {
                arg = this.marshalNativeToPrimitive(callbackFn, method, i, arg);
            }
            args.add(arg);
            ++i;
            ++argIdx;
        }
        Value result = Functions.call(callbackFn, (Value)targetFn, args);
        this.updateNative(method, callbackFn, env, 1L, marshaledArgs);
        if (Bro.needsMarshaler(method.getReturnType())) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
            nativeType = callbackFn.getType().getReturnType();
            result = passByValue ? this.marshalObjectToNative(callbackFn, marshalerMethod, null, nativeType, env, result, 1L, true) : (nativeType instanceof PrimitiveType ? this.marshalValueObjectToNative(callbackFn, marshalerMethod, nativeType, env, result, 1L) : this.marshalObjectToNative(callbackFn, marshalerMethod, null, nativeType, env, result, 1L));
        } else if (originalMethod != method) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(originalMethod));
            nativeType = (PointerType)callbackFn.getType().getParameterTypes()[0];
            Value addr = this.marshalObjectToNative(callbackFn, marshalerMethod, null, nativeType, env, result, 1L);
            Variable src = callbackFn.newVariable(Type.I8_PTR);
            Variable dest = callbackFn.newVariable(Type.I8_PTR);
            callbackFn.add(new Bitcast(src, addr, Type.I8_PTR));
            callbackFn.add(new Bitcast(dest, callbackFn.getParameterRef(0), Type.I8_PTR));
            Functions.call(callbackFn, (Value)Functions.LLVM_MEMCPY, dest.ref(), src.ref(), Types.sizeof((StructureType)((PointerType)nativeType).getBase()), new IntegerConstant(0), BooleanConstant.FALSE);
            result = null;
        } else {
            result = this.marshalPrimitiveToNative(callbackFn, method, result);
        }
        Functions.trycatchLeave(callbackFn, env);
        Functions.popCallbackFrame(callbackFn, env);
        Functions.call(callbackFn, (Value)Functions.BC_DETACH_THREAD_FROM_CALLBACK, env);
        callbackFn.add(new Ret(result));
        callbackFn.newBasicBlock(bbFailure.getLabel());
        Functions.trycatchLeave(callbackFn, env);
        Functions.popCallbackFrame(callbackFn, env);
        Value ex = Functions.call(callbackFn, (Value)Functions.BC_EXCEPTION_CLEAR, env);
        this.updateNative(method, callbackFn, env, 1L, marshaledArgs);
        Functions.call(callbackFn, (Value)Functions.BC_DETACH_THREAD_FROM_CALLBACK, env);
        Functions.call(callbackFn, (Value)Functions.BC_THROW, env, ex);
        callbackFn.add(new Unreachable());
        return callbackFn;
    }

    private void updateNative(SootMethod method, Function fn, Value env, long flags, List<BroMethodCompiler.MarshaledArg> marshaledArgs) {
        for (BroMethodCompiler.MarshaledArg value : marshaledArgs) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, value.paramIndex));
            SootMethod afterMethod = ((MarshalerLookup.PointerMarshalerMethod)marshalerMethod).getAfterCallbackCallMethod();
            if (afterMethod == null) continue;
            Invokestatic invokestatic = new Invokestatic(Types.getInternalName(method.getDeclaringClass()), Types.getInternalName(afterMethod.getDeclaringClass()), afterMethod.getName(), Types.getDescriptor(afterMethod));
            this.trampolines.add(invokestatic);
            Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, value.handle, value.object, new IntegerConstant(flags));
        }
    }
}

