/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.AttributesEncoder;
import org.robovm.compiler.BridgeMethodCompiler;
import org.robovm.compiler.CallbackMethodCompiler;
import org.robovm.compiler.ClassCompilerListener;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.GlobalValueMethodCompiler;
import org.robovm.compiler.ITable;
import org.robovm.compiler.MethodCompiler;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.NativeMethodCompiler;
import org.robovm.compiler.StructMemberMethodCompiler;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.TrampolineCompiler;
import org.robovm.compiler.Types;
import org.robovm.compiler.VTable;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.AliasRef;
import org.robovm.compiler.llvm.And;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.Fence;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.PackedStructureConstantBuilder;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Store;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.plugin.CompilerPlugin;
import org.robovm.compiler.trampoline.FieldAccessor;
import org.robovm.compiler.trampoline.Invoke;
import org.robovm.compiler.trampoline.Trampoline;
import org.robovm.llvm.Context;
import org.robovm.llvm.Module;
import org.robovm.llvm.PassManager;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetMachine;
import org.robovm.llvm.binding.CodeGenFileType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.Modifier;
import soot.PrimType;
import soot.RefLikeType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.internal.JReturnVoidStmt;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.Tag;

public class ClassCompiler {
    private static final int DUMMY_METHOD_SIZE = 28036591;
    public static final int CI_PUBLIC = 1;
    public static final int CI_FINAL = 2;
    public static final int CI_INTERFACE = 4;
    public static final int CI_ABSTRACT = 8;
    public static final int CI_SYNTHETIC = 16;
    public static final int CI_ANNOTATION = 32;
    public static final int CI_ENUM = 64;
    public static final int CI_ATTRIBUTES = 128;
    public static final int CI_ERROR = 256;
    public static final int CI_INITIALIZED = 512;
    public static final int CI_FINALIZABLE = 1024;
    public static final int CI_ERROR_TYPE_NONE = 0;
    public static final int CI_ERROR_TYPE_NO_CLASS_DEF_FOUND = 1;
    public static final int CI_ERROR_TYPE_ILLEGAL_ACCESS = 2;
    public static final int CI_ERROR_TYPE_INCOMPATIBLE_CLASS_CHANGE = 3;
    public static final int FI_ACCESS_MASK = 3;
    public static final int FI_PUBLIC = 1;
    public static final int FI_PRIVATE = 2;
    public static final int FI_PROTECTED = 3;
    public static final int FI_STATIC = 4;
    public static final int FI_FINAL = 8;
    public static final int FI_VOLATILE = 16;
    public static final int FI_TRANSIENT = 32;
    public static final int FI_SYNTHETIC = 64;
    public static final int FI_ENUM = 128;
    public static final int FI_ATTRIBUTES = 256;
    public static final int MI_ACCESS_MASK = 3;
    public static final int MI_PUBLIC = 1;
    public static final int MI_PRIVATE = 2;
    public static final int MI_PROTECTED = 3;
    public static final int MI_STATIC = 4;
    public static final int MI_FINAL = 8;
    public static final int MI_SYNCHRONIZED = 16;
    public static final int MI_BRIDGE = 32;
    public static final int MI_VARARGS = 64;
    public static final int MI_NATIVE = 128;
    public static final int MI_ABSTRACT = 256;
    public static final int MI_STRICT = 512;
    public static final int MI_SYNTHETIC = 1024;
    public static final int MI_ATTRIBUTES = 2048;
    public static final int MI_BRO_BRIDGE = 4096;
    public static final int MI_BRO_CALLBACK = 8192;
    public static final int MI_COMPACT_DESC = 16384;
    public static final int DESC_B = 1;
    public static final int DESC_C = 2;
    public static final int DESC_D = 3;
    public static final int DESC_F = 4;
    public static final int DESC_I = 5;
    public static final int DESC_J = 6;
    public static final int DESC_S = 7;
    public static final int DESC_Z = 8;
    public static final int DESC_V = 9;
    private SootClass sootClass;
    private ModuleBuilder mb;
    private Set<Trampoline> trampolines;
    private Set<String> catches;
    private List<SootField> classFields;
    private List<SootField> instanceFields;
    private StructureType classType;
    private StructureType instanceType;
    private final Config config;
    private final MethodCompiler methodCompiler;
    private final BridgeMethodCompiler bridgeMethodCompiler;
    private final CallbackMethodCompiler callbackMethodCompiler;
    private final NativeMethodCompiler nativeMethodCompiler;
    private final StructMemberMethodCompiler structMemberMethodCompiler;
    private final GlobalValueMethodCompiler globalValueMethodCompiler;
    private final AttributesEncoder attributesEncoder;
    private final TrampolineCompiler trampolineResolver;
    private final ByteArrayOutputStream output = new ByteArrayOutputStream(262144);

    public ClassCompiler(Config config) {
        this.config = config;
        this.methodCompiler = new MethodCompiler(config);
        this.bridgeMethodCompiler = new BridgeMethodCompiler(config);
        this.callbackMethodCompiler = new CallbackMethodCompiler(config);
        this.nativeMethodCompiler = new NativeMethodCompiler(config);
        this.structMemberMethodCompiler = new StructMemberMethodCompiler(config);
        this.globalValueMethodCompiler = new GlobalValueMethodCompiler(config);
        this.attributesEncoder = new AttributesEncoder();
        this.trampolineResolver = new TrampolineCompiler(config);
    }

    public boolean mustCompile(Clazz clazz) {
        File oFile = this.config.getOFile(clazz);
        if (!oFile.exists() || oFile.lastModified() < clazz.lastModified()) {
            return true;
        }
        ClazzInfo ci = clazz.getClazzInfo();
        if (ci == null) {
            return true;
        }
        Set<Dependency> dependencies = ci.getDependencies();
        for (Dependency dep : dependencies) {
            Clazz depClazz = this.config.getClazzes().load(dep.getClassName());
            if (depClazz == null) {
                if (dep.getPath() == null) continue;
                return true;
            }
            if (dep.getPath() == null) {
                return true;
            }
            if (!dep.getPath().equals(depClazz.getPath().getFile().getAbsolutePath())) {
                return true;
            }
            if (depClazz.isInBootClasspath() != dep.isInBootClasspath()) {
                return true;
            }
            if (depClazz.lastModified() <= oFile.lastModified()) continue;
            return true;
        }
        return dependencies.isEmpty();
    }

    public void compile(Clazz clazz, Executor executor, ClassCompilerListener listener) throws IOException {
        this.reset();
        Arch arch = this.config.getArch();
        OS os = this.config.getOs();
        try {
            this.config.getLogger().debug("Compiling %s (%s %s %s)", new Object[]{clazz, os, arch, this.config.isDebug() ? "debug" : "release"});
            this.output.reset();
            this.compile(clazz, this.output);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        ClassCompiler.scheduleMachineCodeGeneration(executor, listener, this.config, clazz, this.output.toByteArray());
    }

    private static void scheduleMachineCodeGeneration(Executor executor, final ClassCompilerListener listener, final Config config, final Clazz clazz, final byte[] llData) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassCompiler.generateMachineCode(config, clazz, llData);
                        listener.success(clazz);
                    }
                    catch (Throwable t) {
                        listener.failure(clazz, t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            // empty catch block
        }
    }

    private static void generateMachineCode(Config config, Clazz clazz, byte[] llData) throws IOException {
        if (config.isDumpIntermediates()) {
            File llFile = config.getLlFile(clazz);
            llFile.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile(llFile, llData);
        }
        Context context = new Context();
        Module module = Module.parseIR(context, llData, clazz.getClassName());
        PassManager passManager = ClassCompiler.createPassManager(config);
        passManager.run(module);
        passManager.dispose();
        if (config.isDumpIntermediates()) {
            File bcFile = config.getBcFile(clazz);
            bcFile.getParentFile().mkdirs();
            module.writeBitcode(bcFile);
        }
        String triple = config.getTriple();
        Target target = Target.lookupTarget(triple);
        TargetMachine targetMachine = target.createTargetMachine(triple, "generic", null, null, null, null);
        targetMachine.setAsmVerbosityDefault(true);
        targetMachine.setFunctionSections(true);
        targetMachine.setDataSections(true);
        targetMachine.getOptions().setNoFramePointerElim(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream(262144);
        targetMachine.emit(module, output, CodeGenFileType.AssemblyFile);
        module.dispose();
        context.dispose();
        byte[] asm = output.toByteArray();
        output.reset();
        ClassCompiler.patchAsmWithFunctionSizes(config, clazz, new ByteArrayInputStream(asm), output);
        asm = output.toByteArray();
        if (config.isDumpIntermediates()) {
            File sFile = config.getSFile(clazz);
            sFile.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile(sFile, asm);
        }
        File oFile = config.getOFile(clazz);
        oFile.getParentFile().mkdirs();
        BufferedOutputStream oOut = new BufferedOutputStream(new FileOutputStream(oFile));
        targetMachine.assemble(asm, clazz.getClassName(), oOut);
        oOut.close();
        targetMachine.dispose();
    }

    private static PassManager createPassManager(Config config) {
        PassManager passManager = new PassManager();
        if (config.isDebug()) {
            passManager.addAlwaysInlinerPass();
        } else {
            passManager.addAlwaysInlinerPass();
            passManager.addPromoteMemoryToRegisterPass();
            passManager.addTypeBasedAliasAnalysisPass();
            passManager.addBasicAliasAnalysisPass();
            passManager.addGlobalOptimizerPass();
            passManager.addIPSCCPPass();
            passManager.addDeadArgEliminationPass();
            passManager.addInstructionCombiningPass();
            passManager.addCFGSimplificationPass();
            passManager.addPruneEHPass();
            passManager.addFunctionInliningPass();
            passManager.addFunctionAttrsPass();
            passManager.addScalarReplAggregatesPass();
            passManager.addEarlyCSEPass();
            passManager.addSimplifyLibCallsPass();
            passManager.addJumpThreadingPass();
            passManager.addCorrelatedValuePropagationPass();
            passManager.addCFGSimplificationPass();
            passManager.addInstructionCombiningPass();
            passManager.addCFGSimplificationPass();
            passManager.addReassociatePass();
            passManager.addCFGSimplificationPass();
            passManager.addReassociatePass();
            passManager.addLoopRotatePass();
            passManager.addLICMPass();
            passManager.addLoopUnswitchPass();
            passManager.addInstructionCombiningPass();
            passManager.addIndVarSimplifyPass();
            passManager.addLoopIdiomPass();
            passManager.addLoopDeletionPass();
            passManager.addLoopVectorizePass();
            passManager.addLoopUnrollPass();
            passManager.addGVNPass();
            passManager.addMemCpyOptPass();
            passManager.addSCCPPass();
            passManager.addInstructionCombiningPass();
            passManager.addJumpThreadingPass();
            passManager.addCorrelatedValuePropagationPass();
            passManager.addDeadStoreEliminationPass();
            passManager.addSLPVectorizePass();
            passManager.addAggressiveDCEPass();
            passManager.addCFGSimplificationPass();
            passManager.addInstructionCombiningPass();
            passManager.addStripDeadPrototypesPass();
            passManager.addGlobalDCEPass();
            passManager.addConstantMergePass();
        }
        return passManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void patchAsmWithFunctionSizes(Config config, Clazz clazz, InputStream inStream, OutputStream outStream) throws IOException {
        String labelPrefix = config.getOs().getFamily() == OS.Family.darwin ? "_" : "";
        String localLabelPrefix = config.getOs().getFamily() == OS.Family.darwin ? "L" : ".L";
        HashSet<String> functionNames = new HashSet<String>();
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            if (method.isAbstract()) continue;
            String name = labelPrefix + Symbols.methodSymbol(method);
            functionNames.add(name);
        }
        String infoStructLabel = labelPrefix + Symbols.infoStructSymbol(clazz.getInternalName());
        Pattern methodImplPattern = Pattern.compile("\\s*\\.(?:quad|long)\\s+\"?(" + Pattern.quote(labelPrefix + Symbols.methodSymbolPrefix(clazz.getInternalName())) + "[^\\s\"]+)\"?.*");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            out = new BufferedWriter(new OutputStreamWriter(outStream, "UTF-8"));
            String line = null;
            String currentFunction = null;
            while ((line = in.readLine()) != null) {
                if (currentFunction == null) {
                    out.write(line);
                    out.write(10);
                    int colon = line.indexOf(58);
                    if (colon == -1) continue;
                    String label = line.substring(0, colon);
                    if (label.startsWith("\"") && label.endsWith("\"")) {
                        label = label.substring(1, label.length() - 1);
                    }
                    if (functionNames.contains(label)) {
                        currentFunction = label;
                        continue;
                    }
                    if (!label.equals(infoStructLabel)) continue;
                    break;
                }
                if (line.trim().equals(".cfi_endproc") || line.trim().startsWith(".section") || line.trim().startsWith(".globl")) {
                    out.write("\"");
                    out.write(localLabelPrefix);
                    out.write(currentFunction);
                    out.write("_end\":\n\n");
                    currentFunction = null;
                    out.write(line);
                    out.write(10);
                    continue;
                }
                out.write(line);
                out.write(10);
            }
            while ((line = in.readLine()) != null) {
                String functionName;
                out.write(line);
                out.write(10);
                Matcher matcher = methodImplPattern.matcher(line);
                if (!matcher.matches() || !functionNames.contains(functionName = matcher.group(1))) continue;
                line = in.readLine();
                if (line.contains(String.valueOf(28036591))) {
                    out.write("\t.long\t");
                    out.write("\"" + localLabelPrefix + functionName + "_end\" - \"" + functionName + "\"");
                    out.write(10);
                    continue;
                }
                out.write(line);
                out.write(10);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
    }

    private void reset() {
        this.output.reset();
        this.sootClass = null;
        this.mb = null;
        this.trampolines = null;
        this.catches = null;
        this.classFields = null;
        this.instanceFields = null;
        this.classType = null;
        this.instanceType = null;
    }

    private void compile(Clazz clazz, OutputStream out) throws IOException {
        this.methodCompiler.reset(clazz);
        this.bridgeMethodCompiler.reset(clazz);
        this.callbackMethodCompiler.reset(clazz);
        this.nativeMethodCompiler.reset(clazz);
        this.structMemberMethodCompiler.reset(clazz);
        this.globalValueMethodCompiler.reset(clazz);
        ClazzInfo ci = clazz.resetClazzInfo();
        this.mb = new ModuleBuilder();
        for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
            compilerPlugin.beforeClass(this.config, clazz, this.mb);
        }
        this.sootClass = clazz.getSootClass();
        this.trampolines = new HashSet<Trampoline>();
        this.catches = new HashSet<String>();
        this.classFields = Types.getClassFields(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.instanceFields = Types.getInstanceFields(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.classType = Types.getClassType(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.instanceType = Types.getInstanceType(this.config.getOs(), this.config.getArch(), this.sootClass);
        this.attributesEncoder.encode(this.mb, this.sootClass);
        if (!this.sootClass.declaresMethodByName("<clinit>") && ClassCompiler.hasConstantValueTags(this.classFields)) {
            SootMethod clinit = new SootMethod("<clinit>", Collections.EMPTY_LIST, VoidType.v(), 8);
            JimpleBody body = Jimple.v().newBody(clinit);
            clinit.setActiveBody(body);
            body.getUnits().add(new JReturnVoidStmt());
            this.sootClass.addMethod(clinit);
        }
        if (Types.isStruct(this.sootClass)) {
            SootMethod _sizeOf = new SootMethod("_sizeOf", Collections.EMPTY_LIST, IntType.v(), 4);
            this.sootClass.addMethod(_sizeOf);
            SootMethod sizeOf = new SootMethod("sizeOf", Collections.EMPTY_LIST, IntType.v(), 9);
            this.sootClass.addMethod(sizeOf);
        }
        this.mb.addInclude(this.getClass().getClassLoader().getResource(String.format("header-%s-%s.ll", new Object[]{this.config.getOs().getFamily(), this.config.getArch()})));
        this.mb.addInclude(this.getClass().getClassLoader().getResource("header.ll"));
        this.mb.addFunction(this.createLdcClass());
        this.mb.addFunction(this.createLdcClassWrapper());
        Function allocator = this.createAllocator();
        this.mb.addFunction(allocator);
        this.mb.addFunction(this.createClassInitWrapperFunction(allocator.ref()));
        for (SootField f : this.sootClass.getFields()) {
            Function getter = ClassCompiler.createFieldGetter(f, this.classFields, this.classType, this.instanceFields, this.instanceType);
            Function setter = ClassCompiler.createFieldSetter(f, this.classFields, this.classType, this.instanceFields, this.instanceType);
            this.mb.addFunction(getter);
            this.mb.addFunction(setter);
            if (!f.isStatic() || f.isPrivate()) continue;
            this.mb.addFunction(this.createClassInitWrapperFunction(getter.ref()));
            if (f.isFinal()) continue;
            this.mb.addFunction(this.createClassInitWrapperFunction(setter.ref()));
        }
        for (SootMethod method : this.sootClass.getMethods()) {
            for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
                compilerPlugin.beforeMethod(this.config, clazz, method, this.mb);
            }
            String name = method.getName();
            Function function = null;
            if (Annotations.hasBridgeAnnotation(method)) {
                function = this.bridgeMethod(method);
            } else if (Annotations.hasGlobalValueAnnotation(method)) {
                function = this.globalValueMethod(method);
            } else if (Types.isStruct(this.sootClass) && ("_sizeOf".equals(name) || "sizeOf".equals(name) || Annotations.hasStructMemberAnnotation(method))) {
                function = this.structMember(method);
            } else if (method.isNative()) {
                function = this.nativeMethod(method);
            } else if (!method.isAbstract()) {
                function = this.method(method);
            }
            if (Annotations.hasCallbackAnnotation(method)) {
                this.callbackMethod(method);
            }
            if (!(name.equals("<clinit>") || name.equals("<init>") || method.isPrivate() || method.isStatic() || Modifier.isFinal(method.getModifiers()) || Modifier.isFinal(this.sootClass.getModifiers()))) {
                this.createLookupFunction(method);
            }
            if (method.isStatic()) {
                String fnName = method.isSynchronized() ? Symbols.synchronizedWrapperSymbol(method) : Symbols.methodSymbol(method);
                FunctionRef fn = new FunctionRef(fnName, Types.getFunctionType(method));
                this.mb.addFunction(this.createClassInitWrapperFunction(fn));
            }
            for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
                if (function == null) continue;
                compilerPlugin.afterMethod(this.config, clazz, method, this.mb, function);
            }
        }
        HashSet<String> trampolineDependencies = new HashSet<String>();
        for (Trampoline trampoline : this.trampolines) {
            this.trampolineResolver.compile(this.mb, trampoline);
            trampolineDependencies.addAll(this.trampolineResolver.getDependencies());
        }
        Global classInfoStruct = null;
        try {
            if (!this.sootClass.isInterface()) {
                this.config.getVTableCache().get(this.sootClass);
            }
            classInfoStruct = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Linkage.weak, this.createClassInfoStruct());
        }
        catch (IllegalArgumentException e) {
            classInfoStruct = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Type.I8_PTR, true);
        }
        this.mb.addGlobal(classInfoStruct);
        Function infoFn = FunctionBuilder.infoStruct(this.sootClass);
        infoFn.add(new Ret(new ConstantBitcast(classInfoStruct.ref(), Type.I8_PTR_PTR)));
        this.mb.addFunction(infoFn);
        for (CompilerPlugin compilerPlugin : this.config.getCompilerPlugins()) {
            compilerPlugin.afterClass(this.config, clazz, this.mb);
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        this.mb.build().write(writer);
        writer.flush();
        ci.setCatchNames(this.catches);
        ci.setTrampolines(this.trampolines);
        ci.addDependency("java/lang/Object");
        if (this.sootClass.hasSuperclass() && !this.sootClass.isInterface()) {
            ci.addDependency(Types.getInternalName(this.sootClass.getSuperclass()));
        }
        for (SootClass iface : this.sootClass.getInterfaces()) {
            ci.addDependency(Types.getInternalName(iface));
        }
        for (SootField f : this.sootClass.getFields()) {
            ClassCompiler.addDependencyIfNeeded(clazz, f.getType());
        }
        for (SootMethod m : this.sootClass.getMethods()) {
            ClassCompiler.addDependencyIfNeeded(clazz, m.getReturnType());
            List paramTypes = m.getParameterTypes();
            for (soot.Type type : paramTypes) {
                ClassCompiler.addDependencyIfNeeded(clazz, type);
            }
        }
        ci.addDependencies(this.attributesEncoder.getDependencies());
        ci.addDependencies(trampolineDependencies);
        ci.addDependencies(this.catches);
        for (Trampoline t : this.trampolines) {
            String desc = t.getTarget();
            if (desc.charAt(0) == 'L' || desc.charAt(0) == '[') {
                ClassCompiler.addDependencyIfNeeded(clazz, desc);
            } else {
                ci.addDependency(t.getTarget());
            }
            if (t instanceof FieldAccessor) {
                ClassCompiler.addDependencyIfNeeded(clazz, ((FieldAccessor)t).getFieldDesc());
                continue;
            }
            if (!(t instanceof Invoke)) continue;
            String methodDesc = ((Invoke)t).getMethodDesc();
            ClassCompiler.addDependencyIfNeeded(clazz, Types.getReturnTypeDescriptor(methodDesc));
            for (String desc2 : Types.getParameterDescriptors(methodDesc)) {
                ClassCompiler.addDependencyIfNeeded(clazz, desc2);
            }
        }
        clazz.saveClazzInfo();
    }

    private static void addDependencyIfNeeded(Clazz clazz, soot.Type type) {
        if (type instanceof RefLikeType) {
            ClassCompiler.addDependencyIfNeeded(clazz, Types.getDescriptor(type));
        }
    }

    private static void addDependencyIfNeeded(Clazz clazz, String desc) {
        if (!(Types.isPrimitive(desc) || Types.isArray(desc) && Types.isPrimitiveBaseType(desc))) {
            String internalName;
            String string = internalName = Types.isArray(desc) ? Types.getBaseType(desc) : Types.getInternalNameFromDescriptor(desc);
            if (!clazz.getInternalName().equals(internalName)) {
                clazz.getClazzInfo().addDependency(internalName);
            }
        }
    }

    private void createLookupFunction(SootMethod m) {
        Function function = FunctionBuilder.lookup(m, true);
        this.mb.addFunction(function);
        Variable reserved0 = function.newVariable(Type.I8_PTR_PTR);
        function.add(new Getelementptr(reserved0, (Value)function.getParameterRef(0), 0, 4));
        Variable reserved1 = function.newVariable(Type.I8_PTR_PTR);
        function.add(new Getelementptr(reserved1, (Value)function.getParameterRef(0), 0, 5));
        function.add(new Store(this.getString(m.getName()), reserved0.ref()));
        function.add(new Store(this.getString(Types.getDescriptor(m)), reserved1.ref()));
        if (!this.sootClass.isInterface()) {
            int vtableIndex = 0;
            try {
                VTable vtable = this.config.getVTableCache().get(this.sootClass);
                vtableIndex = vtable.getEntry(m).getIndex();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Value classPtr = Functions.call(function, (Value)Functions.OBJECT_CLASS, function.getParameterRef(1));
            Value vtablePtr = Functions.call(function, (Value)Functions.CLASS_VITABLE, classPtr);
            Variable funcPtrPtr = function.newVariable(Type.I8_PTR_PTR);
            function.add(new Getelementptr(funcPtrPtr, vtablePtr, 0, 1, vtableIndex));
            Variable funcPtr = function.newVariable(Type.I8_PTR);
            function.add(new Load(funcPtr, funcPtrPtr.ref()));
            Variable f = function.newVariable(function.getType());
            function.add(new Bitcast(f, funcPtr.ref(), f.getType()));
            Value result = Functions.tailcall(function, f.ref(), function.getParameterRefs());
            function.add(new Ret(result));
        } else {
            ITable itable = this.config.getITableCache().get(this.sootClass);
            ITable.Entry entry = itable.getEntry(m);
            ArrayList<Value> args = new ArrayList<Value>();
            args.add(function.getParameterRef(0));
            args.add(ClassCompiler.getInfoStruct(function, this.sootClass));
            args.add(function.getParameterRef(1));
            args.add(new IntegerConstant(entry.getIndex()));
            Value fptr = Functions.call(function, (Value)Functions.BC_LOOKUP_INTERFACE_METHOD_IMPL, args);
            Variable f = function.newVariable(function.getType());
            function.add(new Bitcast(f, fptr, f.getType()));
            Value result = Functions.tailcall(function, f.ref(), function.getParameterRefs());
            function.add(new Ret(result));
        }
    }

    private Constant createVTableStruct() {
        VTable vtable = this.config.getVTableCache().get(this.sootClass);
        String name = Symbols.vtableSymbol(Types.getInternalName(this.sootClass));
        for (VTable.Entry entry : vtable.getEntries()) {
            FunctionRef fref = entry.getFunctionRef();
            if (fref == null || this.mb.hasSymbol(fref.getName())) continue;
            this.mb.addFunctionDeclaration(new FunctionDeclaration(fref));
        }
        Global vtableStruct = new Global(name, Linkage._private, vtable.getStruct(), true);
        this.mb.addGlobal(vtableStruct);
        return new ConstantBitcast(vtableStruct.ref(), Type.I8_PTR);
    }

    private Constant createITableStruct() {
        ITable itable = this.config.getITableCache().get(this.sootClass);
        String name = Symbols.itableSymbol(Types.getInternalName(this.sootClass));
        Global itableStruct = new Global(name, Linkage._private, itable.getStruct(), true);
        this.mb.addGlobal(itableStruct);
        return new ConstantBitcast(itableStruct.ref(), Type.I8_PTR);
    }

    private Constant createITablesStruct() {
        if (!this.sootClass.isInterface()) {
            HashSet<SootClass> interfaces = new HashSet<SootClass>();
            ClassCompiler.collectInterfaces(this.sootClass, interfaces);
            ArrayList<ConstantBitcast> tables = new ArrayList<ConstantBitcast>();
            int i = 0;
            for (SootClass ifs : interfaces) {
                ITable itable = this.config.getITableCache().get(ifs);
                if (itable.size() <= 0) continue;
                String name = Symbols.itableSymbol(Types.getInternalName(this.sootClass), i++);
                String typeInfoName = Symbols.typeInfoSymbol(Types.getInternalName(ifs));
                if (!this.mb.hasSymbol(typeInfoName)) {
                    this.mb.addGlobal(new Global(typeInfoName, Linkage.external, Type.I8_PTR, true));
                }
                Global itableStruct = new Global(name, Linkage._private, new StructureConstantBuilder().add(this.mb.getGlobalRef(typeInfoName)).add(itable.getStruct(this.mb, this.sootClass)).build(), true);
                this.mb.addGlobal(itableStruct);
                tables.add(new ConstantBitcast(itableStruct.ref(), Type.I8_PTR));
            }
            if (tables.isEmpty()) {
                return new NullConstant(Type.I8_PTR);
            }
            Global itablesStruct = new Global(Symbols.itablesSymbol(Types.getInternalName(this.sootClass)), Linkage._private, new StructureConstantBuilder().add(new IntegerConstant((short)tables.size())).add((Value)tables.get(0)).add(new ArrayConstantBuilder(Type.I8_PTR).add(tables).build()).build());
            this.mb.addGlobal(itablesStruct);
            return new ConstantBitcast(itablesStruct.ref(), Type.I8_PTR);
        }
        return new NullConstant(Type.I8_PTR);
    }

    private StructureConstant createClassInfoStruct() {
        int flags = 0;
        if (Modifier.isPublic(this.sootClass.getModifiers())) {
            flags |= 1;
        }
        if (Modifier.isFinal(this.sootClass.getModifiers())) {
            flags |= 2;
        }
        if (Modifier.isInterface(this.sootClass.getModifiers())) {
            flags |= 4;
        }
        if (Modifier.isAbstract(this.sootClass.getModifiers())) {
            flags |= 8;
        }
        if ((this.sootClass.getModifiers() & 0x1000) > 0) {
            flags |= 0x10;
        }
        if (Modifier.isAnnotation(this.sootClass.getModifiers())) {
            flags |= 0x20;
        }
        if (Modifier.isEnum(this.sootClass.getModifiers())) {
            flags |= 0x40;
        }
        if (this.attributesEncoder.classHasAttributes()) {
            flags |= 0x80;
        }
        if (ClassCompiler.hasFinalizer(this.sootClass)) {
            flags |= 0x400;
        }
        StructureConstantBuilder header = new StructureConstantBuilder();
        header.add(new NullConstant(Type.I8_PTR));
        header.add(new IntegerConstant(flags));
        header.add(this.getString(Types.getInternalName(this.sootClass)));
        if (this.sootClass.declaresMethod("<clinit>", Collections.emptyList(), VoidType.v())) {
            SootMethod method = this.sootClass.getMethod("<clinit>", Collections.emptyList(), VoidType.v());
            header.add(new FunctionRef(Symbols.methodSymbol(method), Types.getFunctionType(method)));
        } else {
            header.add(new NullConstant(Type.I8_PTR));
        }
        this.mb.addGlobal(new Global(Symbols.typeInfoSymbol(Types.getInternalName(this.sootClass)), Linkage.external, Type.I8_PTR, true));
        header.add(new GlobalRef(Symbols.typeInfoSymbol(Types.getInternalName(this.sootClass)), Type.I8_PTR));
        if (!this.sootClass.isInterface()) {
            header.add(this.createVTableStruct());
        } else {
            header.add(this.createITableStruct());
        }
        header.add(this.createITablesStruct());
        header.add(Types.sizeof(this.classType));
        header.add(Types.sizeof(this.instanceType));
        if (!this.instanceFields.isEmpty()) {
            header.add(Types.offsetof(this.instanceType, 1, 1));
        } else {
            header.add(Types.sizeof(this.instanceType));
        }
        header.add(new IntegerConstant((short)ClassCompiler.countReferences(this.classFields)));
        header.add(new IntegerConstant((short)ClassCompiler.countReferences(this.instanceFields)));
        PackedStructureConstantBuilder body = new PackedStructureConstantBuilder();
        body.add(new IntegerConstant((short)this.sootClass.getInterfaceCount()));
        body.add(new IntegerConstant((short)this.sootClass.getFieldCount()));
        body.add(new IntegerConstant((short)this.sootClass.getMethodCount()));
        if (!this.sootClass.isInterface()) {
            body.add(this.getStringOrNull(this.sootClass.hasSuperclass() ? Types.getInternalName(this.sootClass.getSuperclass()) : null));
        }
        if (this.attributesEncoder.classHasAttributes()) {
            body.add(new ConstantBitcast(this.attributesEncoder.getClassAttributes().ref(), Type.I8_PTR));
        }
        for (SootClass s : this.sootClass.getInterfaces()) {
            body.add(this.getString(Types.getInternalName(s)));
        }
        for (SootField f : this.sootClass.getFields()) {
            int index;
            flags = 0;
            soot.Type t = f.getType();
            if (t instanceof PrimType) {
                if (t.equals(BooleanType.v())) {
                    flags |= 8;
                } else if (t.equals(ByteType.v())) {
                    flags |= 1;
                } else if (t.equals(ShortType.v())) {
                    flags |= 7;
                } else if (t.equals(CharType.v())) {
                    flags |= 2;
                } else if (t.equals(IntType.v())) {
                    flags |= 5;
                } else if (t.equals(LongType.v())) {
                    flags |= 6;
                } else if (t.equals(FloatType.v())) {
                    flags |= 4;
                } else if (t.equals(DoubleType.v())) {
                    flags |= 3;
                }
                flags <<= 12;
            }
            if (Modifier.isPublic(f.getModifiers())) {
                flags |= 1;
            } else if (Modifier.isPrivate(f.getModifiers())) {
                flags |= 2;
            } else if (Modifier.isProtected(f.getModifiers())) {
                flags |= 3;
            }
            if (Modifier.isStatic(f.getModifiers())) {
                flags |= 4;
            }
            if (Modifier.isFinal(f.getModifiers())) {
                flags |= 8;
            }
            if (Modifier.isVolatile(f.getModifiers())) {
                flags |= 0x10;
            }
            if (Modifier.isTransient(f.getModifiers())) {
                flags |= 0x20;
            }
            if ((f.getModifiers() & 0x1000) > 0) {
                flags |= 0x40;
            }
            if (Modifier.isEnum(f.getModifiers())) {
                flags |= 0x80;
            }
            if (this.attributesEncoder.fieldHasAttributes(f)) {
                flags |= 0x100;
            }
            body.add(new IntegerConstant((short)flags));
            body.add(this.getString(f.getName()));
            if (!(t instanceof PrimType)) {
                body.add(this.getString(Types.getDescriptor(f)));
            }
            if (f.isStatic()) {
                index = this.classFields.indexOf(f);
                body.add(Types.offsetof(this.classType, 1, index, 1));
            } else {
                index = this.instanceFields.indexOf(f);
                body.add(Types.offsetof(this.instanceType, 1, 1 + index, 1));
            }
            if (!this.attributesEncoder.fieldHasAttributes(f)) continue;
            body.add(new ConstantBitcast(this.attributesEncoder.getFieldAttributes(f).ref(), Type.I8_PTR));
        }
        VTable vtable = !this.sootClass.isInterface() ? this.config.getVTableCache().get(this.sootClass) : null;
        ITable itable = this.sootClass.isInterface() ? this.config.getITableCache().get(this.sootClass) : null;
        for (SootMethod m : this.sootClass.getMethods()) {
            Object entry;
            soot.Type t = m.getReturnType();
            flags = 0;
            if (Modifier.isPublic(m.getModifiers())) {
                flags |= 1;
            } else if (Modifier.isPrivate(m.getModifiers())) {
                flags |= 2;
            } else if (Modifier.isProtected(m.getModifiers())) {
                flags |= 3;
            }
            if (Modifier.isStatic(m.getModifiers())) {
                flags |= 4;
            }
            if (Modifier.isFinal(m.getModifiers())) {
                flags |= 8;
            }
            if (Modifier.isSynchronized(m.getModifiers())) {
                flags |= 0x10;
            }
            if ((m.getModifiers() & 0x40) > 0) {
                flags |= 0x20;
            }
            if ((m.getModifiers() & 0x80) > 0) {
                flags |= 0x40;
            }
            if (Modifier.isNative(m.getModifiers()) && !Types.isStruct(this.sootClass) && !Annotations.hasStructMemberAnnotation(m)) {
                flags |= 0x80;
            }
            if (Modifier.isAbstract(m.getModifiers())) {
                flags |= 0x100;
            }
            if (Modifier.isStrictFP(m.getModifiers())) {
                flags |= 0x200;
            }
            if ((m.getModifiers() & 0x1000) > 0) {
                flags |= 0x400;
            }
            if (this.attributesEncoder.methodHasAttributes(m)) {
                flags |= 0x800;
            }
            if (Annotations.hasBridgeAnnotation(m) || Annotations.hasGlobalValueAnnotation(m)) {
                flags |= 0x1000;
            }
            if (Annotations.hasCallbackAnnotation(m)) {
                flags |= 0x2000;
            }
            if ((t instanceof PrimType || t == VoidType.v()) && m.getParameterCount() == 0) {
                flags |= 0x4000;
            }
            body.add(new IntegerConstant((short)flags));
            IntegerConstant viTableIndex = new IntegerConstant(-1);
            if (vtable != null) {
                entry = vtable.getEntry(m);
                if (entry != null) {
                    viTableIndex = new IntegerConstant((short)((VTable.Entry)entry).getIndex());
                }
            } else {
                entry = itable.getEntry(m);
                if (entry != null) {
                    viTableIndex = new IntegerConstant((short)((ITable.Entry)entry).getIndex());
                }
            }
            body.add(viTableIndex);
            body.add(this.getString(m.getName()));
            if ((flags & 0x4000) > 0) {
                int desc = 0;
                if (t.equals(BooleanType.v())) {
                    desc = 8;
                } else if (t.equals(ByteType.v())) {
                    desc = 1;
                } else if (t.equals(ShortType.v())) {
                    desc = 7;
                } else if (t.equals(CharType.v())) {
                    desc = 2;
                } else if (t.equals(IntType.v())) {
                    desc = 5;
                } else if (t.equals(LongType.v())) {
                    desc = 6;
                } else if (t.equals(FloatType.v())) {
                    desc = 4;
                } else if (t.equals(DoubleType.v())) {
                    desc = 3;
                } else if (t.equals(VoidType.v())) {
                    desc = 9;
                }
                body.add(new IntegerConstant((byte)desc));
            } else {
                body.add(this.getString(Types.getDescriptor(m)));
            }
            if (this.attributesEncoder.methodHasAttributes(m)) {
                body.add(new ConstantBitcast(this.attributesEncoder.getMethodAttributes(m).ref(), Type.I8_PTR));
            }
            if (!m.isAbstract()) {
                body.add(new ConstantBitcast(new FunctionRef(Symbols.methodSymbol(m), Types.getFunctionType(m)), Type.I8_PTR));
                body.add(new IntegerConstant(28036591));
                if (m.isSynchronized()) {
                    body.add(new ConstantBitcast(new FunctionRef(Symbols.synchronizedWrapperSymbol(m), Types.getFunctionType(m)), Type.I8_PTR));
                }
            }
            if (Annotations.hasBridgeAnnotation(m)) {
                if (!Annotations.readBooleanElem(Annotations.getAnnotation(m, "Lorg/robovm/rt/bro/annotation/Bridge;"), "dynamic", false)) {
                    body.add(new GlobalRef(Symbols.bridgePtrSymbol(m), Type.I8_PTR));
                } else {
                    body.add(new NullConstant(Type.I8_PTR));
                }
            } else if (Annotations.hasGlobalValueAnnotation(m)) {
                body.add(new GlobalRef(Symbols.globalValuePtrSymbol(m), Type.I8_PTR));
            }
            if (!Annotations.hasCallbackAnnotation(m)) continue;
            body.add(new AliasRef(Symbols.callbackPtrSymbol(m), Type.I8_PTR));
        }
        return new StructureConstantBuilder().add(header.build()).add(body.build()).build();
    }

    private Function nativeMethod(SootMethod method) {
        Function fn = this.nativeMethodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.nativeMethodCompiler.getTrampolines());
        this.catches.addAll(this.nativeMethodCompiler.getCatches());
        return fn;
    }

    private Function bridgeMethod(SootMethod method) {
        Function fn = this.bridgeMethodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.bridgeMethodCompiler.getTrampolines());
        this.catches.addAll(this.bridgeMethodCompiler.getCatches());
        return fn;
    }

    private Function callbackMethod(SootMethod method) {
        Function fn = this.callbackMethodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.callbackMethodCompiler.getTrampolines());
        this.catches.addAll(this.callbackMethodCompiler.getCatches());
        return fn;
    }

    private Function structMember(SootMethod method) {
        Function fn = this.structMemberMethodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.structMemberMethodCompiler.getTrampolines());
        this.catches.addAll(this.structMemberMethodCompiler.getCatches());
        return fn;
    }

    private Function globalValueMethod(SootMethod method) {
        Function fn = this.globalValueMethodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.globalValueMethodCompiler.getTrampolines());
        this.catches.addAll(this.globalValueMethodCompiler.getCatches());
        return fn;
    }

    private Function method(SootMethod method) {
        Function fn = this.methodCompiler.compile(this.mb, method);
        this.trampolines.addAll(this.methodCompiler.getTrampolines());
        this.catches.addAll(this.methodCompiler.getCatches());
        return fn;
    }

    private Function createAllocator() {
        Function fn = FunctionBuilder.allocator(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.BC_ALLOCATE, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    private Function createLdcClass() {
        Function fn = FunctionBuilder.ldcInternal(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    private Function createLdcClassWrapper() {
        Function fn = FunctionBuilder.ldcExternal(this.sootClass);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Value result = Functions.call(fn, (Value)Functions.LDC_CLASS_WRAPPER, fn.getParameterRef(0), info);
        fn.add(new Ret(result));
        return fn;
    }

    static Function createFieldGetter(SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Function fn = FunctionBuilder.getter(field);
        return ClassCompiler.createFieldGetter(fn, field, classFields, classType, instanceFields, instanceType);
    }

    static Function createFieldGetter(Function fn, SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Value fieldPtr = null;
        fieldPtr = field.isStatic() ? ClassCompiler.getClassFieldPtr(fn, field, classFields, classType) : ClassCompiler.getInstanceFieldPtr(fn, fn.getParameterRef(1), field, instanceFields, instanceType);
        Variable result = fn.newVariable(Types.getType(field.getType()));
        if (Modifier.isVolatile(field.getModifiers())) {
            fn.add(new Fence(Ordering.seq_cst));
            if (LongType.v().equals(field.getType())) {
                fn.add(new Load(result, fieldPtr, false, Ordering.unordered, 8));
            } else {
                fn.add(new Load(result, fieldPtr));
            }
        } else {
            fn.add(new Load(result, fieldPtr));
        }
        fn.add(new Ret(new VariableRef(result)));
        return fn;
    }

    static Function createFieldSetter(SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Function fn = FunctionBuilder.setter(field);
        return ClassCompiler.createFieldSetter(fn, field, classFields, classType, instanceFields, instanceType);
    }

    static Function createFieldSetter(Function fn, SootField field, List<SootField> classFields, StructureType classType, List<SootField> instanceFields, StructureType instanceType) {
        Value fieldPtr = null;
        VariableRef value = null;
        if (field.isStatic()) {
            fieldPtr = ClassCompiler.getClassFieldPtr(fn, field, classFields, classType);
            value = fn.getParameterRef(1);
        } else {
            fieldPtr = ClassCompiler.getInstanceFieldPtr(fn, fn.getParameterRef(1), field, instanceFields, instanceType);
            value = fn.getParameterRef(2);
        }
        if (Modifier.isVolatile(field.getModifiers()) || !field.isStatic() && Modifier.isFinal(field.getModifiers())) {
            if (LongType.v().equals(field.getType())) {
                fn.add(new Store(value, fieldPtr, false, Ordering.unordered, 8));
            } else {
                fn.add(new Store(value, fieldPtr));
            }
            fn.add(new Fence(Ordering.seq_cst));
        } else {
            fn.add(new Store(value, fieldPtr));
        }
        fn.add(new Ret());
        return fn;
    }

    private Function createClassInitWrapperFunction(FunctionRef targetFn) {
        Function fn = FunctionBuilder.clinitWrapper(targetFn);
        Value info = ClassCompiler.getInfoStruct(fn, this.sootClass);
        Variable infoHeader = fn.newVariable(new PointerType(new StructureType(Type.I8_PTR, Type.I32)));
        fn.add(new Bitcast(infoHeader, info, infoHeader.getType()));
        Variable infoHeaderFlags = fn.newVariable(new PointerType(Type.I32));
        fn.add(new Getelementptr(infoHeaderFlags, (Value)infoHeader.ref(), 0, 1));
        Variable flags = fn.newVariable(Type.I32);
        fn.add(new Load(flags, infoHeaderFlags.ref()));
        Variable initializedFlag = fn.newVariable(Type.I32);
        fn.add(new And(initializedFlag, flags.ref(), new IntegerConstant(512)));
        Variable initialized = fn.newVariable(Type.I1);
        fn.add(new Icmp(initialized, Icmp.Condition.eq, initializedFlag.ref(), new IntegerConstant(512)));
        Label trueLabel = new Label();
        Label falseLabel = new Label();
        fn.add(new Br(initialized.ref(), fn.newBasicBlockRef(trueLabel), fn.newBasicBlockRef(falseLabel)));
        fn.newBasicBlock(trueLabel);
        Value result = Functions.call(fn, (Value)targetFn, fn.getParameterRefs());
        fn.add(new Ret(result));
        fn.newBasicBlock(falseLabel);
        Functions.call(fn, (Value)Functions.BC_INITIALIZE_CLASS, fn.getParameterRef(0), info);
        fn.add(new Br(fn.newBasicBlockRef(trueLabel)));
        return fn;
    }

    private static int countReferences(List<SootField> l) {
        int count = 0;
        for (SootField f : l) {
            if (!(f.getType() instanceof RefLikeType)) continue;
            ++count;
        }
        return count;
    }

    private static void collectInterfaces(SootClass clazz, Set<SootClass> interfaces) {
        if (clazz.hasSuperclass()) {
            ClassCompiler.collectInterfaces(clazz.getSuperclass(), interfaces);
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        for (SootClass sc : clazz.getInterfaces()) {
            ClassCompiler.collectInterfaces(sc, interfaces);
        }
    }

    private static boolean hasConstantValueTags(List<SootField> classFields) {
        for (SootField field : classFields) {
            for (Tag tag : field.getTags()) {
                if (!(tag instanceof ConstantValueTag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasFinalizer(SootClass clazz) {
        if (clazz.isInterface() || !clazz.hasSuperclass()) {
            return false;
        }
        return clazz.declaresMethod("finalize", Collections.emptyList(), VoidType.v());
    }

    private Constant getString(String string) {
        return this.mb.getString(string);
    }

    private Constant getStringOrNull(String string) {
        return this.mb.getStringOrNull(string);
    }

    static Value getClassFieldPtr(Function f, SootField field, List<SootField> classFields, StructureType classType) {
        Value info = ClassCompiler.getInfoStruct(f, field.getDeclaringClass());
        Variable base = f.newVariable(Type.I8_PTR);
        f.add(new Load(base, info));
        return Types.getFieldPtr(f, new VariableRef(base), Types.offsetof(classType, 1, classFields.indexOf(field), 1), Types.getType(field.getType()));
    }

    static Value getInfoStruct(Function f, SootClass sootClass) {
        return Functions.call(f, (Value)FunctionBuilder.infoStruct(sootClass).ref(), new Value[0]);
    }

    static Value getInstanceFieldPtr(Function f, Value base, SootField field, List<SootField> instanceFields, StructureType instanceType) {
        return Types.getFieldPtr(f, base, Types.offsetof(instanceType, 1, 1 + instanceFields.indexOf(field), 1), Types.getType(field.getType()));
    }
}

