/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.Access;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.hash.HashTableGenerator;
import org.robovm.compiler.hash.ModifiedUtf8HashFunction;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.ConstantGetelementptr;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.llvm.Context;
import org.robovm.llvm.Module;
import org.robovm.llvm.PassManager;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetMachine;
import org.robovm.llvm.binding.CodeGenFileType;

public class Linker {
    private static final TypeInfo[] EMPTY_TYPE_INFOS = new TypeInfo[0];
    private final Config config;

    public Linker(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(Set<Clazz> classes) throws IOException {
        TreeSet<Clazz> linkClasses = new TreeSet<Clazz>(classes);
        this.config.getLogger().info("Linking %d classes", linkClasses.size());
        ModuleBuilder mb = new ModuleBuilder();
        mb.addInclude(this.getClass().getClassLoader().getResource(String.format("header-%s-%s.ll", new Object[]{this.config.getOs().getFamily(), this.config.getArch()})));
        mb.addInclude(this.getClass().getClassLoader().getResource("header.ll"));
        mb.addGlobal(new Global("_bcDynamicJNI", new IntegerConstant(this.config.isUseDynamicJni() ? (byte)1 : 0)));
        ArrayConstantBuilder staticLibs = new ArrayConstantBuilder(Type.I8_PTR);
        if (!this.config.isUseDynamicJni()) {
            for (Config.Lib lib : this.config.getLibs()) {
                String p = lib.getValue();
                if (!p.endsWith(".a")) continue;
                String libName = (p = new File(p).getName()).substring(0, p.length() - 2);
                if (libName.startsWith("lib")) {
                    libName = libName.substring(3);
                }
                staticLibs.add(mb.getString(libName));
            }
        }
        staticLibs.add(new NullConstant(Type.I8_PTR));
        mb.addGlobal(new Global("_bcStaticLibs", new ConstantGetelementptr(mb.newGlobal(staticLibs.build()).ref(), 0, 0)));
        HashTableGenerator<String, ConstantBitcast> bcpHashGen = new HashTableGenerator<String, ConstantBitcast>(new ModifiedUtf8HashFunction());
        HashTableGenerator<String, ConstantBitcast> cpHashGen = new HashTableGenerator<String, ConstantBitcast>(new ModifiedUtf8HashFunction());
        int classCount = 0;
        HashMap<ClazzInfo, TypeInfo> typeInfos = new HashMap<ClazzInfo, TypeInfo>();
        for (Clazz clazz : linkClasses) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.clazz = clazz;
            typeInfo.id = classCount++;
            typeInfos.put(clazz.getClazzInfo(), typeInfo);
            StructureConstant infoErrorStruct = this.createClassInfoErrorStruct(mb, clazz.getClazzInfo());
            Global info = null;
            if (infoErrorStruct == null) {
                info = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Linkage.external, Type.I8_PTR, false);
            } else {
                typeInfo.error = true;
                info = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), infoErrorStruct);
            }
            mb.addGlobal(info);
            if (clazz.isInBootClasspath()) {
                bcpHashGen.put(clazz.getInternalName(), new ConstantBitcast(info.ref(), Type.I8_PTR));
                continue;
            }
            cpHashGen.put(clazz.getInternalName(), new ConstantBitcast(info.ref(), Type.I8_PTR));
        }
        mb.addGlobal(new Global("_bcBootClassesHash", new ConstantGetelementptr(mb.newGlobal(bcpHashGen.generate(), true).ref(), 0, 0)));
        mb.addGlobal(new Global("_bcClassesHash", new ConstantGetelementptr(mb.newGlobal(cpHashGen.generate(), true).ref(), 0, 0)));
        ArrayConstantBuilder bootClasspathValues = new ArrayConstantBuilder(Type.I8_PTR);
        ArrayConstantBuilder classpathValues = new ArrayConstantBuilder(Type.I8_PTR);
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.addAll(this.config.getClazzes().getPaths());
        allPaths.addAll(this.config.getResourcesPaths());
        for (Path path : allPaths) {
            String entryName = null;
            entryName = this.config.isSkipInstall() && this.config.getTarget().canLaunchInPlace() ? path.getFile().getAbsolutePath() : this.config.getTarget().getInstallRelativeArchivePath(path);
            if (path.isInBootClasspath()) {
                bootClasspathValues.add(mb.getString(entryName));
                continue;
            }
            classpathValues.add(mb.getString(entryName));
        }
        bootClasspathValues.add(new NullConstant(Type.I8_PTR));
        classpathValues.add(new NullConstant(Type.I8_PTR));
        mb.addGlobal(new Global("_bcBootclasspath", new ConstantGetelementptr(mb.newGlobal(bootClasspathValues.build()).ref(), 0, 0)));
        mb.addGlobal(new Global("_bcClasspath", new ConstantGetelementptr(mb.newGlobal(classpathValues.build()).ref(), 0, 0)));
        if (this.config.getMainClass() != null) {
            mb.addGlobal(new Global("_bcMainClass", mb.getString(this.config.getMainClass())));
        }
        this.buildTypeInfos(typeInfos);
        for (Clazz clazz : linkClasses) {
            ClazzInfo ci = clazz.getClazzInfo();
            TypeInfo typeInfo = (TypeInfo)typeInfos.get(ci);
            if (typeInfo.error) {
                mb.addGlobal(new Global(Symbols.typeInfoSymbol(clazz.getInternalName()), new StructureConstantBuilder().add(new IntegerConstant(typeInfo.id)).add(new IntegerConstant(0)).add(new IntegerConstant(-1)).add(new IntegerConstant(0)).add(new IntegerConstant(0)).build()));
            } else {
                int[] classIds = new int[typeInfo.classTypes.length];
                for (int i = 0; i < typeInfo.classTypes.length; ++i) {
                    classIds[i] = typeInfo.classTypes[i].id;
                }
                int[] interfaceIds = new int[typeInfo.interfaceTypes.length];
                for (int i = 0; i < typeInfo.interfaceTypes.length; ++i) {
                    interfaceIds[i] = typeInfo.interfaceTypes[i].id;
                }
                mb.addGlobal(new Global(Symbols.typeInfoSymbol(clazz.getInternalName()), new StructureConstantBuilder().add(new IntegerConstant(typeInfo.id)).add(new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20)).add(new IntegerConstant(-1)).add(new IntegerConstant(typeInfo.classTypes.length)).add(new IntegerConstant(typeInfo.interfaceTypes.length)).add(new ArrayConstantBuilder(Type.I32).add(classIds).build()).add(new ArrayConstantBuilder(Type.I32).add(interfaceIds).build()).build()));
                if (!this.config.isDebug() && !ci.isInterface() && !ci.isFinal() && typeInfo.children.isEmpty()) {
                    for (ClazzInfo.MethodInfo mi : ci.getMethods()) {
                        String name = mi.getName();
                        if (name.equals("<clinit>") || name.equals("<init>") || mi.isPrivate() || mi.isStatic() || mi.isFinal() || mi.isAbstract()) continue;
                        mb.addFunction(this.createLookup(mb, ci, mi));
                    }
                }
            }
            mb.addFunction(this.createCheckcast(mb, clazz, typeInfo));
            mb.addFunction(this.createInstanceof(mb, clazz, typeInfo));
        }
        Arch arch = this.config.getArch();
        OS os = this.config.getOs();
        Context context = new Context();
        Module module = Module.parseIR(context, mb.build().toString(), "linker.ll");
        PassManager passManager = new PassManager();
        passManager.addAlwaysInlinerPass();
        passManager.addPromoteMemoryToRegisterPass();
        passManager.run(module);
        passManager.dispose();
        String triple = arch.getLlvmName() + "-unknown-" + (Object)((Object)os);
        Target target = Target.lookupTarget(triple);
        TargetMachine targetMachine = target.createTargetMachine(triple);
        targetMachine.setAsmVerbosityDefault(true);
        targetMachine.setFunctionSections(true);
        targetMachine.setDataSections(true);
        targetMachine.getOptions().setNoFramePointerElim(true);
        File linkerO = new File(this.config.getTmpDir(), "linker.o");
        linkerO.getParentFile().mkdirs();
        BufferedOutputStream outO = null;
        try {
            outO = new BufferedOutputStream(new FileOutputStream(linkerO));
            targetMachine.emit(module, outO, CodeGenFileType.ObjectFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outO);
            throw throwable;
        }
        IOUtils.closeQuietly(outO);
        module.dispose();
        context.dispose();
        ArrayList<File> objectFiles = new ArrayList<File>();
        objectFiles.add(linkerO);
        for (Clazz clazz : linkClasses) {
            objectFiles.add(this.config.getOFile(clazz));
        }
        this.config.getTarget().build(objectFiles);
    }

    private TypeInfo buildTypeInfo(TypeInfo typeInfo, Map<ClazzInfo, TypeInfo> typeInfos) {
        if (typeInfo.error || typeInfo.classTypes != null) {
            return typeInfo;
        }
        ClazzInfo ci = typeInfo.clazz.getClazzInfo();
        ArrayList<TypeInfo> clTypeInfos = new ArrayList<TypeInfo>();
        TreeSet<TypeInfo> ifTypeInfos = new TreeSet<TypeInfo>();
        if (!ci.isInterface()) {
            if (ci.hasSuperclass()) {
                TypeInfo superTypeInfo = this.buildTypeInfo(typeInfos.get(ci.getSuperclass()), typeInfos);
                if (superTypeInfo.error) {
                    typeInfo.error = true;
                    return typeInfo;
                }
                clTypeInfos.addAll(Arrays.asList(superTypeInfo.classTypes));
                clTypeInfos.add(typeInfo);
                ifTypeInfos.addAll(Arrays.asList(superTypeInfo.interfaceTypes));
                superTypeInfo.children.add(typeInfo.clazz);
            } else {
                clTypeInfos.add(typeInfo);
            }
        }
        for (ClazzInfo ifCi : ci.getInterfaces()) {
            TypeInfo ifTypeInfo = this.buildTypeInfo(typeInfos.get(ifCi), typeInfos);
            if (ifTypeInfo.error) {
                typeInfo.error = true;
                return typeInfo;
            }
            ifTypeInfos.addAll(Arrays.asList(ifTypeInfo.interfaceTypes));
        }
        if (ci.isInterface()) {
            ifTypeInfos.add(typeInfo);
        }
        typeInfo.classTypes = EMPTY_TYPE_INFOS;
        typeInfo.interfaceTypes = EMPTY_TYPE_INFOS;
        if (!clTypeInfos.isEmpty()) {
            typeInfo.classTypes = clTypeInfos.toArray(new TypeInfo[clTypeInfos.size()]);
        }
        if (!ifTypeInfos.isEmpty()) {
            typeInfo.interfaceTypes = ifTypeInfos.toArray(new TypeInfo[ifTypeInfos.size()]);
        }
        return typeInfo;
    }

    private void buildTypeInfos(Map<ClazzInfo, TypeInfo> typeInfos) {
        for (TypeInfo typeInfo : typeInfos.values()) {
            this.buildTypeInfo(typeInfo, typeInfos);
        }
    }

    private StructureConstant createClassInfoErrorStruct(ModuleBuilder mb, ClazzInfo ci) {
        int errorType = 0;
        String errorMessage = null;
        if (!ci.isInterface() && ci.hasSuperclass()) {
            ClazzInfo superclazz = ci.getSuperclass();
            if (superclazz.isPhantom()) {
                errorType = 1;
                errorMessage = superclazz.getName();
            } else if (!Access.checkClassAccessible(superclazz, ci)) {
                errorType = 2;
                errorMessage = String.format("Attempt to access class %s from class %s", superclazz, ci);
            } else if (superclazz.isInterface()) {
                errorType = 3;
                errorMessage = String.format("class %s has interface %s as super class", ci, superclazz);
            }
        }
        if (errorType == 0) {
            for (ClazzInfo interfaze : ci.getInterfaces()) {
                if (interfaze.isPhantom()) {
                    errorType = 1;
                    errorMessage = interfaze.getName();
                    break;
                }
                if (!Access.checkClassAccessible(interfaze, ci)) {
                    errorType = 2;
                    errorMessage = String.format("Attempt to access class %s from class %s", interfaze, ci);
                    break;
                }
                if (interfaze.isInterface()) continue;
                errorType = 3;
                errorMessage = String.format("class %s tries to implement class %s as interface", ci, interfaze);
                break;
            }
        }
        if (errorType == 0) {
            for (ClazzInfo ex : ci.getCatches()) {
                if (ex == null || ex.isPhantom()) {
                    errorType = 1;
                    errorMessage = ex.getInternalName();
                    break;
                }
                if (Access.checkClassAccessible(ex, ci)) continue;
                errorType = 2;
                errorMessage = String.format("Attempt to access class %s from class %s", ex, ci);
                break;
            }
        }
        if (errorType == 0) {
            return null;
        }
        StructureConstantBuilder error = new StructureConstantBuilder();
        error.add(new NullConstant(Type.I8_PTR));
        error.add(new IntegerConstant(256));
        error.add(mb.getString(ci.getInternalName()));
        error.add(new IntegerConstant(errorType));
        error.add(mb.getString(errorMessage));
        return error.build();
    }

    private Function createCheckcast(ModuleBuilder mb, Clazz clazz, TypeInfo typeInfo) {
        Function fn = FunctionBuilder.checkcast(clazz);
        Value info = this.getInfoStruct(mb, fn, clazz);
        if (typeInfo.error) {
            Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
            fn.add(new Ret(new NullConstant(Types.OBJECT_PTR)));
        } else if (!clazz.getClazzInfo().isInterface()) {
            Value result = Functions.call(fn, (Value)Functions.CHECKCAST_CLASS, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        } else {
            Value result = Functions.call(fn, (Value)Functions.CHECKCAST_INTERFACE, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        }
        return fn;
    }

    private Function createInstanceof(ModuleBuilder mb, Clazz clazz, TypeInfo typeInfo) {
        Function fn = FunctionBuilder.instanceOf(clazz);
        Value info = this.getInfoStruct(mb, fn, clazz);
        if (typeInfo.error) {
            Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
            fn.add(new Ret(new IntegerConstant(0)));
        } else if (!clazz.getClazzInfo().isInterface()) {
            Value result = Functions.call(fn, (Value)Functions.INSTANCEOF_CLASS, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        } else {
            Value result = Functions.call(fn, (Value)Functions.INSTANCEOF_INTERFACE, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        }
        return fn;
    }

    private Function createLookup(ModuleBuilder mb, ClazzInfo ci, ClazzInfo.MethodInfo mi) {
        Function function = FunctionBuilder.lookup(ci, mi, false);
        String targetFnName = mi.isSynchronized() ? Symbols.synchronizedWrapperSymbol(ci.getInternalName(), mi.getName(), mi.getDesc()) : Symbols.methodSymbol(ci.getInternalName(), mi.getName(), mi.getDesc());
        FunctionRef fn = new FunctionRef(targetFnName, function.getType());
        if (!mb.hasSymbol(fn.getName())) {
            mb.addFunctionDeclaration(new FunctionDeclaration(fn));
        }
        Value result = Functions.tailcall(function, fn, function.getParameterRefs());
        function.add(new Ret(result));
        return function;
    }

    private Value getInfoStruct(ModuleBuilder mb, Function f, Clazz clazz) {
        return new ConstantBitcast(mb.getGlobalRef(Symbols.infoStructSymbol(clazz.getInternalName())), Type.I8_PTR_PTR);
    }

    private static class TypeInfo
    implements Comparable<TypeInfo> {
        boolean error;
        Clazz clazz;
        List<Clazz> children = new ArrayList<Clazz>();
        int id;
        TypeInfo[] classTypes;
        TypeInfo[] interfaceTypes;

        private TypeInfo() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeInfo other = (TypeInfo)obj;
            return this.id == other.id;
        }

        @Override
        public int compareTo(TypeInfo o) {
            return this.id < o.id ? -1 : (this.id == o.id ? 0 : 1);
        }
    }
}

