/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

public class Mangler {
    public static String mangleNativeMethod(String owner, String name) {
        return Mangler.mangleNativeMethod(owner, name, null);
    }

    public static String mangleNativeMethod(String owner, String name, String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(Mangler.mangleNativeString(owner));
        sb.append("_");
        sb.append(Mangler.mangleNativeString(name));
        if (desc != null && !desc.startsWith("()")) {
            sb.append("__");
            sb.append(Mangler.mangleNativeString(desc.substring(1, desc.lastIndexOf(41))));
        }
        return sb.toString();
    }

    private static String mangleNativeString(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                sb.append(c);
                continue;
            }
            if (c == '_') {
                sb.append("_1");
                continue;
            }
            if (c == ';') {
                sb.append("_2");
                continue;
            }
            if (c == '[') {
                sb.append("_3");
                continue;
            }
            if (c == '/') {
                sb.append("_");
                continue;
            }
            sb.append(String.format("_0%04x", c));
        }
        return sb.toString();
    }
}

