/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.robovm.compiler.AbstractMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.Intrinsics;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Strings;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Add;
import org.robovm.compiler.llvm.Alloca;
import org.robovm.compiler.llvm.And;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Ashr;
import org.robovm.compiler.llvm.BasicBlock;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Br;
import org.robovm.compiler.llvm.Call;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.ConstantTrunc;
import org.robovm.compiler.llvm.Fadd;
import org.robovm.compiler.llvm.Fdiv;
import org.robovm.compiler.llvm.FloatingPointConstant;
import org.robovm.compiler.llvm.FloatingPointType;
import org.robovm.compiler.llvm.Fmul;
import org.robovm.compiler.llvm.Fpext;
import org.robovm.compiler.llvm.Fptrunc;
import org.robovm.compiler.llvm.Fsub;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Icmp;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.Invoke;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.Lshr;
import org.robovm.compiler.llvm.Mul;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Or;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Sext;
import org.robovm.compiler.llvm.Shl;
import org.robovm.compiler.llvm.Sitofp;
import org.robovm.compiler.llvm.Store;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Sub;
import org.robovm.compiler.llvm.Switch;
import org.robovm.compiler.llvm.Trunc;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.llvm.Xor;
import org.robovm.compiler.llvm.Zext;
import org.robovm.compiler.trampoline.Anewarray;
import org.robovm.compiler.trampoline.Checkcast;
import org.robovm.compiler.trampoline.FieldAccessor;
import org.robovm.compiler.trampoline.GetField;
import org.robovm.compiler.trampoline.GetStatic;
import org.robovm.compiler.trampoline.Instanceof;
import org.robovm.compiler.trampoline.Invokeinterface;
import org.robovm.compiler.trampoline.Invokespecial;
import org.robovm.compiler.trampoline.Invokestatic;
import org.robovm.compiler.trampoline.Invokevirtual;
import org.robovm.compiler.trampoline.LdcClass;
import org.robovm.compiler.trampoline.Multianewarray;
import org.robovm.compiler.trampoline.New;
import org.robovm.compiler.trampoline.PutField;
import org.robovm.compiler.trampoline.PutStatic;
import org.robovm.compiler.trampoline.Trampoline;
import soot.Body;
import soot.CharType;
import soot.Immediate;
import soot.Local;
import soot.Modifier;
import soot.NullType;
import soot.PackManager;
import soot.PatchingChain;
import soot.PrimType;
import soot.RefLikeType;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.Expr;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.annotation.tags.ArrayCheckTag;
import soot.jimple.toolkits.annotation.tags.NullCheckTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.util.Chain;

public class MethodCompiler
extends AbstractMethodCompiler {
    private Function function;
    private Map<Unit, List<Trap>> trapsAt;
    private Value env;
    private ModuleBuilder moduleBuilder;
    private Variable dims;

    public MethodCompiler(Config config) {
        super(config);
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        this.function = FunctionBuilder.method(method);
        moduleBuilder.addFunction(this.function);
        this.moduleBuilder = moduleBuilder;
        this.env = this.function.getParameterRef(0);
        if (this.className.equals("java/lang/Object") && "<init>".equals(method.getName())) {
            this.compileObjectInit();
            Object firstUnit = method.getActiveBody().getUnits().getFirst();
            for (Instruction in : this.function.getBasicBlocks().get(0).getInstructions()) {
                in.attach(firstUnit);
            }
            return this.function;
        }
        this.trapsAt = new HashMap<Unit, List<Trap>>();
        Body body = method.retrieveActiveBody();
        if (method.isStatic() && !body.getUnits().getFirst().getBoxesPointingToThis().isEmpty()) {
            Object inserPoint = body.getUnits().getFirst();
            body.getUnits().getNonPatchingChain().insertBefore(Jimple.v().newNopStmt(), (Unit)inserPoint);
        }
        PackManager.v().getPack("jtp").apply(body);
        PackManager.v().getPack("jop").apply(body);
        PackManager.v().getPack("jap").apply(body);
        PatchingChain<Unit> units = body.getUnits();
        Map<Unit, List<Unit>> branchTargets = this.getBranchTargets(body);
        Map<Unit, Integer> trapHandlers = this.getTrapHandlers(body);
        HashMap<Unit, Integer> selChanges = new HashMap<Unit, Integer>();
        int multiANewArrayMaxDims = 0;
        HashSet<Local> locals = new HashSet<Local>();
        boolean emitCheckStackOverflow = false;
        for (Unit unit : units) {
            if (unit instanceof DefinitionStmt) {
                Local local;
                DefinitionStmt stmt = (DefinitionStmt)unit;
                if (stmt.getLeftOp() instanceof Local && !locals.contains(local = (Local)stmt.getLeftOp())) {
                    Type type = Types.getLocalType(local.getType());
                    Alloca alloca = new Alloca(this.function.newVariable(local.getName(), type), type);
                    alloca.attach(local);
                    this.function.add(alloca);
                    locals.add(local);
                }
                if (stmt.getRightOp() instanceof NewMultiArrayExpr) {
                    NewMultiArrayExpr expr = (NewMultiArrayExpr)stmt.getRightOp();
                    multiANewArrayMaxDims = Math.max(multiANewArrayMaxDims, expr.getSizeCount());
                }
                if (stmt.getRightOp() instanceof InvokeExpr) {
                    emitCheckStackOverflow = true;
                }
            }
            if (!(unit instanceof InvokeStmt)) continue;
            emitCheckStackOverflow = true;
        }
        this.dims = null;
        if (multiANewArrayMaxDims > 0) {
            this.dims = this.function.newVariable("dims", new PointerType(new ArrayType(multiANewArrayMaxDims, Type.I32)));
            this.function.add(new Alloca(this.dims, new ArrayType(multiANewArrayMaxDims, Type.I32)));
        }
        if (emitCheckStackOverflow) {
            this.call(Functions.CHECK_STACK_OVERFLOW, new Value[0]);
        }
        VariableRef trycatchContext = null;
        if (!body.getTraps().isEmpty()) {
            ArrayList<List<Trap>> recordedTraps = new ArrayList<List<Trap>>();
            for (Unit unit : units) {
                HashSet<Unit> hashSet = new HashSet<Unit>();
                if (units.getFirst() != unit && units.getPredOf(unit).fallsThrough()) {
                    hashSet.add(units.getPredOf(unit));
                }
                if (branchTargets.keySet().contains(unit)) {
                    hashSet.addAll((Collection)branchTargets.get(unit));
                }
                if (unit != units.getFirst() && !trapHandlers.containsKey(unit) && !this.trapsDiffer(unit, hashSet)) continue;
                List<Trap> traps = this.getTrapsAt(unit);
                if (traps.isEmpty()) {
                    selChanges.put(unit, 0);
                    continue;
                }
                int index = recordedTraps.indexOf(traps);
                if (index == -1) {
                    index = recordedTraps.size();
                    recordedTraps.add(traps);
                }
                selChanges.put(unit, index + 1);
            }
            StructureConstantBuilder landingPadsPtrs = new StructureConstantBuilder();
            for (List list : recordedTraps) {
                StructureConstantBuilder landingPads = new StructureConstantBuilder();
                for (Trap trap : list) {
                    SootClass exClass = trap.getException();
                    StructureConstantBuilder landingPad = new StructureConstantBuilder();
                    if ("java.lang.Throwable".equals(exClass.getName()) || exClass.isPhantom()) {
                        landingPad.add(new NullConstant(Type.I8_PTR));
                    } else {
                        this.catches.add(Types.getInternalName(exClass));
                        Global g = new Global(Symbols.infoStructSymbol(Types.getInternalName(exClass)), Type.I8_PTR, true);
                        if (!moduleBuilder.hasSymbol(g.getName())) {
                            moduleBuilder.addGlobal(g);
                        }
                        landingPad.add(g.ref());
                    }
                    landingPad.add(new IntegerConstant(trapHandlers.get(trap.getHandlerUnit()) + 1));
                    landingPads.add(landingPad.build());
                }
                landingPads.add(new StructureConstantBuilder().add(new NullConstant(Type.I8_PTR)).add(new IntegerConstant(0)).build());
                Global g = moduleBuilder.newGlobal(landingPads.build(), true);
                landingPadsPtrs.add(new ConstantBitcast(g.ref(), Type.I8_PTR));
            }
            Global g = moduleBuilder.newGlobal(landingPadsPtrs.build(), true);
            Variable variable = this.function.newVariable(Types.TRYCATCH_CONTEXT_PTR);
            Variable bcCtx = this.function.newVariable(Types.BC_TRYCATCH_CONTEXT_PTR);
            this.function.add(new Alloca(bcCtx, Types.BC_TRYCATCH_CONTEXT));
            Variable selPtr = this.function.newVariable(new PointerType(Type.I32));
            this.function.add(new Getelementptr(selPtr, (Value)bcCtx.ref(), 0, 0, 1));
            this.function.add(new Store(new IntegerConstant(0), selPtr.ref()));
            Variable bcCtxLandingPadsPtr = this.function.newVariable(Type.I8_PTR_PTR);
            this.function.add(new Getelementptr(bcCtxLandingPadsPtr, (Value)bcCtx.ref(), 0, 1));
            this.function.add(new Store(new ConstantBitcast(g.ref(), Type.I8_PTR), bcCtxLandingPadsPtr.ref()));
            this.function.add(new Bitcast(variable, bcCtx.ref(), Types.TRYCATCH_CONTEXT_PTR));
            trycatchContext = variable.ref();
            Value result = this.call(Functions.RVM_TRYCATCH_ENTER, this.env, trycatchContext);
            TreeMap<IntegerConstant, BasicBlockRef> alt = new TreeMap<IntegerConstant, BasicBlockRef>();
            for (Map.Entry<Unit, Integer> entry : trapHandlers.entrySet()) {
                alt.put(new IntegerConstant(entry.getValue() + 1), this.function.newBasicBlockRef(new Label(entry.getKey())));
            }
            this.function.add(new Switch(result, this.function.newBasicBlockRef(new Label(units.getFirst())), alt));
            if (!branchTargets.containsKey(units.getFirst())) {
                this.function.newBasicBlock(new Label(units.getFirst()));
            }
        }
        if ("<clinit>".equals(method.getName())) {
            this.initializeClassFields();
        }
        for (Unit unit : units) {
            if (branchTargets.containsKey(unit) || trapHandlers.containsKey(unit)) {
                Instruction instruction;
                BasicBlock oldBlock = this.function.getCurrentBasicBlock();
                this.function.newBasicBlock(new Label(unit));
                if (!(oldBlock == null || (instruction = oldBlock.last()) != null && MethodCompiler.isTerminator(instruction))) {
                    oldBlock.add(new Br(this.function.newBasicBlockRef(new Label(unit))));
                }
            }
            if (selChanges.containsKey(unit)) {
                int sel = (Integer)selChanges.get(unit);
                Variable variable = this.function.newVariable(new PointerType(Type.I32));
                this.function.add(new Getelementptr(variable, trycatchContext, 0, 1)).attach(unit);
                this.function.add(new Store(new IntegerConstant(sel), variable.ref())).attach(unit);
            }
            if (unit instanceof DefinitionStmt) {
                this.assign((DefinitionStmt)unit);
                continue;
            }
            if (unit instanceof ReturnStmt) {
                if (!body.getTraps().isEmpty()) {
                    Functions.trycatchLeave(this.function);
                }
                this.return_((ReturnStmt)unit);
                continue;
            }
            if (unit instanceof ReturnVoidStmt) {
                if (!body.getTraps().isEmpty()) {
                    Functions.trycatchLeave(this.function);
                }
                this.returnVoid((ReturnVoidStmt)unit);
                continue;
            }
            if (unit instanceof IfStmt) {
                this.if_((IfStmt)unit);
                continue;
            }
            if (unit instanceof LookupSwitchStmt) {
                this.lookupSwitch((LookupSwitchStmt)unit);
                continue;
            }
            if (unit instanceof TableSwitchStmt) {
                this.tableSwitch((TableSwitchStmt)unit);
                continue;
            }
            if (unit instanceof GotoStmt) {
                this.goto_((GotoStmt)unit);
                continue;
            }
            if (unit instanceof ThrowStmt) {
                this.throw_((ThrowStmt)unit);
                continue;
            }
            if (unit instanceof InvokeStmt) {
                this.invoke((InvokeStmt)unit);
                continue;
            }
            if (unit instanceof EnterMonitorStmt) {
                this.enterMonitor((EnterMonitorStmt)unit);
                continue;
            }
            if (unit instanceof ExitMonitorStmt) {
                this.exitMonitor((ExitMonitorStmt)unit);
                continue;
            }
            if (unit instanceof NopStmt) continue;
            throw new IllegalArgumentException("Unknown Unit type: " + unit.getClass());
        }
        return this.function;
    }

    private void compileObjectInit() {
        this.call(Functions.REGISTER_FINALIZABLE, this.env, this.function.getParameterRef(1));
        this.function.add(new Ret());
    }

    private boolean trapsDiffer(Unit unit, Collection<Unit> incomingUnits) {
        List<Trap> traps = this.getTrapsAt(unit);
        for (Unit incomingUnit : incomingUnits) {
            if (traps.equals(this.getTrapsAt(incomingUnit))) continue;
            return true;
        }
        return false;
    }

    private Map<Unit, List<Unit>> getBranchTargets(Body body) {
        HashMap<Unit, List<Unit>> result = new HashMap<Unit, List<Unit>>();
        for (Unit unit : body.getUnits()) {
            if (!unit.branches()) continue;
            ArrayList<Unit> targetUnits = new ArrayList<Unit>();
            for (UnitBox ub : unit.getUnitBoxes()) {
                targetUnits.add(ub.getUnit());
            }
            if (unit.fallsThrough()) {
                targetUnits.add(body.getUnits().getSuccOf(unit));
            }
            for (Unit targetUnit : targetUnits) {
                ArrayList<Unit> sourceUnits = (ArrayList<Unit>)result.get(targetUnit);
                if (sourceUnits == null) {
                    sourceUnits = new ArrayList<Unit>();
                    result.put(targetUnit, sourceUnits);
                }
                sourceUnits.add(unit);
            }
        }
        return result;
    }

    private Map<Unit, Integer> getTrapHandlers(Body body) {
        HashMap<Unit, Integer> trapHandlers = new HashMap<Unit, Integer>();
        for (Trap trap : body.getTraps()) {
            Unit endUnit;
            Unit beginUnit = trap.getBeginUnit();
            if (beginUnit == (endUnit = trap.getEndUnit()) || trapHandlers.containsKey(trap.getHandlerUnit())) continue;
            trapHandlers.put(trap.getHandlerUnit(), trapHandlers.size());
        }
        return trapHandlers;
    }

    private void initializeClassFields() {
        for (SootField field : this.sootMethod.getDeclaringClass().getFields()) {
            if (!field.isStatic()) continue;
            for (Tag tag : field.getTags()) {
                Value value = null;
                if (tag instanceof DoubleConstantValueTag) {
                    DoubleConstantValueTag dtag = (DoubleConstantValueTag)tag;
                    value = new FloatingPointConstant(dtag.getDoubleValue());
                } else if (tag instanceof FloatConstantValueTag) {
                    FloatConstantValueTag ftag = (FloatConstantValueTag)tag;
                    value = new FloatingPointConstant(ftag.getFloatValue());
                } else if (tag instanceof IntegerConstantValueTag) {
                    IntegerConstantValueTag itag = (IntegerConstantValueTag)tag;
                    value = new IntegerConstant(itag.getIntValue());
                    IntegerType type = (IntegerType)Types.getType(field.getType());
                    if (type.getBits() < 32) {
                        value = new ConstantTrunc((Constant)value, type);
                    }
                } else if (tag instanceof LongConstantValueTag) {
                    LongConstantValueTag ltag = (LongConstantValueTag)tag;
                    value = new IntegerConstant(ltag.getLongValue());
                } else if (tag instanceof StringConstantValueTag) {
                    String s = ((StringConstantValueTag)tag).getStringValue();
                    value = this.call(this.ldcString(s), this.env);
                }
                if (value == null) continue;
                FunctionRef fn = FunctionBuilder.setter(field).ref();
                this.call(fn, this.env, value);
            }
        }
    }

    private static boolean isTerminator(Instruction instr) {
        return instr instanceof Ret || instr instanceof Br || instr instanceof Invoke || instr instanceof Unreachable || instr instanceof Switch;
    }

    private Value immediate(Unit unit, Immediate v) {
        if (v instanceof Local) {
            Local local = (Local)v;
            Type type = Types.getLocalType(v.getType());
            VariableRef var = new VariableRef(local.getName(), new PointerType(type));
            Variable tmp = this.function.newVariable(type);
            this.function.add(new Load(tmp, var, !this.sootMethod.getActiveBody().getTraps().isEmpty())).attach(unit);
            return new VariableRef(tmp);
        }
        if (v instanceof IntConstant) {
            return new IntegerConstant(((IntConstant)v).value);
        }
        if (v instanceof LongConstant) {
            return new IntegerConstant(((LongConstant)v).value);
        }
        if (v instanceof FloatConstant) {
            return new FloatingPointConstant(((FloatConstant)v).value);
        }
        if (v instanceof DoubleConstant) {
            return new FloatingPointConstant(((DoubleConstant)v).value);
        }
        if (v instanceof soot.jimple.NullConstant) {
            return new NullConstant(Types.OBJECT_PTR);
        }
        if (v instanceof StringConstant) {
            String s = ((StringConstant)v).value;
            return this.call(unit, (Value)this.ldcString(s), this.env);
        }
        if (v instanceof ClassConstant) {
            String targetClassName = ((ClassConstant)v).getValue();
            if (Types.isArray(targetClassName) && Types.isPrimitiveComponentType(targetClassName)) {
                String primitiveDesc = targetClassName.substring(1);
                Variable result = this.function.newVariable(Types.OBJECT_PTR);
                this.function.add(new Load(result, new ConstantBitcast(new GlobalRef("array_" + primitiveDesc, Types.CLASS_PTR), new PointerType(Types.OBJECT_PTR)))).attach(unit);
                return result.ref();
            }
            FunctionRef fn = null;
            if (targetClassName.equals(this.className)) {
                fn = FunctionBuilder.ldcInternal(this.sootMethod.getDeclaringClass()).ref();
            } else {
                LdcClass trampoline = new LdcClass(this.className, ((ClassConstant)v).getValue());
                this.trampolines.add(trampoline);
                fn = trampoline.getFunctionRef();
            }
            return this.call(unit, (Value)fn, this.env);
        }
        throw new IllegalArgumentException("Unknown Immediate type: " + v.getClass());
    }

    private FunctionRef ldcString(String s) {
        byte[] modUtf8 = Strings.stringToModifiedUtf8Z(s);
        FunctionRef fref = new FunctionRef(Symbols.ldcStringSymbol(modUtf8), new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        if (this.moduleBuilder.hasSymbol(fref.getName())) {
            return fref;
        }
        Global g = new Global(Symbols.ldcStringPtrSymbol(modUtf8), Linkage.weak, new NullConstant(Types.OBJECT_PTR));
        this.moduleBuilder.addGlobal(g);
        Function f = new FunctionBuilder(fref).linkage(Linkage.weak).build();
        this.moduleBuilder.addFunction(f);
        Value result = Functions.call(f, (Value)Functions.BC_LDC_STRING, f.getParameterRef(0), g.ref(), this.moduleBuilder.getString(s), new IntegerConstant(s.length()));
        f.add(new Ret(result));
        return fref;
    }

    private Value widenToI32Value(Unit unit, Value value, boolean unsigned) {
        Type type = value.getType();
        if (type instanceof IntegerType && ((IntegerType)type).getBits() < 32) {
            Variable t = this.function.newVariable(Type.I32);
            if (unsigned) {
                this.function.add(new Zext(t, value, Type.I32)).attach(unit);
            } else {
                this.function.add(new Sext(t, value, Type.I32)).attach(unit);
            }
            return t.ref();
        }
        return value;
    }

    private Value narrowFromI32Value(Unit unit, Type type, Value value) {
        if (value.getType() == Type.I32 && ((IntegerType)type).getBits() < 32) {
            Variable t = this.function.newVariable(type);
            this.function.add(new Trunc(t, value, type)).attach(unit);
            value = t.ref();
        }
        return value;
    }

    private Value call(Value fn, Value ... args) {
        return this.call((Unit)null, fn, args);
    }

    private Value call(Unit unit, Value fn, Value ... args) {
        Variable result = null;
        Type returnType = ((FunctionType)fn.getType()).getReturnType();
        if (returnType != Type.VOID) {
            result = this.function.newVariable(returnType);
        }
        this.function.add(new Call(result, fn, args)).attach(unit);
        return result == null ? null : result.ref();
    }

    private boolean canAccessDirectly(FieldRef ref) {
        SootClass sootClass = this.sootMethod.getDeclaringClass();
        SootFieldRef fieldRef = ref.getFieldRef();
        if (!fieldRef.declaringClass().equals(sootClass)) {
            return false;
        }
        try {
            SootField field = sootClass.getField(fieldRef.name(), fieldRef.type());
            if (field.isStatic()) {
                return ref instanceof StaticFieldRef;
            }
            return ref instanceof InstanceFieldRef;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean canCallDirectly(InvokeExpr expr) {
        if (expr instanceof InterfaceInvokeExpr) {
            return false;
        }
        SootClass sootClass = this.sootMethod.getDeclaringClass();
        SootMethodRef methodRef = expr.getMethodRef();
        if (!methodRef.declaringClass().equals(sootClass)) {
            return false;
        }
        try {
            SootMethod method = sootClass.getMethod(methodRef.name(), methodRef.parameterTypes(), methodRef.returnType());
            if (method.isAbstract()) {
                return false;
            }
            if (method.isStatic()) {
                return expr instanceof StaticInvokeExpr;
            }
            if (expr instanceof SpecialInvokeExpr) {
                return true;
            }
            if (expr instanceof VirtualInvokeExpr) {
                return Modifier.isFinal(sootClass.getModifiers()) || Modifier.isFinal(method.getModifiers()) || method.isPrivate();
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private Value invokeExpr(Stmt stmt, InvokeExpr expr) {
        SootMethodRef methodRef = expr.getMethodRef();
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(this.env);
        if (!(expr instanceof StaticInvokeExpr)) {
            Value base = this.immediate(stmt, (Immediate)((InstanceInvokeExpr)expr).getBase());
            this.checkNull(stmt, base);
            args.add(base);
        }
        int i = 0;
        for (soot.Value sootArg : expr.getArgs()) {
            Value arg = this.immediate(stmt, (Immediate)sootArg);
            args.add(this.narrowFromI32Value(stmt, Types.getType(methodRef.parameterType(i)), arg));
            ++i;
        }
        Value result = null;
        FunctionRef functionRef = Intrinsics.getIntrinsic(this.sootMethod, stmt, expr);
        if (functionRef == null) {
            if (this.canCallDirectly(expr)) {
                SootMethod method = this.sootMethod.getDeclaringClass().getMethod(methodRef.name(), methodRef.parameterTypes(), methodRef.returnType());
                functionRef = method.isSynchronized() ? FunctionBuilder.synchronizedWrapper(method).ref() : FunctionBuilder.method(method).ref();
            } else {
                org.robovm.compiler.trampoline.Invoke trampoline = null;
                String targetClassName = Types.getInternalName(methodRef.declaringClass());
                String methodName = methodRef.name();
                String methodDesc = Types.getDescriptor(methodRef);
                if (expr instanceof SpecialInvokeExpr) {
                    soot.Type runtimeType = ((SpecialInvokeExpr)expr).getBase().getType();
                    String runtimeClassName = runtimeType == NullType.v() ? targetClassName : Types.getInternalName(runtimeType);
                    trampoline = new Invokespecial(this.className, targetClassName, methodName, methodDesc, runtimeClassName);
                } else if (expr instanceof StaticInvokeExpr) {
                    trampoline = new Invokestatic(this.className, targetClassName, methodName, methodDesc);
                } else if (expr instanceof VirtualInvokeExpr) {
                    soot.Type runtimeType = ((VirtualInvokeExpr)expr).getBase().getType();
                    String runtimeClassName = runtimeType == NullType.v() ? targetClassName : Types.getInternalName(runtimeType);
                    trampoline = new Invokevirtual(this.className, targetClassName, methodName, methodDesc, runtimeClassName);
                } else if (expr instanceof InterfaceInvokeExpr) {
                    trampoline = new Invokeinterface(this.className, targetClassName, methodName, methodDesc);
                }
                this.trampolines.add(trampoline);
                functionRef = trampoline.getFunctionRef();
            }
        }
        if ((result = this.call(stmt, (Value)functionRef, args.toArray(new Value[0]))) != null) {
            return this.widenToI32Value(stmt, result, methodRef.returnType().equals(CharType.v()));
        }
        return null;
    }

    private void checkNull(Stmt stmt, Value base) {
        NullCheckTag nullCheckTag = (NullCheckTag)stmt.getTag("NullCheckTag");
        if (nullCheckTag == null || nullCheckTag.needCheck()) {
            this.call(stmt, (Value)Functions.CHECK_NULL, this.env, base);
        }
    }

    private void checkBounds(Stmt stmt, Value base, Value index) {
        ArrayCheckTag arrayCheckTag = (ArrayCheckTag)stmt.getTag("ArrayCheckTag");
        if (arrayCheckTag == null || arrayCheckTag.isCheckLower()) {
            this.call(stmt, (Value)Functions.CHECK_LOWER, this.env, base, index);
        }
        if (arrayCheckTag == null || arrayCheckTag.isCheckUpper()) {
            this.call(stmt, (Value)Functions.CHECK_UPPER, this.env, base, index);
        }
    }

    private List<Trap> getTrapsAt(Unit u) {
        List<Trap> result = this.trapsAt.get(u);
        if (result == null) {
            Body body = this.sootMethod.getActiveBody();
            Chain<Trap> traps = body.getTraps();
            if (traps.isEmpty()) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList<Trap>();
                PatchingChain<Unit> units = body.getUnits();
                for (Trap trap : traps) {
                    Unit endUnit;
                    Unit beginUnit = trap.getBeginUnit();
                    if (beginUnit == (endUnit = trap.getEndUnit()) || u == endUnit || u != beginUnit && (!units.follows(u, beginUnit) || !units.follows(endUnit, u))) continue;
                    result.add(trap);
                }
            }
            this.trapsAt.put(u, result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assign(DefinitionStmt stmt) {
        Trampoline trampoline;
        String targetClassName;
        FieldAccessor trampoline2;
        Ref ref;
        Value result;
        soot.Value rightOp = stmt.getRightOp();
        if (rightOp instanceof Immediate) {
            Immediate immediate = (Immediate)rightOp;
            result = this.immediate(stmt, immediate);
        } else if (rightOp instanceof ThisRef) {
            result = this.function.getParameterRef(1);
        } else if (rightOp instanceof ParameterRef) {
            ref = (ParameterRef)rightOp;
            int index = (this.sootMethod.isStatic() ? 1 : 2) + ((ParameterRef)ref).getIndex();
            VariableRef p = new VariableRef("p" + index, Types.getType(((ParameterRef)ref).getType()));
            result = this.widenToI32Value(stmt, p, Types.isUnsigned(((ParameterRef)ref).getType()));
        } else if (rightOp instanceof CaughtExceptionRef) {
            result = this.call(stmt, (Value)Functions.BC_EXCEPTION_CLEAR, this.env);
        } else if (rightOp instanceof ArrayRef) {
            ref = (ArrayRef)rightOp;
            VariableRef base = (VariableRef)this.immediate(stmt, (Immediate)ref.getBase());
            if (ref.getType() instanceof NullType) {
                this.checkNull(stmt, base);
                return;
            }
            Value index = this.immediate(stmt, (Immediate)ref.getIndex());
            this.checkNull(stmt, base);
            this.checkBounds(stmt, base, index);
            result = this.call(stmt, (Value)Functions.getArrayLoad(ref.getType()), base, index);
            result = this.widenToI32Value(stmt, result, Types.isUnsigned(ref.getType()));
        } else if (rightOp instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)rightOp;
            Value base = this.immediate(stmt, (Immediate)ref.getBase());
            this.checkNull(stmt, base);
            FunctionRef fn = null;
            if (this.canAccessDirectly((FieldRef)ref)) {
                fn = new FunctionRef(Symbols.getterSymbol(ref.getFieldRef()), new FunctionType(Types.getType(ref.getType()), Types.ENV_PTR, Types.OBJECT_PTR));
            } else {
                soot.Type runtimeType = ref.getBase().getType();
                String string = Types.getInternalName(ref.getFieldRef().declaringClass());
                String runtimeClassName = runtimeType == NullType.v() ? string : Types.getInternalName(runtimeType);
                trampoline2 = new GetField(this.className, string, ref.getFieldRef().name(), Types.getDescriptor(ref.getFieldRef().type()), runtimeClassName);
                this.trampolines.add(trampoline2);
                fn = trampoline2.getFunctionRef();
            }
            result = this.call(stmt, (Value)fn, this.env, base);
            result = this.widenToI32Value(stmt, result, Types.isUnsigned(ref.getType()));
        } else if (rightOp instanceof StaticFieldRef) {
            ref = (StaticFieldRef)rightOp;
            FunctionRef fn = Intrinsics.getIntrinsic(this.sootMethod, stmt);
            if (fn == null) {
                if (this.canAccessDirectly((FieldRef)ref)) {
                    fn = new FunctionRef(Symbols.getterSymbol(((StaticFieldRef)ref).getFieldRef()), new FunctionType(Types.getType(((StaticFieldRef)ref).getType()), Types.ENV_PTR));
                } else {
                    targetClassName = Types.getInternalName(((StaticFieldRef)ref).getFieldRef().declaringClass());
                    trampoline = new GetStatic(this.className, targetClassName, ((StaticFieldRef)ref).getFieldRef().name(), Types.getDescriptor(((StaticFieldRef)ref).getFieldRef().type()));
                    this.trampolines.add(trampoline);
                    fn = trampoline.getFunctionRef();
                }
            }
            result = this.call(stmt, (Value)fn, this.env);
            result = this.widenToI32Value(stmt, result, Types.isUnsigned(((StaticFieldRef)ref).getType()));
        } else {
            Value op;
            FunctionRef f;
            Expr expr;
            if (!(rightOp instanceof Expr)) throw new IllegalArgumentException("Unknown type for rightOp: " + rightOp.getClass());
            if (rightOp instanceof BinopExpr) {
                expr = (BinopExpr)rightOp;
                Type rightType = Types.getLocalType(expr.getType());
                Variable resultVar = this.function.newVariable(rightType);
                result = resultVar.ref();
                Value op1 = this.immediate(stmt, (Immediate)expr.getOp1());
                Value value = this.immediate(stmt, (Immediate)expr.getOp2());
                if (rightOp instanceof AddExpr) {
                    if (rightType instanceof IntegerType) {
                        this.function.add(new Add(resultVar, op1, value)).attach(stmt);
                    } else {
                        this.function.add(new Fadd(resultVar, op1, value)).attach(stmt);
                    }
                } else if (rightOp instanceof AndExpr) {
                    this.function.add(new And(resultVar, op1, value)).attach(stmt);
                } else if (rightOp instanceof CmpExpr) {
                    Variable t1 = this.function.newVariable(Type.I1);
                    Variable t2 = this.function.newVariable(Type.I1);
                    Variable t3 = this.function.newVariable(resultVar.getType());
                    Variable t4 = this.function.newVariable(resultVar.getType());
                    this.function.add(new Icmp(t1, Icmp.Condition.slt, op1, value)).attach(stmt);
                    this.function.add(new Icmp(t2, Icmp.Condition.sgt, op1, value)).attach(stmt);
                    this.function.add(new Zext(t3, new VariableRef(t1), resultVar.getType())).attach(stmt);
                    this.function.add(new Zext(t4, new VariableRef(t2), resultVar.getType())).attach(stmt);
                    this.function.add(new Sub(resultVar, new VariableRef(t4), new VariableRef(t3))).attach(stmt);
                } else if (rightOp instanceof DivExpr) {
                    if (rightType instanceof IntegerType) {
                        f = rightType == Type.I64 ? Functions.LDIV : Functions.IDIV;
                        result = this.call(stmt, (Value)f, this.env, op1, value);
                    } else {
                        this.function.add(new Fdiv(resultVar, op1, value)).attach(stmt);
                    }
                } else if (rightOp instanceof MulExpr) {
                    if (rightType instanceof IntegerType) {
                        this.function.add(new Mul(resultVar, op1, value)).attach(stmt);
                    } else {
                        this.function.add(new Fmul(resultVar, op1, value)).attach(stmt);
                    }
                } else if (rightOp instanceof OrExpr) {
                    this.function.add(new Or(resultVar, op1, value)).attach(stmt);
                } else if (rightOp instanceof RemExpr) {
                    if (rightType instanceof IntegerType) {
                        f = rightType == Type.I64 ? Functions.LREM : Functions.IREM;
                        result = this.call(stmt, (Value)f, this.env, op1, value);
                    } else {
                        f = rightType == Type.DOUBLE ? Functions.DREM : Functions.FREM;
                        result = this.call(stmt, (Value)f, this.env, op1, value);
                    }
                } else if (rightOp instanceof ShlExpr || rightOp instanceof ShrExpr || rightOp instanceof UshrExpr) {
                    IntegerType type = (IntegerType)op1.getType();
                    int bits = type.getBits();
                    Variable t = this.function.newVariable(value.getType());
                    this.function.add(new And(t, value, new IntegerConstant(bits - 1, (IntegerType)value.getType()))).attach(stmt);
                    VariableRef shift = t.ref();
                    if (((IntegerType)((Value)shift).getType()).getBits() < bits) {
                        Variable tmp = this.function.newVariable(type);
                        this.function.add(new Zext(tmp, shift, type)).attach(stmt);
                        shift = tmp.ref();
                    }
                    if (rightOp instanceof ShlExpr) {
                        this.function.add(new Shl(resultVar, op1, shift)).attach(stmt);
                    } else if (rightOp instanceof ShrExpr) {
                        this.function.add(new Ashr(resultVar, op1, shift)).attach(stmt);
                    } else {
                        this.function.add(new Lshr(resultVar, op1, shift)).attach(stmt);
                    }
                } else if (rightOp instanceof SubExpr) {
                    if (rightType instanceof IntegerType) {
                        this.function.add(new Sub(resultVar, op1, value)).attach(stmt);
                    } else {
                        this.function.add(new Fsub(resultVar, op1, value)).attach(stmt);
                    }
                } else if (rightOp instanceof XorExpr) {
                    this.function.add(new Xor(resultVar, op1, value)).attach(stmt);
                } else if (rightOp instanceof XorExpr) {
                    this.function.add(new Xor(resultVar, op1, value)).attach(stmt);
                } else if (rightOp instanceof CmplExpr) {
                    f = op1.getType() == Type.FLOAT ? Functions.FCMPL : Functions.DCMPL;
                    this.function.add(new Call(resultVar, (Value)f, op1, value)).attach(stmt);
                } else {
                    if (!(rightOp instanceof CmpgExpr)) throw new IllegalArgumentException("Unknown type for rightOp: " + rightOp.getClass());
                    f = op1.getType() == Type.FLOAT ? Functions.FCMPG : Functions.DCMPG;
                    this.function.add(new Call(resultVar, (Value)f, op1, value)).attach(stmt);
                }
            } else if (rightOp instanceof CastExpr) {
                op = this.immediate(stmt, (Immediate)((CastExpr)rightOp).getOp());
                soot.Type sootTargetType = ((CastExpr)rightOp).getCastType();
                soot.Type sootSourceType = ((CastExpr)rightOp).getOp().getType();
                if (sootTargetType instanceof PrimType) {
                    Variable v;
                    Type targetType = Types.getType(sootTargetType);
                    Type type = Types.getType(sootSourceType);
                    if (targetType instanceof IntegerType && type instanceof IntegerType) {
                        IntegerType toType = (IntegerType)targetType;
                        IntegerType fromType = (IntegerType)op.getType();
                        Variable v2 = this.function.newVariable(toType);
                        if (fromType.getBits() < toType.getBits()) {
                            if (Types.isUnsigned(sootSourceType)) {
                                this.function.add(new Zext(v2, op, toType)).attach(stmt);
                            } else {
                                this.function.add(new Sext(v2, op, toType)).attach(stmt);
                            }
                        } else if (fromType.getBits() == toType.getBits()) {
                            this.function.add(new Bitcast(v2, op, toType)).attach(stmt);
                        } else {
                            this.function.add(new Trunc(v2, op, toType)).attach(stmt);
                        }
                        result = this.widenToI32Value(stmt, v2.ref(), Types.isUnsigned(sootTargetType));
                    } else if (targetType instanceof FloatingPointType && type instanceof IntegerType) {
                        v = this.function.newVariable(targetType);
                        this.function.add(new Sitofp(v, op, targetType)).attach(stmt);
                        result = v.ref();
                    } else if (targetType instanceof FloatingPointType && type instanceof FloatingPointType) {
                        v = this.function.newVariable(targetType);
                        if (targetType == Type.FLOAT && type == Type.DOUBLE) {
                            this.function.add(new Fptrunc(v, op, targetType)).attach(stmt);
                        } else if (targetType == Type.DOUBLE && type == Type.FLOAT) {
                            this.function.add(new Fpext(v, op, targetType)).attach(stmt);
                        } else {
                            this.function.add(new Bitcast(v, op, targetType)).attach(stmt);
                        }
                        result = v.ref();
                    } else {
                        f = null;
                        if (targetType == Type.I32 && type == Type.FLOAT) {
                            f = Functions.F2I;
                        } else if (targetType == Type.I64 && type == Type.FLOAT) {
                            f = Functions.F2L;
                        } else if (targetType == Type.I32 && type == Type.DOUBLE) {
                            f = Functions.D2I;
                        } else {
                            if (targetType != Type.I64 || type != Type.DOUBLE) throw new IllegalArgumentException();
                            f = Functions.D2L;
                        }
                        Variable v3 = this.function.newVariable(targetType);
                        this.function.add(new Call(v3, (Value)f, op)).attach(stmt);
                        result = v3.ref();
                    }
                } else if (sootTargetType instanceof soot.ArrayType && ((soot.ArrayType)sootTargetType).getElementType() instanceof PrimType) {
                    soot.Type primType = ((soot.ArrayType)sootTargetType).getElementType();
                    GlobalRef globalRef = new GlobalRef("array_" + Types.getDescriptor(primType), Types.CLASS_PTR);
                    Variable arrayClass = this.function.newVariable(Types.CLASS_PTR);
                    this.function.add(new Load(arrayClass, globalRef)).attach(stmt);
                    result = this.call(stmt, (Value)Functions.CHECKCAST_PRIM_ARRAY, this.env, arrayClass.ref(), op);
                } else {
                    String targetClassName2 = Types.getInternalName(sootTargetType);
                    Checkcast checkcast = new Checkcast(this.className, targetClassName2);
                    this.trampolines.add(checkcast);
                    result = this.call(stmt, (Value)checkcast.getFunctionRef(), this.env, op);
                }
            } else if (rightOp instanceof InstanceOfExpr) {
                op = this.immediate(stmt, (Immediate)((InstanceOfExpr)rightOp).getOp());
                soot.Type checkType = ((InstanceOfExpr)rightOp).getCheckType();
                if (checkType instanceof soot.ArrayType && ((soot.ArrayType)checkType).getElementType() instanceof PrimType) {
                    soot.Type primType = ((soot.ArrayType)checkType).getElementType();
                    GlobalRef arrayClassPtr = new GlobalRef("array_" + Types.getDescriptor(primType), Types.CLASS_PTR);
                    Variable variable = this.function.newVariable(Types.CLASS_PTR);
                    this.function.add(new Load(variable, arrayClassPtr)).attach(stmt);
                    result = this.call(stmt, (Value)Functions.INSTANCEOF_PRIM_ARRAY, this.env, variable.ref(), op);
                } else {
                    targetClassName = Types.getInternalName(checkType);
                    trampoline = new Instanceof(this.className, targetClassName);
                    this.trampolines.add(trampoline);
                    result = this.call(stmt, (Value)trampoline.getFunctionRef(), this.env, op);
                }
            } else if (rightOp instanceof NewExpr) {
                String targetClassName3 = Types.getInternalName(((NewExpr)rightOp).getBaseType());
                FunctionRef fn = null;
                if (targetClassName3.equals(this.className)) {
                    fn = FunctionBuilder.allocator(this.sootMethod.getDeclaringClass()).ref();
                } else {
                    New trampoline3 = new New(this.className, targetClassName3);
                    this.trampolines.add(trampoline3);
                    fn = trampoline3.getFunctionRef();
                }
                result = this.call(stmt, (Value)fn, this.env);
            } else if (rightOp instanceof NewArrayExpr) {
                expr = (NewArrayExpr)rightOp;
                Value size = this.immediate(stmt, (Immediate)expr.getSize());
                if (expr.getBaseType() instanceof PrimType) {
                    result = this.call(stmt, (Value)Functions.getNewArray(expr.getBaseType()), this.env, size);
                } else {
                    targetClassName = Types.getInternalName(expr.getType());
                    trampoline = new Anewarray(this.className, targetClassName);
                    this.trampolines.add(trampoline);
                    result = this.call(stmt, (Value)trampoline.getFunctionRef(), this.env, size);
                }
            } else if (rightOp instanceof NewMultiArrayExpr) {
                expr = (NewMultiArrayExpr)rightOp;
                if (expr.getBaseType().numDimensions == 1 && expr.getBaseType().getElementType() instanceof PrimType) {
                    Value size = this.immediate(stmt, (Immediate)expr.getSize(0));
                    result = this.call(stmt, (Value)Functions.getNewArray(expr.getBaseType().getElementType()), this.env, size);
                } else {
                    int i = 0;
                    while (i < expr.getSizeCount()) {
                        Value size = this.immediate(stmt, (Immediate)expr.getSize(i));
                        Variable ptr = this.function.newVariable(new PointerType(Type.I32));
                        this.function.add(new Getelementptr(ptr, (Value)this.dims.ref(), 0, i++)).attach(stmt);
                        this.function.add(new Store(size, ptr.ref())).attach(stmt);
                    }
                    Variable dimsI32 = this.function.newVariable(new PointerType(Type.I32));
                    this.function.add(new Bitcast(dimsI32, this.dims.ref(), dimsI32.getType())).attach(stmt);
                    targetClassName = Types.getInternalName(expr.getType());
                    trampoline = new Multianewarray(this.className, targetClassName);
                    this.trampolines.add(trampoline);
                    result = this.call(stmt, (Value)trampoline.getFunctionRef(), this.env, new IntegerConstant(expr.getSizeCount()), dimsI32.ref());
                }
            } else if (rightOp instanceof InvokeExpr) {
                result = this.invokeExpr(stmt, (InvokeExpr)rightOp);
            } else if (rightOp instanceof LengthExpr) {
                op = this.immediate(stmt, (Immediate)((LengthExpr)rightOp).getOp());
                this.checkNull(stmt, op);
                Variable v = this.function.newVariable(Type.I32);
                this.function.add(new Call(v, (Value)Functions.ARRAY_LENGTH, op)).attach(stmt);
                result = v.ref();
            } else {
                if (!(rightOp instanceof NegExpr)) throw new IllegalArgumentException("Unknown type for rightOp: " + rightOp.getClass());
                expr = (NegExpr)rightOp;
                Value op2 = this.immediate(stmt, (Immediate)expr.getOp());
                Type rightType = op2.getType();
                Variable v = this.function.newVariable(op2.getType());
                if (rightType instanceof IntegerType) {
                    this.function.add(new Sub(v, new IntegerConstant(0L, (IntegerType)rightType), op2)).attach(stmt);
                } else {
                    this.function.add(new Fmul(v, new FloatingPointConstant(-1.0, (FloatingPointType)rightType), op2)).attach(stmt);
                }
                result = v.ref();
            }
        }
        soot.Value leftOp = stmt.getLeftOp();
        if (leftOp instanceof Local) {
            Local local = (Local)leftOp;
            VariableRef v = new VariableRef(local.getName(), new PointerType(Types.getLocalType(leftOp.getType())));
            this.function.add(new Store(result, v, !this.sootMethod.getActiveBody().getTraps().isEmpty())).attach(stmt);
            return;
        } else {
            ConcreteRef ref2;
            Type leftType = Types.getType(leftOp.getType());
            Value narrowedResult = this.narrowFromI32Value(stmt, leftType, result);
            if (leftOp instanceof ArrayRef) {
                ref2 = (ArrayRef)leftOp;
                VariableRef variableRef = (VariableRef)this.immediate(stmt, (Immediate)ref2.getBase());
                Value index = this.immediate(stmt, (Immediate)ref2.getIndex());
                this.checkNull(stmt, variableRef);
                this.checkBounds(stmt, variableRef, index);
                if (leftOp.getType() instanceof RefLikeType) {
                    this.call(stmt, (Value)Functions.BC_SET_OBJECT_ARRAY_ELEMENT, this.env, variableRef, index, narrowedResult);
                    return;
                } else {
                    this.call(stmt, (Value)Functions.getArrayStore(leftOp.getType()), variableRef, index, narrowedResult);
                }
                return;
            } else if (leftOp instanceof InstanceFieldRef) {
                ref2 = (InstanceFieldRef)leftOp;
                Value value = this.immediate(stmt, (Immediate)ref2.getBase());
                this.checkNull(stmt, value);
                FunctionRef fn = null;
                if (this.canAccessDirectly((FieldRef)ref2)) {
                    fn = new FunctionRef(Symbols.setterSymbol(ref2.getFieldRef()), new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.OBJECT_PTR, Types.getType(ref2.getType())));
                } else {
                    soot.Type runtimeType = ref2.getBase().getType();
                    String targetClassName4 = Types.getInternalName(ref2.getFieldRef().declaringClass());
                    String runtimeClassName = runtimeType == NullType.v() ? targetClassName4 : Types.getInternalName(runtimeType);
                    PutField trampoline4 = new PutField(this.className, targetClassName4, ref2.getFieldRef().name(), Types.getDescriptor(ref2.getFieldRef().type()), runtimeClassName);
                    this.trampolines.add(trampoline4);
                    fn = trampoline4.getFunctionRef();
                }
                this.call(stmt, (Value)fn, this.env, value, narrowedResult);
                return;
            } else {
                void var8_35;
                if (!(leftOp instanceof StaticFieldRef)) throw new IllegalArgumentException("Unknown type for leftOp: " + leftOp.getClass());
                ref2 = (StaticFieldRef)leftOp;
                Object var8_32 = null;
                if (this.canAccessDirectly((FieldRef)ref2)) {
                    FunctionRef functionRef = new FunctionRef(Symbols.setterSymbol(((StaticFieldRef)ref2).getFieldRef()), new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.getType(((StaticFieldRef)ref2).getType())));
                } else {
                    String targetClassName5 = Types.getInternalName(((StaticFieldRef)ref2).getFieldRef().declaringClass());
                    trampoline2 = new PutStatic(this.className, targetClassName5, ((StaticFieldRef)ref2).getFieldRef().name(), Types.getDescriptor(((StaticFieldRef)ref2).getFieldRef().type()));
                    this.trampolines.add(trampoline2);
                    FunctionRef functionRef = trampoline2.getFunctionRef();
                }
                this.call(stmt, (Value)var8_35, this.env, narrowedResult);
            }
        }
    }

    private void return_(ReturnStmt stmt) {
        Value op = this.immediate(stmt, (Immediate)stmt.getOp());
        Value value = this.narrowFromI32Value(stmt, this.function.getType().getReturnType(), op);
        this.function.add(new Ret(value)).attach(stmt);
    }

    private void returnVoid(ReturnVoidStmt stmt) {
        this.function.add(new Ret()).attach(stmt);
    }

    private void if_(IfStmt stmt) {
        ConditionExpr condition = (ConditionExpr)stmt.getCondition();
        Value op1 = this.immediate(stmt, (Immediate)condition.getOp1());
        Value op2 = this.immediate(stmt, (Immediate)condition.getOp2());
        Icmp.Condition c = null;
        if (condition instanceof EqExpr) {
            c = Icmp.Condition.eq;
        } else if (condition instanceof NeExpr) {
            c = Icmp.Condition.ne;
        } else if (condition instanceof GtExpr) {
            c = Icmp.Condition.sgt;
        } else if (condition instanceof LtExpr) {
            c = Icmp.Condition.slt;
        } else if (condition instanceof GeExpr) {
            c = Icmp.Condition.sge;
        } else if (condition instanceof LeExpr) {
            c = Icmp.Condition.sle;
        }
        Variable result = this.function.newVariable(Type.I1);
        this.function.add(new Icmp(result, c, op1, op2)).attach(stmt);
        Unit nextUnit = this.sootMethod.getActiveBody().getUnits().getSuccOf(stmt);
        this.function.add(new Br(new VariableRef(result), this.function.newBasicBlockRef(new Label(stmt.getTarget())), this.function.newBasicBlockRef(new Label(nextUnit)))).attach(stmt);
    }

    private void lookupSwitch(LookupSwitchStmt stmt) {
        HashMap<IntegerConstant, BasicBlockRef> targets = new HashMap<IntegerConstant, BasicBlockRef>();
        for (int i = 0; i < stmt.getTargetCount(); ++i) {
            int value = stmt.getLookupValue(i);
            Unit target = stmt.getTarget(i);
            targets.put(new IntegerConstant(value), this.function.newBasicBlockRef(new Label(target)));
        }
        BasicBlockRef def = this.function.newBasicBlockRef(new Label(stmt.getDefaultTarget()));
        Value key = this.immediate(stmt, (Immediate)stmt.getKey());
        this.function.add(new Switch(key, def, targets)).attach(stmt);
    }

    private void tableSwitch(TableSwitchStmt stmt) {
        HashMap<IntegerConstant, BasicBlockRef> targets = new HashMap<IntegerConstant, BasicBlockRef>();
        for (int i = stmt.getLowIndex(); i <= stmt.getHighIndex(); ++i) {
            Unit target = stmt.getTarget(i - stmt.getLowIndex());
            targets.put(new IntegerConstant(i), this.function.newBasicBlockRef(new Label(target)));
        }
        BasicBlockRef def = this.function.newBasicBlockRef(new Label(stmt.getDefaultTarget()));
        Value key = this.immediate(stmt, (Immediate)stmt.getKey());
        this.function.add(new Switch(key, def, targets)).attach(stmt);
    }

    private void goto_(GotoStmt stmt) {
        this.function.add(new Br(this.function.newBasicBlockRef(new Label(stmt.getTarget())))).attach(stmt);
    }

    private void throw_(ThrowStmt stmt) {
        Value obj = this.immediate(stmt, (Immediate)stmt.getOp());
        this.checkNull(stmt, obj);
        this.call(stmt, (Value)Functions.BC_THROW, this.env, obj);
        this.function.add(new Unreachable()).attach(stmt);
    }

    private void invoke(InvokeStmt stmt) {
        this.invokeExpr(stmt, stmt.getInvokeExpr());
    }

    private void enterMonitor(EnterMonitorStmt stmt) {
        Value op = this.immediate(stmt, (Immediate)stmt.getOp());
        this.checkNull(stmt, op);
        this.call(stmt, (Value)Functions.MONITORENTER, this.env, op);
    }

    private void exitMonitor(ExitMonitorStmt stmt) {
        Value op = this.immediate(stmt, (Immediate)stmt.getOp());
        this.checkNull(stmt, op);
        this.call(stmt, (Value)Functions.MONITOREXIT, this.env, op);
    }
}

