/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import org.robovm.compiler.AbstractMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;
import org.robovm.compiler.trampoline.NativeCall;
import soot.SootMethod;

public class NativeMethodCompiler
extends AbstractMethodCompiler {
    public NativeMethodCompiler(Config config) {
        super(config);
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = FunctionBuilder.method(method);
        moduleBuilder.addFunction(fn);
        VariableRef env = fn.getParameterRef(0);
        String targetClassName = Types.getInternalName(method.getDeclaringClass());
        String methodName = method.getName();
        String methodDesc = Types.getDescriptor(method);
        NativeCall trampoline = new NativeCall(this.className, targetClassName, methodName, methodDesc, method.isStatic());
        this.trampolines.add(trampoline);
        ArrayList<Value> args = new ArrayList<Value>(Arrays.asList(fn.getParameterRefs()));
        if (method.isStatic()) {
            FunctionRef ldcFn = FunctionBuilder.ldcInternal(this.sootMethod.getDeclaringClass()).ref();
            Value clazz = Functions.call(fn, (Value)ldcFn, env);
            args.add(1, clazz);
        }
        Functions.pushNativeFrame(fn);
        Value result = Functions.call(fn, (Value)trampoline.getFunctionRef(), args);
        Functions.popNativeFrame(fn);
        Functions.call(fn, (Value)Functions.BC_THROW_IF_EXCEPTION_OCCURRED, env);
        fn.add(new Ret(result));
        return fn;
    }
}

