/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.Inttoptr;
import org.robovm.compiler.llvm.Load;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;
import soot.SootMethod;
import soot.VoidType;

public class StructMemberMethodCompiler
extends BroMethodCompiler {
    private StructureType structType;

    public StructMemberMethodCompiler(Config config) {
        super(config);
    }

    @Override
    public void reset(Clazz clazz) {
        super.reset(clazz);
        this.structType = null;
        if (Types.isStruct(this.sootClass)) {
            this.structType = this.getStructType(this.sootClass);
        }
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        if ("_sizeOf".equals(method.getName()) || "sizeOf".equals(method.getName())) {
            return this.structSizeOf(moduleBuilder, method);
        }
        return this.structMember(moduleBuilder, method);
    }

    private Function structSizeOf(ModuleBuilder moduleBuilder, SootMethod method) {
        Function fn = FunctionBuilder.method(method);
        moduleBuilder.addFunction(fn);
        fn.add(new Ret(Types.sizeof(this.structType)));
        return fn;
    }

    private Function structMember(ModuleBuilder moduleBuilder, SootMethod method) {
        Function function = FunctionBuilder.method(method);
        moduleBuilder.addFunction(function);
        Variable handleI64 = function.newVariable(Type.I64);
        function.add(new Load(handleI64, Types.getFieldPtr(function, function.getParameterRef(1), Types.offsetof(new StructureType(Types.DATA_OBJECT, new StructureType(Type.I64)), 1, 0), Type.I64)));
        Variable handlePtr = function.newVariable(new PointerType(this.structType));
        function.add(new Inttoptr(handlePtr, handleI64.ref(), handlePtr.getType()));
        int offset = Bro.getStructMemberOffset(method) + 1;
        Type memberType = this.getStructMemberType(method);
        Variable memberPtr = function.newVariable(new PointerType(memberType));
        if (memberType != this.structType.getTypeAt(offset)) {
            Variable tmp = function.newVariable(new PointerType(this.structType.getTypeAt(offset)));
            function.add(new Getelementptr(tmp, (Value)handlePtr.ref(), 0, offset));
            function.add(new Bitcast(memberPtr, tmp.ref(), memberPtr.getType()));
        } else {
            function.add(new Getelementptr(memberPtr, (Value)handlePtr.ref(), 0, offset));
        }
        VariableRef env = function.getParameterRef(0);
        if (method.getParameterCount() == 0) {
            Value result = this.loadValueForGetter(method, function, memberType, memberPtr.ref(), function.getParameterRef(0), true, 2L);
            function.add(new Ret(result));
        } else {
            VariableRef value = function.getParameterRef(2);
            this.storeValueForSetter(method, function, memberType, memberPtr.ref(), env, value, 2L);
            if (method.getReturnType().equals(VoidType.v())) {
                function.add(new Ret());
            } else {
                function.add(new Ret(function.getParameterRef(1)));
            }
        }
        return function;
    }
}

