/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.trampoline.Trampoline;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public class ClazzInfo
implements Serializable {
    private static final long serialVersionUID = 61L;
    private int modifiers;
    private String name;
    private String internalName;
    private String superclassName;
    private final List<String> interfaceNames = new ArrayList<String>();
    private final Set<Trampoline> trampolines = new HashSet<Trampoline>();
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private final Set<String> catchNames = new HashSet<String>();
    private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();
    private transient Clazz clazz;
    private transient List<FieldInfo> classFields;
    private transient List<FieldInfo> instanceFields;

    ClazzInfo() {
    }

    ClazzInfo(Clazz clazz, SootClass sootClass) {
        this.clazz = clazz;
        this.modifiers = sootClass.getModifiers();
        this.name = sootClass.getName();
        this.internalName = Types.getInternalName(sootClass);
        if (sootClass.hasSuperclass()) {
            this.superclassName = Types.getInternalName(sootClass.getSuperclass());
        }
        for (SootClass ifs : sootClass.getInterfaces()) {
            this.interfaceNames.add(Types.getInternalName(ifs));
        }
        for (SootField field : sootClass.getFields()) {
            this.fields.add(new FieldInfo(field.getModifiers(), field.getName(), Types.getDescriptor(field)));
        }
        for (SootMethod method : sootClass.getMethods()) {
            this.methods.add(new MethodInfo(method.getModifiers(), method.getName(), Types.getDescriptor(method)));
        }
    }

    private ClazzInfo(String internalName) {
        this.internalName = internalName;
        this.name = internalName.replace('/', '.');
    }

    public boolean isPhantom() {
        return this.clazz == null;
    }

    void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getPackageName() {
        int idx = this.name.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return this.name.substring(0, idx);
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public boolean hasSuperclass() {
        return this.superclassName != null;
    }

    private ClazzInfo loadClazzInfo(String n) {
        Clazz c;
        if (n != null && (c = this.clazz.clazzes.load(n)) != null) {
            return c.getClazzInfo();
        }
        return new ClazzInfo(n);
    }

    public ClazzInfo getSuperclass() {
        return this.loadClazzInfo(this.superclassName);
    }

    public List<String> getInterfaceNames() {
        return Collections.unmodifiableList(this.interfaceNames);
    }

    public void setInterfaceNames(List<String> interfaceNames) {
        this.interfaceNames.clear();
        this.interfaceNames.addAll(interfaceNames);
    }

    public List<ClazzInfo> getInterfaces() {
        ArrayList<ClazzInfo> result = new ArrayList<ClazzInfo>();
        for (String ifname : this.interfaceNames) {
            result.add(this.loadClazzInfo(ifname));
        }
        return result;
    }

    public Set<Trampoline> getTrampolines() {
        return Collections.unmodifiableSet(this.trampolines);
    }

    public void setTrampolines(Set<Trampoline> trampolines) {
        this.trampolines.clear();
        this.trampolines.addAll(trampolines);
    }

    public Set<String> getCatchNames() {
        return this.catchNames;
    }

    public void setCatchNames(Set<String> catchNames) {
        this.catchNames.clear();
        this.catchNames.addAll(catchNames);
    }

    public List<ClazzInfo> getCatches() {
        ArrayList<ClazzInfo> result = new ArrayList<ClazzInfo>();
        for (String n : this.catchNames) {
            result.add(this.loadClazzInfo(n));
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public FieldInfo getField(String name, String desc) {
        for (FieldInfo f : this.fields) {
            if (!f.getName().equals(name) || !f.getDesc().equals(desc)) continue;
            return f;
        }
        return null;
    }

    public List<FieldInfo> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void clearFields() {
        this.fields.clear();
    }

    public void addField(int modifiers, String name, String desc) {
        this.fields.add(new FieldInfo(modifiers, name, desc));
    }

    public List<FieldInfo> getClassFields() {
        if (this.classFields == null) {
            this.classFields = new ArrayList<FieldInfo>();
            for (FieldInfo f : this.fields) {
                if (!f.isStatic()) continue;
                this.classFields.add(f);
            }
        }
        return this.classFields;
    }

    public List<FieldInfo> getInstanceFields() {
        if (this.instanceFields == null) {
            this.instanceFields = new ArrayList<FieldInfo>();
            for (FieldInfo f : this.fields) {
                if (f.isStatic()) continue;
                this.instanceFields.add(f);
            }
        }
        return this.instanceFields;
    }

    public MethodInfo getMethod(String name, String desc) {
        for (MethodInfo m : this.methods) {
            if (!m.getName().equals(name) || !m.getDesc().equals(desc)) continue;
            return m;
        }
        return null;
    }

    public List<MethodInfo> getMethods(String name) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo m : this.methods) {
            if (!m.getName().equals(name)) continue;
            result.add(m);
        }
        return result;
    }

    public List<MethodInfo> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public void clearMethods() {
        this.methods.clear();
    }

    public void addMethod(int flags, String name, String desc) {
        this.methods.add(new MethodInfo(flags, name, desc));
    }

    public void addDependency(String className) {
        if (!this.dependencies.containsKey(className)) {
            Clazz clazz = this.clazz.clazzes.load(className);
            String path = null;
            boolean inBootClasspath = false;
            if (clazz != null) {
                path = clazz.getPath().getFile().getAbsolutePath();
                inBootClasspath = clazz.isInBootClasspath();
            }
            this.dependencies.put(className, new Dependency(className, path, inBootClasspath));
        }
    }

    public void addDependencies(Collection<String> classNames) {
        for (String className : classNames) {
            this.addDependency(className);
        }
    }

    public void clearDependencies() {
        this.dependencies = new HashMap<String, Dependency>();
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(this.dependencies.values());
    }

    public boolean isPublic() {
        return (this.modifiers & 1) > 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) > 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) > 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) > 0;
    }

    public class MethodInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int modifiers;
        private String name;
        private String desc;

        private MethodInfo(int modifiers, String name, String desc) {
            this.modifiers = modifiers;
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean isPublic() {
            return (this.modifiers & 1) > 0;
        }

        public boolean isPrivate() {
            return (this.modifiers & 2) > 0;
        }

        public boolean isProtected() {
            return (this.modifiers & 4) > 0;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) > 0;
        }

        public boolean isFinal() {
            return (this.modifiers & 0x10) > 0;
        }

        public boolean isSynchronized() {
            return (this.modifiers & 0x20) > 0;
        }

        public boolean isNative() {
            return (this.modifiers & 0x100) > 0;
        }

        public boolean isAbstract() {
            return (this.modifiers & 0x400) > 0;
        }
    }

    public class FieldInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int modifiers;
        private String name;
        private String desc;

        private FieldInfo(int modifiers, String name, String desc) {
            this.modifiers = modifiers;
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean isPublic() {
            return (this.modifiers & 1) > 0;
        }

        public boolean isPrivate() {
            return (this.modifiers & 2) > 0;
        }

        public boolean isProtected() {
            return (this.modifiers & 4) > 0;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) > 0;
        }

        public boolean isFinal() {
            return (this.modifiers & 0x10) > 0;
        }

        public boolean isVolatile() {
            return (this.modifiers & 0x40) > 0;
        }
    }
}

