/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.clazz.AbstractPath;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;

public class ZipFilePath
extends AbstractPath {
    private final ZipFile zipFile;

    ZipFilePath(File f, Clazzes clazzes, int index, boolean inBootclasspath) throws IOException {
        super(f, clazzes, index, inBootclasspath);
        this.zipFile = new ZipFile(f);
    }

    @Override
    public boolean contains(String file) {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals(file) || entry.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<Clazz> doListClasses() {
        TreeSet<Clazz> s = new TreeSet<Clazz>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            s.add(new ZipFilePathClazz(entry));
        }
        return s;
    }

    @Override
    public boolean hasChangedSince(long timestamp) {
        return this.file.lastModified() > timestamp;
    }

    private class ZipFilePathClazz
    extends Clazz {
        private final ZipEntry entry;
        private byte[] bytes;

        ZipFilePathClazz(ZipEntry entry) {
            super(ZipFilePath.this.clazzes, entry.getName(), ZipFilePath.this);
            this.bytes = null;
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBytes() throws IOException {
            if (this.bytes == null) {
                InputStream in = null;
                try {
                    in = ZipFilePath.this.zipFile.getInputStream(this.entry);
                    this.bytes = IOUtils.toByteArray(in);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
            return this.bytes;
        }

        @Override
        public long lastModified() {
            return ZipFilePath.this.file.lastModified();
        }
    }
}

