/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import org.robovm.compiler.CompilerException;
import org.robovm.llvm.Target;

public enum Arch {
    x86("i386", "i386"),
    thumbv7("thumbv7", "armv7");

    private final String llvmName;
    private final String clangName;

    private Arch(String llvmName, String clangName) {
        this.llvmName = llvmName;
        this.clangName = clangName;
    }

    public String getLlvmName() {
        return this.llvmName;
    }

    public String getClangName() {
        return this.clangName;
    }

    public boolean isArm() {
        switch (this) {
            case thumbv7: {
                return true;
            }
        }
        return false;
    }

    public boolean is32Bit() {
        return true;
    }

    public static Arch getDefaultArch() {
        String hostTriple = Target.getHostTriple();
        if (hostTriple.matches("^(x86|i\\d86).*")) {
            return x86;
        }
        throw new CompilerException("Unrecognized arch in host triple: " + hostTriple);
    }
}

