/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.ITable;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.VTable;
import org.robovm.compiler.Version;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.plugin.CompilerPlugin;
import org.robovm.compiler.plugin.LaunchPlugin;
import org.robovm.compiler.plugin.Plugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.annotation.AnnotationImplPlugin;
import org.robovm.compiler.plugin.lambda.LambdaPlugin;
import org.robovm.compiler.plugin.objc.ObjCBlockPlugin;
import org.robovm.compiler.plugin.objc.ObjCMemberPlugin;
import org.robovm.compiler.plugin.objc.ObjCProtocolProxyPlugin;
import org.robovm.compiler.target.ConsoleTarget;
import org.robovm.compiler.target.Target;
import org.robovm.compiler.target.ios.IOSTarget;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

@Root
public class Config {
    @Element(required=false)
    private File installDir = null;
    @Element(required=false)
    private String executableName = null;
    @Element(required=false)
    private Boolean useDynamicJni = null;
    @Element(required=false)
    private Boolean skipRuntimeLib = null;
    @Element(required=false)
    private File mainJar;
    @Element(required=false)
    private String mainClass;
    @Element(required=false)
    private Cacerts cacerts = null;
    @Element(required=false)
    private OS os = null;
    @Element(required=false)
    private Arch arch = null;
    @ElementList(required=false, entry="root")
    private ArrayList<String> roots;
    @ElementList(required=false, entry="pattern")
    private ArrayList<String> forceLinkClasses;
    @ElementList(required=false, entry="lib")
    private ArrayList<Lib> libs;
    @ElementList(required=false, entry="symbol")
    private ArrayList<String> exportedSymbols;
    @ElementList(required=false, entry="framework")
    private ArrayList<String> frameworks;
    @ElementList(required=false, entry="framework")
    private ArrayList<String> weakFrameworks;
    @ElementList(required=false, entry="path")
    private ArrayList<File> frameworkPaths;
    @ElementList(required=false, entry="resource")
    private ArrayList<Resource> resources;
    @ElementList(required=false, entry="classpathentry")
    private ArrayList<File> bootclasspath;
    @ElementList(required=false, entry="classpathentry")
    private ArrayList<File> classpath;
    @ElementList(required=false, entry="argument")
    private ArrayList<String> pluginArguments;
    @Element(required=false, name="target")
    private TargetType targetType;
    @Element(required=false)
    private String iosSdkVersion;
    @Element(required=false)
    private File iosInfoPList = null;
    @Element(required=false)
    private File iosResourceRulesPList;
    @Element(required=false)
    private File iosEntitlementsPList;
    private SigningIdentity iosSignIdentity;
    private ProvisioningProfile iosProvisioningProfile;
    private String iosDeviceType;
    private boolean iosSkipSigning = false;
    private Target target = null;
    private Properties properties = new Properties();
    private Home home = null;
    private File cacheDir = new File(System.getProperty("user.home"), ".robovm/cache");
    private File ccBinPath = null;
    private boolean clean = false;
    private boolean debug = false;
    private boolean useDebugLibs = false;
    private boolean skipLinking = false;
    private boolean skipInstall = false;
    private boolean dumpIntermediates = false;
    private int threads = Runtime.getRuntime().availableProcessors();
    private File osArchDepLibDir;
    private File tmpDir;
    private Clazzes clazzes;
    private VTable.Cache vtableCache;
    private ITable.Cache itableCache;
    private Logger logger = Logger.NULL_LOGGER;
    private List<Path> resourcesPaths = new ArrayList<Path>();
    private DataLayout dataLayout;
    private MarshalerLookup marshalerLookup;
    private List<Plugin> plugins = new ArrayList<Plugin>();

    protected Config() throws IOException {
        this.plugins.addAll(0, Arrays.asList(new ObjCProtocolProxyPlugin(), new ObjCBlockPlugin(), new ObjCMemberPlugin(), new AnnotationImplPlugin(), new LambdaPlugin()));
        this.loadPluginsFromClassPath();
    }

    public Home getHome() {
        return this.home;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public String getExecutableName() {
        return this.executableName;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getCcBinPath() {
        return this.ccBinPath;
    }

    public OS getOs() {
        return this.os;
    }

    public Arch getArch() {
        return this.arch;
    }

    public String getTriple() {
        return this.arch.getLlvmName() + "-unknown-" + (Object)((Object)this.os);
    }

    public DataLayout getDataLayout() {
        return this.dataLayout;
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUseDebugLibs() {
        return this.useDebugLibs;
    }

    public boolean isDumpIntermediates() {
        return this.dumpIntermediates;
    }

    public boolean isSkipRuntimeLib() {
        return this.skipRuntimeLib != null && this.skipRuntimeLib != false;
    }

    public boolean isSkipLinking() {
        return this.skipLinking;
    }

    public boolean isSkipInstall() {
        return this.skipInstall;
    }

    public boolean isUseDynamicJni() {
        return this.useDynamicJni != null && this.useDynamicJni != false;
    }

    public int getThreads() {
        return this.threads;
    }

    public File getMainJar() {
        return this.mainJar;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Cacerts getCacerts() {
        return this.cacerts == null ? Cacerts.full : this.cacerts;
    }

    public List<Path> getResourcesPaths() {
        return this.resourcesPaths;
    }

    public void addResourcesPath(Path path) {
        this.resourcesPaths.add(path);
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            try {
                this.tmpDir = File.createTempFile("robovm", ".tmp");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.tmpDir.delete();
            this.tmpDir.mkdirs();
        }
        return this.tmpDir;
    }

    public List<String> getForceLinkClasses() {
        return this.forceLinkClasses == null ? Collections.emptyList() : Collections.unmodifiableList(this.forceLinkClasses);
    }

    public List<String> getExportedSymbols() {
        return this.exportedSymbols == null ? Collections.emptyList() : Collections.unmodifiableList(this.exportedSymbols);
    }

    public List<Lib> getLibs() {
        return this.libs == null ? Collections.emptyList() : Collections.unmodifiableList(this.libs);
    }

    public List<String> getFrameworks() {
        return this.frameworks == null ? Collections.emptyList() : Collections.unmodifiableList(this.frameworks);
    }

    public List<String> getWeakFrameworks() {
        return this.weakFrameworks == null ? Collections.emptyList() : Collections.unmodifiableList(this.weakFrameworks);
    }

    public List<File> getFrameworkPaths() {
        return this.frameworkPaths == null ? Collections.emptyList() : Collections.unmodifiableList(this.frameworkPaths);
    }

    public List<Resource> getResources() {
        return this.resources == null ? Collections.emptyList() : Collections.unmodifiableList(this.resources);
    }

    public File getOsArchDepLibDir() {
        return this.osArchDepLibDir;
    }

    public Clazzes getClazzes() {
        return this.clazzes;
    }

    public VTable.Cache getVTableCache() {
        return this.vtableCache;
    }

    public ITable.Cache getITableCache() {
        return this.itableCache;
    }

    public MarshalerLookup getMarshalerLookup() {
        return this.marshalerLookup;
    }

    public List<CompilerPlugin> getCompilerPlugins() {
        ArrayList<CompilerPlugin> compilerPlugins = new ArrayList<CompilerPlugin>();
        for (Plugin plugin : this.plugins) {
            if (!(plugin instanceof CompilerPlugin)) continue;
            compilerPlugins.add((CompilerPlugin)plugin);
        }
        return compilerPlugins;
    }

    public List<LaunchPlugin> getLaunchPlugins() {
        ArrayList<LaunchPlugin> launchPlugins = new ArrayList<LaunchPlugin>();
        for (Plugin plugin : this.plugins) {
            if (!(plugin instanceof LaunchPlugin)) continue;
            launchPlugins.add((LaunchPlugin)plugin);
        }
        return launchPlugins;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public List<String> getPluginArguments() {
        return this.pluginArguments;
    }

    public List<File> getBootclasspath() {
        return this.bootclasspath;
    }

    public List<File> getClasspath() {
        return this.classpath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getIosSdkVersion() {
        return this.iosSdkVersion;
    }

    public String getIosDeviceType() {
        return this.iosDeviceType;
    }

    public File getIosInfoPList() {
        return this.iosInfoPList;
    }

    public File getIosResourceRulesPList() {
        return this.iosResourceRulesPList;
    }

    public File getIosEntitlementsPList() {
        return this.iosEntitlementsPList;
    }

    public SigningIdentity getIosSignIdentity() {
        return this.iosSignIdentity;
    }

    public ProvisioningProfile getIosProvisioningProfile() {
        return this.iosProvisioningProfile;
    }

    public boolean isIosSkipSigning() {
        return this.iosSkipSigning;
    }

    private static File makeFileRelativeTo(File dir, File f) {
        if (f.getParentFile() == null) {
            return dir;
        }
        return new File(Config.makeFileRelativeTo(dir, f.getParentFile()), f.getName());
    }

    public String getArchiveName(Path path) {
        if (path.getFile().isFile()) {
            return path.getFile().getName();
        }
        return "classes" + path.getIndex() + ".jar";
    }

    public File getLlFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.ll");
    }

    public File getBcFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.bc");
    }

    public File getSFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.s");
    }

    public File getOFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.o");
    }

    public File getDepsFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.deps");
    }

    public File getInfoFile(Clazz clazz) {
        String baseName = clazz.getInternalName().replace('/', File.separatorChar);
        return new File(this.getCacheDir(clazz.getPath()), baseName + ".class.info");
    }

    public File getCacheDir(Path path) {
        File srcRoot = path.getFile().getParentFile();
        String name = path.getFile().getName();
        try {
            return new File(Config.makeFileRelativeTo(this.cacheDir, srcRoot.getCanonicalFile()), name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getGeneratedClassDir(Path path) {
        File pathCacheDir = this.getCacheDir(path);
        return new File(pathCacheDir.getParentFile(), pathCacheDir.getName() + ".generated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Object, Object> getManifestAttributes(File jarFile) throws IOException {
        try (ZipFile jf = null;){
            jf = new JarFile(jarFile);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(((JarFile)jf).getManifest().getMainAttributes());
            return hashMap;
        }
    }

    private static String getImplementationVersion(File jarFile) throws IOException {
        return (String)Config.getManifestAttributes(jarFile).get(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    private static String getMainClass(File jarFile) throws IOException {
        return (String)Config.getManifestAttributes(jarFile).get(Attributes.Name.MAIN_CLASS);
    }

    private File extractIfNeeded(Path path) throws IOException {
        if (path.getFile().isFile()) {
            File pathCacheDir = this.getCacheDir(path);
            File target = new File(pathCacheDir.getParentFile(), pathCacheDir.getName() + ".extracted");
            if (!target.exists() || path.getFile().lastModified() > target.lastModified()) {
                FileUtils.deleteDirectory(target);
                target.mkdirs();
                try (ZipFile zipFile = new ZipFile(path.getFile());){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith("META-INF/robovm/") || entry.isDirectory()) continue;
                        File f = new File(target, entry.getName());
                        f.getParentFile().mkdirs();
                        InputStream in = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            FileOutputStream out = new FileOutputStream(f);
                            Throwable throwable2 = null;
                            try {
                                IOUtils.copy(in, (OutputStream)out);
                                if (entry.getTime() == -1L) continue;
                                f.setLastModified(entry.getTime());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (out == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)out).close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                ((OutputStream)out).close();
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                target.setLastModified(path.getFile().lastModified());
            }
            return target;
        }
        return path.getFile();
    }

    private <T> ArrayList<T> mergeLists(ArrayList<T> from, ArrayList<T> to) {
        if (from == null) {
            return to;
        }
        to = to != null ? to : new ArrayList<T>();
        for (T o : from) {
            if (to.contains(o)) continue;
            to.add(o);
        }
        return to;
    }

    private void mergeConfig(Config from, Config to) {
        to.exportedSymbols = this.mergeLists(from.exportedSymbols, to.exportedSymbols);
        to.forceLinkClasses = this.mergeLists(from.forceLinkClasses, to.forceLinkClasses);
        to.frameworkPaths = this.mergeLists(from.frameworkPaths, to.frameworkPaths);
        to.frameworks = this.mergeLists(from.frameworks, to.frameworks);
        to.libs = this.mergeLists(from.libs, to.libs);
        to.resources = this.mergeLists(from.resources, to.resources);
        to.weakFrameworks = this.mergeLists(from.weakFrameworks, to.weakFrameworks);
    }

    private void mergeConfigsFromClasspath() throws IOException {
        List<String> dirs = Arrays.asList("META-INF/robovm/" + (Object)((Object)this.os) + "/" + (Object)((Object)this.arch), "META-INF/robovm/" + (Object)((Object)this.os));
        Config config = new Config();
        block0: for (Path path : this.clazzes.getPaths()) {
            for (String dir : dirs) {
                if (!path.contains(dir + "/robovm.xml")) continue;
                File configXml = new File(new File(this.extractIfNeeded(path), dir), "robovm.xml");
                Builder builder = new Builder();
                builder.read(configXml);
                this.mergeConfig(builder.config, config);
                continue block0;
            }
        }
        this.mergeConfig(this, config);
        this.exportedSymbols = config.exportedSymbols;
        this.forceLinkClasses = config.forceLinkClasses;
        this.frameworkPaths = config.frameworkPaths;
        this.frameworks = config.frameworks;
        this.libs = config.libs;
        this.resources = config.resources;
        this.weakFrameworks = config.weakFrameworks;
    }

    private void loadPluginsFromClassPath() throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream("/META-INF/robovm/plugins.properties");){
            if (in != null) {
                Class<?> c;
                String value;
                Properties p = new Properties();
                p.load(in);
                int i = 1;
                while ((value = p.getProperty("compiler.plugin." + i)) != null) {
                    c = this.getClass().getClassLoader().loadClass(value);
                    this.plugins.add((Plugin)c.newInstance());
                    ++i;
                }
                i = 1;
                while ((value = p.getProperty("launch.plugin." + i)) != null) {
                    c = this.getClass().getClassLoader().loadClass(value);
                    this.plugins.add((Plugin)c.newInstance());
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException(e);
        }
        catch (InstantiationException e) {
            throw new CompilerException(e);
        }
        catch (IllegalAccessException e) {
            throw new CompilerException(e);
        }
    }

    private Config build() throws IOException {
        ArrayList<File> realBootclasspath;
        if (this.home == null) {
            this.home = Home.find();
        }
        if (this.bootclasspath == null) {
            this.bootclasspath = new ArrayList();
        }
        if (this.classpath == null) {
            this.classpath = new ArrayList();
        }
        if (this.mainJar != null) {
            this.mainClass = Config.getMainClass(this.mainJar);
            this.classpath.add(this.mainJar);
        }
        if (!this.skipLinking && this.executableName == null && this.mainClass == null) {
            throw new IllegalArgumentException("No target and no main class specified");
        }
        if (!this.skipLinking && this.classpath.isEmpty()) {
            throw new IllegalArgumentException("No classpath specified");
        }
        if (this.skipLinking) {
            this.skipInstall = true;
        }
        if (this.executableName == null) {
            this.executableName = this.mainClass;
        }
        ArrayList<File> arrayList = realBootclasspath = this.bootclasspath == null ? new ArrayList<File>() : this.bootclasspath;
        if (!this.isSkipRuntimeLib()) {
            realBootclasspath = new ArrayList<File>(this.bootclasspath);
            realBootclasspath.add(0, this.home.rtPath);
        }
        this.vtableCache = new VTable.Cache();
        this.itableCache = new ITable.Cache();
        this.marshalerLookup = new MarshalerLookup(this);
        if (!this.skipInstall) {
            if (this.installDir == null) {
                this.installDir = new File(".", this.executableName);
            }
            this.installDir.mkdirs();
        }
        this.target = this.targetType == TargetType.console ? new ConsoleTarget() : (this.targetType == TargetType.ios ? new IOSTarget() : (this.os == OS.ios ? new IOSTarget() : new ConsoleTarget()));
        this.target.init(this);
        this.os = this.target.getOs();
        this.arch = this.target.getArch();
        this.dataLayout = new DataLayout(this.getTriple());
        this.osArchDepLibDir = new File(new File(this.home.libVmDir, this.os.toString()), this.arch.toString());
        File osDir = new File(this.cacheDir, this.os.toString());
        File archDir = new File(osDir, this.arch.toString());
        this.cacheDir = new File(archDir, this.debug ? "debug" : "release");
        this.cacheDir.mkdirs();
        this.clazzes = new Clazzes(this, realBootclasspath, this.classpath);
        this.mergeConfigsFromClasspath();
        return this;
    }

    private static final class ResourceConverter
    implements Converter<Resource> {
        private final RelativeFileConverter fileConverter;
        private final Serializer serializer;

        public ResourceConverter(RelativeFileConverter fileConverter, Serializer serializer) {
            this.fileConverter = fileConverter;
            this.serializer = serializer;
        }

        @Override
        public Resource read(InputNode node) throws Exception {
            String value = node.getValue();
            if (value != null && value.trim().length() > 0) {
                return new Resource(this.fileConverter.read(value));
            }
            return (Resource)((Object)this.serializer.read(Resource.class, node));
        }

        @Override
        public void write(OutputNode node, Resource resource) throws Exception {
            File path = resource.getPath();
            if (path != null) {
                this.fileConverter.write(node, path);
            } else {
                node.remove();
                this.serializer.write((Object)resource, node.getParent());
            }
        }
    }

    private static final class RelativeFileConverter
    implements Converter<File> {
        private final String wdPrefix;

        public RelativeFileConverter(File wd) {
            String prefix;
            if (wd.isFile()) {
                wd = wd.getParentFile();
            }
            if ((prefix = wd.getAbsolutePath()).endsWith(File.separator)) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            this.wdPrefix = prefix;
        }

        File read(String value) {
            if (value == null) {
                return null;
            }
            File file = new File(value);
            if (!file.isAbsolute()) {
                file = new File(this.wdPrefix, value);
            }
            return file;
        }

        @Override
        public File read(InputNode node) throws Exception {
            return this.read(node.getValue());
        }

        @Override
        public void write(OutputNode node, File value) throws Exception {
            String path = value.getAbsolutePath();
            if (path.equals(this.wdPrefix)) {
                if ("directory".equals(node.getName())) {
                    node.remove();
                } else {
                    node.setValue("");
                }
            } else if (path.startsWith(this.wdPrefix) && path.charAt(this.wdPrefix.length()) == File.separatorChar) {
                node.setValue(path.substring(this.wdPrefix.length() + 1));
            } else {
                node.setValue(path);
            }
        }
    }

    private static final class RelativeLibConverter
    implements Converter<Lib> {
        private final RelativeFileConverter fileConverter;

        public RelativeLibConverter(RelativeFileConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        @Override
        public Lib read(InputNode node) throws Exception {
            boolean force;
            String value = node.getValue();
            if (value == null) {
                return null;
            }
            InputNode forceNode = node.getAttribute("force");
            boolean bl = force = forceNode == null || Boolean.valueOf(forceNode.getValue()) != false;
            if (value.endsWith(".a") || value.endsWith(".o")) {
                return new Lib(this.fileConverter.read(value).getAbsolutePath(), force);
            }
            return new Lib(value, force);
        }

        @Override
        public void write(OutputNode node, Lib lib) throws Exception {
            String value = lib.getValue();
            boolean force = lib.isForce();
            if (value.endsWith(".a") || value.endsWith(".o")) {
                this.fileConverter.write(node, new File(value));
            } else {
                node.setValue(value);
            }
            if (!force) {
                node.setAttribute("force", "false");
            }
        }
    }

    public static final class Lib {
        private final String value;
        private final boolean force;

        public Lib(String value, boolean force) {
            this.value = value;
            this.force = force;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isForce() {
            return this.force;
        }

        public String toString() {
            return "Lib [value=" + this.value + ", force=" + this.force + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.force ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.force != other.force) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class Builder {
        final Config config = new Config();

        public Builder os(OS os) {
            this.config.os = os;
            return this;
        }

        public Builder arch(Arch arch) {
            this.config.arch = arch;
            return this;
        }

        public Builder clearClasspathEntries() {
            if (this.config.classpath != null) {
                this.config.classpath.clear();
            }
            return this;
        }

        public Builder addClasspathEntry(File f) {
            if (this.config.classpath == null) {
                this.config.classpath = new ArrayList();
            }
            this.config.classpath.add(f);
            return this;
        }

        public Builder clearBootClasspathEntries() {
            if (this.config.bootclasspath != null) {
                this.config.bootclasspath.clear();
            }
            return this;
        }

        public Builder addBootClasspathEntry(File f) {
            if (this.config.bootclasspath == null) {
                this.config.bootclasspath = new ArrayList();
            }
            this.config.bootclasspath.add(f);
            return this;
        }

        public Builder mainJar(File f) {
            this.config.mainJar = f;
            return this;
        }

        public Builder installDir(File installDir) {
            this.config.installDir = installDir;
            return this;
        }

        public Builder executableName(String executableName) {
            this.config.executableName = executableName;
            return this;
        }

        public Builder home(Home home) {
            this.config.home = home;
            return this;
        }

        public Builder cacheDir(File cacheDir) {
            this.config.cacheDir = cacheDir;
            return this;
        }

        public Builder clean(boolean b) {
            this.config.clean = b;
            return this;
        }

        public Builder ccBinPath(File ccBinPath) {
            this.config.ccBinPath = ccBinPath;
            return this;
        }

        public Builder debug(boolean b) {
            this.config.debug = b;
            return this;
        }

        public Builder useDebugLibs(boolean b) {
            this.config.useDebugLibs = b;
            return this;
        }

        public Builder dumpIntermediates(boolean b) {
            this.config.dumpIntermediates = b;
            return this;
        }

        public Builder skipRuntimeLib(boolean b) {
            this.config.skipRuntimeLib = b;
            return this;
        }

        public Builder skipLinking(boolean b) {
            this.config.skipLinking = b;
            return this;
        }

        public Builder skipInstall(boolean b) {
            this.config.skipInstall = b;
            return this;
        }

        public Builder useDynamicJni(boolean b) {
            this.config.useDynamicJni = b;
            return this;
        }

        public Builder threads(int threads) {
            this.config.threads = threads;
            return this;
        }

        public Builder mainClass(String mainClass) {
            this.config.mainClass = mainClass;
            return this;
        }

        public Builder tmpDir(File tmpDir) {
            this.config.tmpDir = tmpDir;
            return this;
        }

        public Builder logger(Logger logger) {
            this.config.logger = logger;
            return this;
        }

        public Builder clearForceLinkClasses() {
            if (this.config.forceLinkClasses != null) {
                this.config.forceLinkClasses.clear();
            }
            return this;
        }

        public Builder addForceLinkClass(String pattern) {
            if (this.config.forceLinkClasses == null) {
                this.config.forceLinkClasses = new ArrayList();
            }
            this.config.forceLinkClasses.add(pattern);
            return this;
        }

        public Builder clearExportedSymbols() {
            if (this.config.exportedSymbols != null) {
                this.config.exportedSymbols.clear();
            }
            return this;
        }

        public Builder addExportedSymbol(String symbol) {
            if (this.config.exportedSymbols == null) {
                this.config.exportedSymbols = new ArrayList();
            }
            this.config.exportedSymbols.add(symbol);
            return this;
        }

        public Builder clearLibs() {
            if (this.config.libs != null) {
                this.config.libs.clear();
            }
            return this;
        }

        public Builder addLib(Lib lib) {
            if (this.config.libs == null) {
                this.config.libs = new ArrayList();
            }
            this.config.libs.add(lib);
            return this;
        }

        public Builder clearFrameworks() {
            if (this.config.frameworks != null) {
                this.config.frameworks.clear();
            }
            return this;
        }

        public Builder addFramework(String framework) {
            if (this.config.frameworks == null) {
                this.config.frameworks = new ArrayList();
            }
            this.config.frameworks.add(framework);
            return this;
        }

        public Builder clearWeakFrameworks() {
            if (this.config.weakFrameworks != null) {
                this.config.weakFrameworks.clear();
            }
            return this;
        }

        public Builder addWeakFramework(String framework) {
            if (this.config.weakFrameworks == null) {
                this.config.weakFrameworks = new ArrayList();
            }
            this.config.weakFrameworks.add(framework);
            return this;
        }

        public Builder clearFrameworkPaths() {
            if (this.config.frameworkPaths != null) {
                this.config.frameworkPaths.clear();
            }
            return this;
        }

        public Builder addFrameworkPath(File frameworkPath) {
            if (this.config.frameworkPaths == null) {
                this.config.frameworkPaths = new ArrayList();
            }
            this.config.frameworkPaths.add(frameworkPath);
            return this;
        }

        public Builder clearResources() {
            if (this.config.resources != null) {
                this.config.resources.clear();
            }
            return this;
        }

        public Builder addResource(Resource resource) {
            if (this.config.resources == null) {
                this.config.resources = new ArrayList();
            }
            this.config.resources.add(resource);
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.config.targetType = targetType;
            return this;
        }

        public Builder clearProperties() {
            this.config.properties.clear();
            return this;
        }

        public Builder addProperties(Properties properties) {
            this.config.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder addProperties(File file) throws IOException {
            Properties props = new Properties();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                props.load(reader);
                this.addProperties(props);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.config.properties.put(name, value);
            return this;
        }

        public Builder cacerts(Cacerts cacerts) {
            this.config.cacerts = cacerts;
            return this;
        }

        public Builder iosSdkVersion(String sdkVersion) {
            this.config.iosSdkVersion = sdkVersion;
            return this;
        }

        public Builder iosDeviceType(String deviceType) {
            this.config.iosDeviceType = deviceType;
            return this;
        }

        public Builder iosInfoPList(File infoPList) {
            this.config.iosInfoPList = infoPList;
            return this;
        }

        public Builder iosEntitlementsPList(File entitlementsPList) {
            this.config.iosEntitlementsPList = entitlementsPList;
            return this;
        }

        public Builder iosResourceRulesPList(File resourceRulesPList) {
            this.config.iosResourceRulesPList = resourceRulesPList;
            return this;
        }

        public Builder iosSignIdentity(SigningIdentity signIdentity) {
            this.config.iosSignIdentity = signIdentity;
            return this;
        }

        public Builder iosProvisioningProfile(ProvisioningProfile iosProvisioningProfile) {
            this.config.iosProvisioningProfile = iosProvisioningProfile;
            return this;
        }

        public Builder iosSkipSigning(boolean b) {
            this.config.iosSkipSigning = b;
            return this;
        }

        public Builder addCompilerPlugin(CompilerPlugin compilerPlugin) {
            this.config.plugins.add(compilerPlugin);
            return this;
        }

        public Builder addLaunchPlugin(LaunchPlugin plugin) {
            this.config.plugins.add(plugin);
            return this;
        }

        public void addPluginArgument(String argName) {
            if (this.config.pluginArguments == null) {
                this.config.pluginArguments = new ArrayList();
            }
            this.config.pluginArguments.add(argName);
        }

        public Config build() throws IOException {
            return this.config.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(File file) throws IOException {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                this.read(reader, file.getAbsoluteFile().getParentFile());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
        }

        public void read(Reader reader, File wd) throws IOException {
            try {
                Serializer serializer = this.createSerializer(wd);
                serializer.read(this.config, reader);
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
            if (this.config.roots != null && !this.config.roots.isEmpty()) {
                if (this.config.forceLinkClasses == null) {
                    this.config.forceLinkClasses = new ArrayList();
                }
                this.config.forceLinkClasses.addAll(this.config.roots);
                this.config.roots = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File file) throws IOException {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                this.write(writer, file.getAbsoluteFile().getParentFile());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }

        public void write(Writer writer, File wd) throws IOException {
            try {
                Serializer serializer = this.createSerializer(wd);
                serializer.write((Object)this.config, writer);
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        private Serializer createSerializer(File wd) throws Exception {
            RelativeFileConverter fileConverter = new RelativeFileConverter(wd);
            Persister resourceSerializer = new Persister((Strategy)new RegistryStrategy(new Registry().bind(File.class, fileConverter)), (Filter)new PlatformFilter(this.config.properties), new Format(2));
            Registry registry = new Registry();
            RegistryStrategy registryStrategy = new RegistryStrategy(registry);
            Persister serializer = new Persister((Strategy)registryStrategy, (Filter)new PlatformFilter(this.config.properties), new Format(2));
            registry.bind(File.class, fileConverter);
            registry.bind(Lib.class, new RelativeLibConverter(fileConverter));
            registry.bind(Resource.class, new ResourceConverter(fileConverter, resourceSerializer));
            return serializer;
        }

        public Map<String, PluginArgument> fetchPluginArguments() {
            TreeMap<String, PluginArgument> args = new TreeMap<String, PluginArgument>();
            for (Plugin plugin : this.config.plugins) {
                for (PluginArgument arg : plugin.getArguments().getArguments()) {
                    args.put(plugin.getArguments().getPrefix() + ":" + arg.getName(), arg);
                }
            }
            return args;
        }

        public List<Plugin> getPlugins() {
            return this.config.getPlugins();
        }
    }

    public static class Home {
        private File binDir = null;
        private File libVmDir = null;
        private File rtPath = null;
        private Map<Cacerts, File> cacertsPath = null;
        private boolean dev = false;

        public Home(File homeDir) {
            this(homeDir, true);
        }

        protected Home(File homeDir, boolean validate) {
            if (validate) {
                Home.validate(homeDir);
            }
            this.binDir = new File(homeDir, "bin");
            this.libVmDir = new File(homeDir, "lib/vm");
            this.rtPath = new File(homeDir, "lib/robovm-rt.jar");
            this.cacertsPath = new HashMap<Cacerts, File>();
            this.cacertsPath.put(Cacerts.full, new File(homeDir, "lib/robovm-cacerts-full.jar"));
        }

        private Home(File devDir, File binDir, File libVmDir, File rtPath) {
            this.binDir = binDir;
            this.libVmDir = libVmDir;
            this.rtPath = rtPath;
            this.cacertsPath = new HashMap<Cacerts, File>();
            this.cacertsPath.put(Cacerts.full, new File(devDir, "cacerts/full/target/robovm-cacerts-full-" + Version.getVersion() + ".jar"));
            this.dev = true;
        }

        public boolean isDev() {
            return this.dev;
        }

        public File getBinDir() {
            return this.binDir;
        }

        public File getLibVmDir() {
            return this.libVmDir;
        }

        public File getRtPath() {
            return this.rtPath;
        }

        public File getCacertsPath(Cacerts cacerts) {
            return this.cacertsPath.get((Object)cacerts);
        }

        public static Home find() {
            if (System.getenv("ROBOVM_DEV_ROOT") != null) {
                File dir = new File(System.getenv("ROBOVM_DEV_ROOT"));
                return Home.validateDevRootDir(dir);
            }
            if (System.getenv("ROBOVM_HOME") != null) {
                File dir = new File(System.getenv("ROBOVM_HOME"));
                return new Home(dir);
            }
            ArrayList<File> candidates = new ArrayList<File>();
            File userHome = new File(System.getProperty("user.home"));
            candidates.add(new File(userHome, "Applications/robovm"));
            candidates.add(new File(userHome, ".robovm/home"));
            candidates.add(new File("/usr/local/lib/robovm"));
            candidates.add(new File("/opt/robovm"));
            candidates.add(new File("/usr/lib/robovm"));
            for (File dir : candidates) {
                if (!dir.exists()) continue;
                return new Home(dir);
            }
            throw new IllegalArgumentException("ROBOVM_HOME not set and no RoboVM installation found in " + candidates);
        }

        public static void validate(File dir) {
            String error = "Path " + dir + " is not a valid RoboVM install directory: ";
            if (!dir.exists()) {
                throw new IllegalArgumentException(error + "no such path");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(error + "not a directory");
            }
            File libDir = new File(dir, "lib");
            if (!libDir.exists() || !libDir.isDirectory()) {
                throw new IllegalArgumentException(error + "lib/ missing or invalid");
            }
            File binDir = new File(dir, "bin");
            if (!binDir.exists() || !binDir.isDirectory()) {
                throw new IllegalArgumentException(error + "bin/ missing or invalid");
            }
            File libVmDir = new File(libDir, "vm");
            if (!libVmDir.exists() || !libVmDir.isDirectory()) {
                throw new IllegalArgumentException(error + "lib/vm/ missing or invalid");
            }
            File rtJarFile = new File(libDir, "robovm-rt.jar");
            if (!rtJarFile.exists() || !rtJarFile.isFile()) {
                throw new IllegalArgumentException(error + "lib/robovm-rt.jar missing or invalid");
            }
            try {
                String thisVersion = Version.getVersion();
                String thatVersion = Config.getImplementationVersion(rtJarFile);
                if (thisVersion == null || thatVersion == null || !thisVersion.equals(thatVersion)) {
                    throw new IllegalArgumentException(error + "version mismatch (expected: " + thisVersion + ", was: " + thatVersion + ")");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(error + "failed to get version of rt jar", e);
            }
        }

        private static Home validateDevRootDir(File dir) {
            String error = "Path " + dir + " is not a valid RoboVM source tree: ";
            if (!dir.exists()) {
                throw new IllegalArgumentException(error + "no such path");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(error + "not a directory");
            }
            File vmBinariesDir = new File(dir, "vm/target/binaries");
            if (!vmBinariesDir.exists() || !vmBinariesDir.isDirectory()) {
                throw new IllegalArgumentException(error + "vm/target/binaries/ missing or invalid");
            }
            File binDir = new File(dir, "bin");
            if (!binDir.exists() || !binDir.isDirectory()) {
                throw new IllegalArgumentException(error + "bin/ missing or invalid");
            }
            String rtJarName = "robovm-rt-" + Version.getVersion() + ".jar";
            File rtJar = new File(dir, "rt/target/" + rtJarName);
            File rtClasses = new File(dir, "rt/target/classes/");
            File rtSource = rtJar;
            if (!rtJar.exists() || rtJar.isDirectory()) {
                if (!rtClasses.exists() || rtClasses.isFile()) {
                    throw new IllegalArgumentException(error + "rt/target/" + rtJarName + " missing or invalid");
                }
                rtSource = rtClasses;
            }
            return new Home(dir, binDir, vmBinariesDir, rtSource);
        }
    }

    public static enum TargetType {
        console,
        ios;

    }

    public static enum Cacerts {
        full;

    }
}

