/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import org.robovm.compiler.config.Arch;
import org.robovm.llvm.Target;

public enum OS {
    linux,
    macosx,
    ios;


    public boolean isReturnedInRegisters(Arch arch, int size) {
        switch (arch) {
            case thumbv7: {
                return size <= 4;
            }
            case x86: {
                switch (this) {
                    case macosx: 
                    case ios: {
                        return size == 1 || size == 2 || size == 4 || size == 8;
                    }
                    case linux: {
                        return false;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown arch: " + (Object)((Object)arch));
    }

    public Family getFamily() {
        return this == linux ? Family.linux : Family.darwin;
    }

    public static OS getDefaultOS() {
        String hostTriple = Target.getHostTriple();
        if (hostTriple.contains("linux")) {
            return linux;
        }
        if (hostTriple.contains("darwin") || hostTriple.contains("apple")) {
            return macosx;
        }
        throw new IllegalArgumentException("Unrecognized OS in host triple: " + hostTriple);
    }

    public static enum Family {
        linux,
        darwin;

    }
}

