/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.robovm.compiler.util.AntPathMatcher;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class Resource {
    private static final AntPathMatcher MATCH_ALL_MATCHER = new AntPathMatcher("**/*");
    private static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.git", "**/.git/**", "**/.gitattributes", "**/.gitignore", "**/.gitmodules", "**/.hg", "**/.hg/**", "**/.hgignore", "**/.hgsub", "**/.hgsubstate", "**/.hgtags", "**/.bzr", "**/.bzr/**", "**/.bzrignore", "**/.DS_Store"};
    private static final List<AntPathMatcher> DEFAULTEXCLUDESMATCHERS = Resource.toAntPathMatchers(Arrays.asList(DEFAULTEXCLUDES));
    @Element(required=false)
    private String targetPath;
    @Element(required=false)
    private File directory;
    @ElementList(required=false, entry="include")
    private ArrayList<String> includes;
    @ElementList(required=false, entry="exclude")
    private ArrayList<String> excludes;
    @Element(required=false)
    private Boolean flatten;
    @Element(required=false)
    private Boolean ignoreDefaultExcludes;
    @Element(required=false)
    private Boolean skipPngCrush;
    @Element(required=false)
    private File path;

    protected Resource() {
    }

    public Resource(File path) {
        this.path = path;
    }

    public Resource(File directory, String targetPath) {
        this.directory = directory;
        this.targetPath = targetPath;
    }

    public File getPath() {
        return this.path;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<String> getIncludes() {
        return this.includes != null ? Collections.unmodifiableList(this.includes) : Collections.emptyList();
    }

    public Resource include(String ... patterns) {
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        this.includes.addAll(Arrays.asList(patterns));
        return this;
    }

    public List<String> getExcludes() {
        return this.excludes != null ? Collections.unmodifiableList(this.excludes) : Collections.emptyList();
    }

    public Resource exclude(String ... patterns) {
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        this.excludes.addAll(Arrays.asList(patterns));
        return this;
    }

    public boolean isFlatten() {
        return this.flatten == null ? false : this.flatten;
    }

    public Resource flatten(boolean b) {
        this.flatten = b;
        return this;
    }

    public boolean isIgnoreDefaultExcludes() {
        return this.ignoreDefaultExcludes == null ? false : this.ignoreDefaultExcludes;
    }

    public Resource ignoreDefaultExcludes(boolean b) {
        this.ignoreDefaultExcludes = b;
        return this;
    }

    public boolean isSkipPngCrush() {
        return this.skipPngCrush == null ? false : this.skipPngCrush;
    }

    public Resource skipPngCrush(boolean b) {
        this.skipPngCrush = b;
        return this;
    }

    public void walk(Walker walker, File destDir) throws IOException {
        if (this.targetPath != null && this.targetPath.trim().length() > 0) {
            destDir = new File(destDir, this.targetPath);
        }
        if (this.path != null) {
            this.walk(walker, this.path.getParentFile(), this.path.getName(), destDir, Collections.singletonList(MATCH_ALL_MATCHER), DEFAULTEXCLUDESMATCHERS);
        } else {
            ArrayList<AntPathMatcher> inc = Resource.toAntPathMatchers(this.includes);
            if (inc.isEmpty()) {
                inc.add(MATCH_ALL_MATCHER);
            }
            ArrayList<AntPathMatcher> exc = Resource.toAntPathMatchers(this.excludes);
            if (!this.isIgnoreDefaultExcludes()) {
                exc.addAll(DEFAULTEXCLUDESMATCHERS);
            }
            File dir = null;
            dir = this.directory != null ? this.directory.getCanonicalFile() : new File("").getCanonicalFile();
            if (dir.exists() && dir.isDirectory()) {
                for (File f : dir.listFiles()) {
                    this.walk(walker, dir, f.getName(), destDir, inc, exc);
                }
            }
        }
    }

    private void walk(Walker walker, File baseDir, String path, File destDir, List<AntPathMatcher> inc, List<AntPathMatcher> exc) throws IOException {
        File f = new File(baseDir, path);
        if ((f.isDirectory() || this.matches(path, inc)) && !this.matches(path, exc)) {
            if (f.isFile()) {
                walker.process(this, f, destDir);
            } else if (f.isDirectory()) {
                File newDestDir = destDir;
                if (!this.isFlatten()) {
                    newDestDir = new File(destDir, f.getName());
                }
                for (File child : f.listFiles()) {
                    this.walk(walker, baseDir, path + File.separator + child.getName(), newDestDir, inc, exc);
                }
            }
        }
    }

    private static ArrayList<AntPathMatcher> toAntPathMatchers(List<String> listOfStrings) {
        ArrayList<AntPathMatcher> l = new ArrayList<AntPathMatcher>();
        if (listOfStrings != null) {
            for (String pattern : listOfStrings) {
                l.add(new AntPathMatcher(pattern));
            }
        }
        return l;
    }

    private boolean matches(String path, List<AntPathMatcher> matchers) {
        for (AntPathMatcher matcher : matchers) {
            if (!matcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.flatten == null ? 0 : this.flatten.hashCode());
        result = 31 * result + (this.ignoreDefaultExcludes == null ? 0 : this.ignoreDefaultExcludes.hashCode());
        result = 31 * result + (this.includes == null ? 0 : this.includes.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.skipPngCrush == null ? 0 : this.skipPngCrush.hashCode());
        result = 31 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            return false;
        }
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        if (this.flatten == null ? other.flatten != null : !this.flatten.equals(other.flatten)) {
            return false;
        }
        if (this.ignoreDefaultExcludes == null ? other.ignoreDefaultExcludes != null : !this.ignoreDefaultExcludes.equals(other.ignoreDefaultExcludes)) {
            return false;
        }
        if (this.includes == null ? other.includes != null : !this.includes.equals(other.includes)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.skipPngCrush == null ? other.skipPngCrush != null : !this.skipPngCrush.equals(other.skipPngCrush)) {
            return false;
        }
        return !(this.targetPath == null ? other.targetPath != null : !this.targetPath.equals(other.targetPath));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [targetPath=").append(this.targetPath).append(", directory=").append(this.directory).append(", includes=").append(this.includes).append(", excludes=").append(this.excludes).append(", flatten=").append(this.flatten).append(", ignoreDefaultExcludes=").append(this.ignoreDefaultExcludes).append(", skipPngCrush=").append(this.skipPngCrush).append(", path=").append(this.path).append("]");
        return builder.toString();
    }

    public static interface Walker {
        public void process(Resource var1, File var2, File var3) throws IOException;
    }
}

