/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.hash;

import java.util.LinkedList;
import java.util.List;
import org.robovm.compiler.hash.HashFunction;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;

public class HashTableGenerator<K, V extends Constant> {
    private final HashFunction<K> function;
    private List<Entry<K, V>>[] table;
    private int tableSize;
    private int count = 0;
    private IntegerType indexType = Type.I16;
    private double loadFactor;

    public HashTableGenerator(HashFunction<K> function) {
        this(function, 4, 0.75);
    }

    public HashTableGenerator(HashFunction<K> function, int tableSize) {
        this(function, tableSize, 0.75);
    }

    public HashTableGenerator(HashFunction<K> function, int tableSize, double loadFactor) {
        this.function = function;
        this.tableSize = tableSize;
        this.loadFactor = loadFactor;
        this.allocateTable();
    }

    private void allocateTable() {
        this.table = new List[1 << this.tableSize];
    }

    public void put(K k, V v) {
        int h = this.function.hash(k);
        this.putNoRehash(new Entry<K, V>(h, k, v));
        if ((double)this.count > this.loadFactor * (double)this.table.length) {
            this.rehash();
        }
    }

    private void rehash() {
        List<Entry<K, V>>[] oldTable = this.table;
        ++this.tableSize;
        this.count = 0;
        this.allocateTable();
        for (int i = 0; i < oldTable.length; ++i) {
            if (oldTable[i] == null) continue;
            for (Entry<K, V> entry : oldTable[i]) {
                this.putNoRehash(entry);
            }
        }
    }

    private void putNoRehash(Entry<K, V> entry) {
        int idx = entry.h & (1 << this.tableSize) - 1;
        if (this.table[idx] == null) {
            this.table[idx] = new LinkedList<Entry<K, V>>();
        }
        for (Entry<K, V> e : this.table[idx]) {
            if (e.h != entry.h || !e.k.equals(entry.k)) continue;
            e.v = entry.v;
            return;
        }
        this.table[idx].add(entry);
        ++this.count;
    }

    public StructureConstant generate() {
        int i;
        StructureConstantBuilder builder = new StructureConstantBuilder();
        int start = 0;
        builder.add(new IntegerConstant(this.count));
        builder.add(new IntegerConstant(this.table.length, this.indexType));
        builder.add(new IntegerConstant(start, this.indexType));
        for (i = 1; i <= this.table.length; ++i) {
            if (this.table[i - 1] == null) {
                builder.add(new IntegerConstant(start, this.indexType));
                continue;
            }
            builder.add(new IntegerConstant(start += this.table[i - 1].size(), this.indexType));
        }
        for (i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            for (Entry<K, V> entry : this.table[i]) {
                builder.add((Value)entry.v);
            }
        }
        return builder.build();
    }

    private static class Entry<K, V> {
        int h;
        K k;
        V v;

        Entry(int h, K k, V v) {
            this.h = h;
            this.k = k;
            this.v = v;
        }

        public int hashCode() {
            return this.h;
        }

        public boolean equals(Object obj) {
            Entry e = (Entry)obj;
            return !(this.h != e.h || this.k != e.k && !this.k.equals(e.k) || this.v != e.v && !this.v.equals(e.v));
        }
    }
}

