/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.ArrayList;
import java.util.List;
import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;

public class ArrayConstantBuilder {
    private final Type type;
    private final List<Value> values = new ArrayList<Value>();

    public ArrayConstantBuilder(Type type) {
        this.type = type;
    }

    public ArrayConstantBuilder add(Value v) {
        if (!v.getType().equals(this.type)) {
            throw new IllegalArgumentException("Wrong type. Was " + v.getType() + ". Expected " + this.type);
        }
        this.values.add(v);
        return this;
    }

    public ArrayConstantBuilder add(List<? extends Value> vs) {
        for (Value value : vs) {
            this.add(value);
        }
        return this;
    }

    public ArrayConstantBuilder add(int ... values) {
        for (int v : values) {
            this.add(new IntegerConstant(v));
        }
        return this;
    }

    public ArrayConstant build() {
        return new ArrayConstant(new ArrayType(this.values.size(), this.type), this.values.toArray(new Value[this.values.size()]));
    }
}

