/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Collections;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;

public class Br
extends Instruction {
    private final Value cond;
    private final BasicBlockRef destTrue;
    private final BasicBlockRef destFalse;

    public Br(BasicBlockRef dest) {
        this.cond = null;
        this.destTrue = dest;
        this.destFalse = null;
    }

    public Br(Value cond, BasicBlockRef destTrue, BasicBlockRef destFalse) {
        if (cond.getType() != Type.I1) {
            throw new IllegalArgumentException("Condition must have type " + Type.I1);
        }
        this.cond = cond;
        this.destTrue = destTrue;
        this.destFalse = destFalse;
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        if (this.cond instanceof VariableRef) {
            return Collections.singleton((VariableRef)this.cond);
        }
        return super.getReadsFrom();
    }

    public String toString() {
        if (this.cond != null) {
            return "br i1 " + this.cond + ", label %" + this.destTrue.getName() + ", label %" + this.destFalse.getName();
        }
        return "br label %" + this.destTrue.getName();
    }
}

