/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.BinaryOpInstruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public abstract class FloatingPointBinaryInstruction
extends BinaryOpInstruction {
    private final String name;

    protected FloatingPointBinaryInstruction(String name, Variable result, Value op1, Value op2) {
        super(result, op1, op2);
        if (!(result.isFloatingPoint() && op1.isFloatingPoint() && op2.isFloatingPoint())) {
            throw new IllegalArgumentException("Floating point type expected");
        }
        if (!result.getType().equals(op1.getType()) || !op1.getType().equals(op2.getType())) {
            throw new IllegalArgumentException("Type mismatch ");
        }
        this.name = name;
    }

    public String toString() {
        return this.result + " = " + this.name + " " + this.op1.getType() + " " + this.op1 + ", " + this.op2;
    }
}

