/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robovm.compiler.llvm.Argument;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.ParameterAttribute;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import org.robovm.compiler.llvm.VariableRef;

public abstract class FunctionCallInstruction
extends Instruction {
    private final String name;
    private final Variable result;
    private final Value function;
    private final Argument[] args;

    protected FunctionCallInstruction(String name, Value function, Value ... args) {
        this(name, (Variable)null, function, args);
    }

    protected FunctionCallInstruction(String name, Value function, Argument ... args) {
        this(name, null, function, args);
    }

    protected FunctionCallInstruction(String name, Variable result, Value function, Value ... args) {
        this(name, result, function, FunctionCallInstruction.valuesToArgs(args));
    }

    protected FunctionCallInstruction(String name, Variable result, Value function, Argument ... args) {
        if (!function.isFunction()) {
            throw new IllegalArgumentException("Function type expected");
        }
        this.name = name;
        this.result = result;
        this.function = function;
        this.args = args;
    }

    private static Argument[] valuesToArgs(Value[] values) {
        Argument[] arguments = new Argument[values.length];
        for (int i = 0; i < values.length; ++i) {
            arguments[i] = new Argument(values[i], new ParameterAttribute[0]);
        }
        return arguments;
    }

    @Override
    public Set<Variable> getWritesTo() {
        if (this.result != null) {
            return Collections.singleton(this.result);
        }
        return super.getWritesTo();
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        HashSet<VariableRef> s = new HashSet<VariableRef>();
        for (Argument a : this.args) {
            if (!(a.getValue() instanceof VariableRef)) continue;
            s.add((VariableRef)a.getValue());
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCallInstruction other = (FunctionCallInstruction)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.result == null ? other.result != null : !this.result.equals(other.result));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.result != null) {
            sb.append(this.result.toString());
            sb.append(" = ");
        }
        sb.append(this.name);
        sb.append(' ');
        FunctionType ftype = (FunctionType)this.function.getType();
        sb.append(ftype.isVarargs() ? ftype.getDefinition() : ftype.getReturnType().toString());
        sb.append(" ");
        sb.append(this.function.toString());
        sb.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.args[i].getType());
            sb.append(' ');
            sb.append(this.args[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

