/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Arrays;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Type;

public class StructureType
extends AggregateType {
    private final Type[] types;

    public StructureType(Type ... types) {
        this.types = (Type[])types.clone();
    }

    public StructureType(String alias, Type ... types) {
        super(alias);
        this.types = (Type[])types.clone();
    }

    @Override
    public Type getTypeAt(int index) {
        return this.types[index];
    }

    @Override
    public String getDefinition() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.types[i].toString());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureType other = (StructureType)obj;
        return Arrays.equals(this.types, other.types);
    }
}

