/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.lambda.SCallSite;
import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodHandle;
import org.robovm.compiler.plugin.lambda.SMethodHandleInfo;
import org.robovm.compiler.plugin.lambda.SMethodHandles;
import org.robovm.compiler.plugin.lambda.SMethodType;
import org.robovm.compiler.plugin.lambda.SootSClass;
import org.robovm.compiler.plugin.lambda.SootSClassLookup;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.LambdaConversionException;
import org.robovm.compiler.plugin.lambda.java.lang.invoke.LambdaMetafactory;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodHandle;
import soot.SootMethodRef;
import soot.SootMethodType;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;

public class LambdaPlugin
extends AbstractCompilerPlugin {
    private static boolean isLambdaBootstrapMethod(SootMethodRef methodRef) {
        return methodRef.declaringClass().getName().equals("java.lang.invoke.LambdaMetafactory") && (methodRef.name().equals("metafactory") || methodRef.name().equals("altMetafactory"));
    }

    private static SMethodType toSMethodType(SootMethodRef ref) {
        return new SMethodType(SootSClass.forType(ref.returnType()), SootSClass.forTypes(ref.parameterTypes()));
    }

    private static SMethodType toSMethodType(SootMethodType t) {
        return new SMethodType(SootSClass.forType(t.getReturnType()), SootSClass.forTypes(t.getParameterTypes()));
    }

    private static SMethodHandle toSMethodHandle(SootMethodHandle h) {
        return new SMethodHandle(LambdaPlugin.toSMethodType(h.getMethodType()), new SMethodHandleInfo(SootSClass.forType(h.getMethodRef().declaringClass().getType()), h.getMethodRef().name(), LambdaPlugin.toSMethodType(h.getMethodRef()), h.getReferenceKind()));
    }

    private static Type toSootType(SClass<?> type) {
        if (type instanceof SootSClass) {
            return ((SootSClass)type).type;
        }
        SootSClassLookup lookup = (SootSClassLookup)SClass.getLookup();
        return ((SootSClass)lookup.lookup((String)type.getDescriptor())).type;
    }

    private static List<Type> toSootTypes(List<SClass<?>> types) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (SClass<?> type : types) {
            result.add(LambdaPlugin.toSootType(type));
        }
        return result;
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        SootClass sootClass = clazz.getSootClass();
        for (SootMethod method : sootClass.getMethods()) {
            this.transformMethod(config, clazz, sootClass, method, moduleBuilder);
        }
    }

    private void transformMethod(Config config, Clazz clazz, SootClass sootClass, SootMethod method, ModuleBuilder moduleBuilder) throws IOException {
        if (!method.isConcrete()) {
            return;
        }
        SClass.setLookup(new SootSClassLookup());
        int tmpCounter = 0;
        Body body = method.retrieveActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        Object unit = units.getFirst();
        while (unit != null) {
            DynamicInvokeExpr expr;
            if (unit instanceof DefinitionStmt && ((DefinitionStmt)unit).getRightOp() instanceof DynamicInvokeExpr && LambdaPlugin.isLambdaBootstrapMethod((expr = (DynamicInvokeExpr)((DefinitionStmt)unit).getRightOp()).getBootstrapMethodRef())) {
                List<Value> bsmArgs = expr.getBootstrapArgs();
                SMethodHandles.Lookup caller = new SMethodHandles.Lookup(SootSClass.forType(sootClass.getType()));
                String invokedName = expr.getMethodRef().name();
                SMethodType invokedType = LambdaPlugin.toSMethodType(expr.getMethodRef());
                SMethodType samMethodType = LambdaPlugin.toSMethodType((SootMethodType)bsmArgs.get(0));
                SMethodHandle implMethod = LambdaPlugin.toSMethodHandle((SootMethodHandle)bsmArgs.get(1));
                SMethodType instantiatedMethodType = LambdaPlugin.toSMethodType((SootMethodType)bsmArgs.get(2));
                try {
                    SCallSite callSite = null;
                    callSite = expr.getBootstrapMethodRef().name().equals("altMetafactory") ? this.altMetafactory(caller, invokedName, invokedType, samMethodType, implMethod, instantiatedMethodType, bsmArgs) : LambdaMetafactory.metafactory(caller, invokedName, invokedType, samMethodType, implMethod, instantiatedMethodType);
                    File f = clazz.getPath().getGeneratedClassFile(callSite.getLambdaClassName());
                    FileUtils.writeByteArrayToFile(f, callSite.getClassData());
                    f.setLastModified(clazz.lastModified());
                    SootClass lambdaClass = SootResolver.v().makeClassRef(callSite.getLambdaClassName().replace('/', '.'));
                    Local l = (Local)((DefinitionStmt)unit).getLeftOp();
                    Type samType = LambdaPlugin.toSootType(callSite.getTargetMethodType().returnType());
                    LinkedList<Stmt> newUnits = new LinkedList<Stmt>();
                    if (callSite.getTargetMethodName().equals("<init>")) {
                        String fieldName = lambdaClass.getName().substring(lambdaClass.getName().lastIndexOf(46) + 1);
                        SootField field = new SootField(fieldName, lambdaClass.getType(), 4234);
                        method.getDeclaringClass().addField(field);
                        newUnits.add(Jimple.v().newAssignStmt(l, Jimple.v().newStaticFieldRef(field.makeRef())));
                        newUnits.add(Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(l, NullConstant.v()), units.getSuccOf((Unit)unit)));
                        Local tmp = Jimple.v().newLocal("$tmp" + tmpCounter++, lambdaClass.getType());
                        body.getLocals().add(tmp);
                        newUnits.add(Jimple.v().newAssignStmt(tmp, Jimple.v().newNewExpr(lambdaClass.getType())));
                        newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(tmp, Scene.v().makeConstructorRef(lambdaClass, Collections.emptyList()))));
                        newUnits.add(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(field.makeRef()), tmp));
                        newUnits.add(Jimple.v().newAssignStmt(l, tmp));
                    } else {
                        newUnits.add(Jimple.v().newAssignStmt(l, Jimple.v().newStaticInvokeExpr(Scene.v().makeMethodRef(lambdaClass, callSite.getTargetMethodName(), LambdaPlugin.toSootTypes(callSite.getTargetMethodType().parameterList()), samType, true), expr.getArgs())));
                    }
                    units.insertAfter(newUnits, (Unit)unit);
                    units.remove(unit);
                    unit = (Unit)newUnits.getLast();
                }
                catch (LambdaConversionException e) {
                    throw new CompilerException(e);
                }
            }
            unit = body.getUnits().getSuccOf((Unit)unit);
        }
    }

    private SCallSite altMetafactory(SMethodHandles.Lookup caller, String invokedName, SMethodType invokedType, SMethodType samMethodType, SMethodHandle implMethod, SMethodType instantiatedMethodType, List<Value> bsmArgs) throws LambdaConversionException {
        int i;
        int count;
        int flags = ((IntConstant)bsmArgs.get((int)3)).value;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(samMethodType);
        args.add(implMethod);
        args.add(instantiatedMethodType);
        args.add(flags);
        int bsmArgsIdx = 4;
        if ((flags & 2) > 0) {
            count = ((IntConstant)bsmArgs.get((int)bsmArgsIdx++)).value;
            args.add(count);
            for (i = 0; i < count; ++i) {
                args.add(SootSClass.forType((Type)((Object)bsmArgs.get(bsmArgsIdx++))));
            }
        }
        if ((flags & 4) > 0) {
            count = ((IntConstant)bsmArgs.get((int)bsmArgsIdx++)).value;
            args.add(count);
            for (i = 0; i < count; ++i) {
                args.add(LambdaPlugin.toSMethodType((SootMethodType)bsmArgs.get(bsmArgsIdx++)));
            }
        }
        return LambdaMetafactory.altMetafactory(caller, invokedName, invokedType, args.toArray());
    }
}

