/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import org.robovm.compiler.plugin.lambda.SClass;
import org.robovm.compiler.plugin.lambda.SMethodType;

public class SMethodHandleInfo {
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;
    private final SClass<?> declaringClass;
    private final String name;
    private final SMethodType methodType;
    private final int referenceKind;

    public SMethodHandleInfo(SClass<?> declaringClass, String name, SMethodType methodType, int referenceKind) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.methodType = methodType;
        this.referenceKind = referenceKind;
    }

    public SClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public SMethodType getMethodType() {
        return this.methodType;
    }

    public int getReferenceKind() {
        return this.referenceKind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.referenceKind) {
            case 5: {
                sb.append("InvokeVirtual");
                break;
            }
            case 6: {
                sb.append("InvokeStatic");
                break;
            }
            case 7: {
                sb.append("InvokeSpecial");
                break;
            }
            case 8: {
                sb.append("NewInvokeSpecial");
                break;
            }
            case 9: {
                sb.append("InvokeInterface");
            }
        }
        return sb.append('(').append(this.declaringClass).append('.').append(this.name).append(this.methodType).append(')').toString();
    }
}

